/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.util;

import javax.annotation.Nullable;
import org.gbif.api.vocabulary.IdentifierType;

public class IdentifierUtils {
    @Nullable
    public static String getIdentifierLink(String identifier, IdentifierType type) {
        if (identifier == null || type == null) {
            return null;
        }
        switch (type) {
            case HANDLER: 
            case URI: 
            case URL: 
            case FTP: {
                return identifier;
            }
            case DOI: {
                return "http://dx.doi.org/" + identifier;
            }
            case LSID: {
                return "http://lsid.tdwg.org/summary/" + identifier;
            }
            case GBIF_PORTAL: {
                return "http://data.gbif.org/datasets/resource/" + identifier;
            }
        }
        return null;
    }
}

