/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.registry.eml.geospatial;

import java.io.Serializable;
import java.util.Locale;
import org.gbif.api.model.registry.eml.geospatial.Geometry;

public class BoundingBox
implements Serializable,
Geometry {
    private static final long serialVersionUID = 9101833933868378174L;
    private static final int MIN_MIN_LONGITUDE = -180;
    private static final int MAX_MAX_LONGITUDE = 180;
    private static final int MIN_MIN_LATITUDE = -90;
    private static final int MAX_MAX_LATITUDE = 90;
    private double minLatitude;
    private double maxLatitude;
    private double minLongitude;
    private double maxLongitude;
    private boolean isGlobalCoverage;

    public BoundingBox() {
    }

    public BoundingBox(double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        this.minLatitude = minLatitude;
        this.maxLatitude = maxLatitude;
        this.minLongitude = minLongitude;
        this.maxLongitude = maxLongitude;
        this.isGlobalCoverage = this.checkIsGlobalCoverage(minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public void setMaxLatitude(double maxLatitude) {
        this.maxLatitude = maxLatitude;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitude(double maxLongitude) {
        this.maxLongitude = maxLongitude;
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public void setMinLatitude(double minLatitude) {
        this.minLatitude = minLatitude;
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitude(double minLongitude) {
        this.minLongitude = minLongitude;
    }

    @Override
    public String toWellKnownText() {
        return String.format(Locale.ENGLISH, "POLYGON ((%f %f, %f %f, %f %f, %f %f))", this.minLongitude, this.minLatitude, this.minLongitude, this.maxLatitude, this.maxLongitude, this.maxLatitude, this.maxLongitude, this.minLatitude);
    }

    public boolean isGlobalCoverage() {
        return this.isGlobalCoverage;
    }

    public void setGlobalCoverage(double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        this.isGlobalCoverage = this.checkIsGlobalCoverage(minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    private boolean checkIsGlobalCoverage(double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        return minLatitude == -90.0 && maxLatitude == 90.0 && minLongitude == -180.0 && maxLongitude == 180.0;
    }
}

