/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.crawler;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.vocabulary.Origin;
import org.gbif.api.vocabulary.Rank;

public class NormalizerStats {
    private final int roots;
    private final int depth;
    private final int synonyms;
    private final int ignored;
    private final Map<Origin, Integer> countByOrigin;
    private final Map<Rank, Integer> countByRank;
    private final List<String> cycles;

    @JsonCreator
    public NormalizerStats(@JsonProperty(value="roots") int roots, @JsonProperty(value="depth") int depth, @JsonProperty(value="synonyms") int synonyms, @JsonProperty(value="ignored") int ignored, @JsonProperty(value="countByOrigin") Map<Origin, Integer> countByOrigin, @JsonProperty(value="countByRank") Map<Rank, Integer> countByRank, @JsonProperty(value="cycles") List<String> cycles) {
        this.roots = roots;
        this.depth = depth;
        this.synonyms = synonyms;
        this.ignored = ignored;
        this.countByOrigin = countByOrigin;
        this.countByRank = countByRank;
        this.cycles = cycles;
    }

    public List<String> getCycles() {
        return this.cycles;
    }

    public int getCount() {
        int total = 0;
        for (int x : this.countByOrigin.values()) {
            total += x;
        }
        return total;
    }

    public int getRoots() {
        return this.roots;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getSynonyms() {
        return this.synonyms;
    }

    public int getIgnored() {
        return this.ignored;
    }

    public int getCountByRank(Rank rank) {
        if (this.countByRank.containsKey((Object)rank)) {
            return this.countByRank.get((Object)rank);
        }
        return 0;
    }

    public int getCountByOrigin(Origin o) {
        return this.countByOrigin.get((Object)o);
    }

    public Map<Origin, Integer> getCountByOrigin() {
        return this.countByOrigin;
    }

    public Map<Rank, Integer> getCountByRank() {
        return this.countByRank;
    }

    public String toString() {
        return "NormalizerStats{, roots=" + this.roots + ", depth=" + this.depth + ", synonyms=" + this.synonyms + ", ignored=" + this.ignored + ", cycles=" + this.cycles.size() + ", countByOrigin=" + this.countByOrigin + ", countByRank=" + this.countByRank + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.roots, this.depth, this.synonyms, this.ignored, this.cycles, this.countByOrigin, this.countByRank});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NormalizerStats other = (NormalizerStats)obj;
        return Objects.equal((Object)this.roots, (Object)other.roots) && Objects.equal((Object)this.depth, (Object)other.depth) && Objects.equal((Object)this.synonyms, (Object)other.synonyms) && Objects.equal((Object)this.ignored, (Object)other.ignored) && Objects.equal(this.cycles, other.cycles) && Objects.equal(this.countByOrigin, other.countByOrigin) && Objects.equal(this.countByRank, other.countByRank);
    }
}

