/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.crawler;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.vocabulary.EndpointType;

@Immutable
@ThreadSafe
public class CrawlJob {
    private final UUID datasetKey;
    private final EndpointType endpointType;
    private final URI targetUrl;
    private final int attempt;
    private final ImmutableMap<String, String> properties;

    @JsonCreator
    public CrawlJob(@JsonProperty(value="datasetKey") UUID datasetKey, @JsonProperty(value="endpointType") EndpointType endpointType, @JsonProperty(value="targetUrl") URI targetUrl, @JsonProperty(value="attempt") int attempt, @Nullable @JsonProperty(value="properties") Map<String, String> properties) {
        this.datasetKey = (UUID)Preconditions.checkNotNull((Object)datasetKey);
        this.endpointType = (EndpointType)((Object)Preconditions.checkNotNull((Object)((Object)endpointType)));
        this.targetUrl = (URI)Preconditions.checkNotNull((Object)targetUrl);
        Preconditions.checkArgument((attempt > 0 ? 1 : 0) != 0, (Object)"attempt has to be greater than 0");
        this.attempt = attempt;
        this.properties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
    }

    public CrawlJob(UUID datasetKey, Integer attempt, EndpointType endpointType, URI targetUrl) {
        this.datasetKey = datasetKey;
        this.attempt = attempt;
        this.endpointType = endpointType;
        this.targetUrl = targetUrl;
        this.properties = null;
    }

    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public URI getTargetUrl() {
        return this.targetUrl;
    }

    public int getAttempt() {
        return this.attempt;
    }

    @JsonIgnore
    public String getProperty(String name) {
        return (String)this.properties.get((Object)name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CrawlJob)) {
            return false;
        }
        CrawlJob other = (CrawlJob)obj;
        return Objects.equal((Object)this.datasetKey, (Object)other.datasetKey) && Objects.equal((Object)((Object)this.endpointType), (Object)((Object)other.endpointType)) && Objects.equal((Object)this.targetUrl, (Object)other.targetUrl) && Objects.equal((Object)this.attempt, (Object)other.attempt) && Objects.equal(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.datasetKey, this.endpointType, this.targetUrl, this.attempt, this.properties});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("datasetKey", (Object)this.datasetKey).add("endpointType", (Object)this.endpointType).add("targetUrl", (Object)this.targetUrl).add("attempt", this.attempt).add("properties", this.properties).toString();
    }
}

