/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.vocabulary.NamePart;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.Rank;

public class ParsedName {
    private static final Character HYBRID_MARKER = Character.valueOf('\u00d7');
    private static final String HYBRID_MARKER_STR = HYBRID_MARKER.toString();
    private Integer key;
    private String scientificName;
    private NameType type;
    private String genusOrAbove;
    private String infraGeneric;
    private String specificEpithet;
    private String infraSpecificEpithet;
    private String cultivarEpithet;
    private String strain;
    private NamePart notho;
    private String rank;
    private boolean authorsParsed = true;
    private String authorship;
    private String year;
    private String bracketAuthorship;
    private String bracketYear;
    private String sensu;
    private String nomStatus;
    private String remarks;

    public static String decompose(String x) {
        if (x == null) {
            return x;
        }
        return x.replaceAll("\u00e6", "ae").replaceAll("\u00c6", "Ae").replaceAll("\u0153", "oe").replaceAll("\u0152", "Oe").replaceAll("\u0132", "Ij").replaceAll("\u0133", "ij").replaceAll("\u01c8", "Lj").replaceAll("\u01c9", "lj").replaceAll("\u0238", "db").replaceAll("\u0239", "qp").replaceAll("\u00df", "ss").replaceAll("\ufb06", "st").replaceAll("\ufb00", "ff").replaceAll("\ufb01", "fi").replaceAll("\ufb02", "fl").replaceAll("\ufb03", "ffi").replaceAll("\ufb04", "ffl");
    }

    public ParsedName() {
    }

    public ParsedName(NameType type, String genusOrAbove, String infraGeneric, String specificEpithet, String infraSpecificEpithet, NamePart notho, String rank, String authorship, String year, String bracketAuthorship, String bracketYear, String cultivarEpithet, String strain, String sensu, String nomStatus, String remarks) {
        this.type = type;
        this.genusOrAbove = genusOrAbove;
        this.infraGeneric = infraGeneric;
        this.specificEpithet = specificEpithet;
        this.infraSpecificEpithet = infraSpecificEpithet;
        this.notho = notho;
        this.rank = rank;
        this.authorship = authorship;
        this.year = year;
        this.bracketAuthorship = bracketAuthorship;
        this.bracketYear = bracketYear;
        this.cultivarEpithet = cultivarEpithet;
        this.strain = strain;
        this.sensu = sensu;
        this.nomStatus = nomStatus;
        this.remarks = remarks;
    }

    public String getAuthorship() {
        return this.authorship;
    }

    public void setAuthorship(String authorship) {
        this.authorship = authorship;
    }

    public String getBracketAuthorship() {
        return this.bracketAuthorship;
    }

    public void setBracketAuthorship(String bracketAuthorship) {
        this.bracketAuthorship = bracketAuthorship;
    }

    public String getBracketYear() {
        return this.bracketYear;
    }

    public void setBracketYear(String bracketYear) {
        this.bracketYear = bracketYear;
    }

    public String getCultivarEpithet() {
        return this.cultivarEpithet;
    }

    public void setCultivarEpithet(String cultivarEpithet) {
        this.cultivarEpithet = cultivarEpithet;
    }

    public String getStrain() {
        return this.strain;
    }

    public void setStrain(String strain) {
        this.strain = strain;
    }

    public String getGenusOrAbove() {
        return this.genusOrAbove;
    }

    public String getInfraGeneric() {
        return this.infraGeneric;
    }

    public String getInfraSpecificEpithet() {
        return this.infraSpecificEpithet;
    }

    public String getNomStatus() {
        return this.nomStatus;
    }

    public void setNomStatus(String nomStatus) {
        this.nomStatus = nomStatus;
    }

    public NamePart getNotho() {
        return this.notho;
    }

    public void setNotho(NamePart notho) {
        this.notho = notho;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getSensu() {
        return this.sensu;
    }

    public void setSensu(String sensu) {
        this.sensu = sensu;
    }

    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    public NameType getType() {
        return this.type;
    }

    public void setType(NameType type) {
        this.type = type;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public boolean isAuthorsParsed() {
        return this.authorsParsed;
    }

    public void setAuthorsParsed(boolean authorsParsed) {
        this.authorsParsed = authorsParsed;
    }

    public void setRank(Rank rank) {
        this.rank = rank == null ? null : rank.getMarker();
    }

    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public String authorshipComplete() {
        StringBuilder sb = new StringBuilder();
        this.appendAuthorship(sb);
        return sb.toString().trim();
    }

    public String buildName(boolean hybridMarker, boolean rankMarker, boolean authorship, boolean subgenus, boolean abbreviateGenus, boolean decomposition, boolean showIndet, boolean nomNote, boolean remarks, boolean showSensu, boolean showCultivar, boolean showStrain) {
        return this.buildName(hybridMarker, rankMarker, authorship, subgenus, abbreviateGenus, decomposition, showIndet, nomNote, remarks, showSensu, showCultivar, showStrain, null);
    }

    public String buildName(boolean hybridMarker, boolean rankMarker, boolean authorship, boolean subgenus, boolean abbreviateGenus, boolean decomposition, boolean showIndet, boolean nomNote, boolean remarks, boolean showSensu, boolean showCultivar, boolean showStrain, @Nullable NomenclaturalCode code) {
        StringBuilder sb = new StringBuilder();
        Rank rnk = this.getRank();
        if (NameType.CANDIDATUS == this.type) {
            sb.append("Candidatus ");
        }
        if (this.genusOrAbove != null) {
            if (hybridMarker && NamePart.GENERIC == this.notho) {
                sb.append(HYBRID_MARKER);
            }
            if (abbreviateGenus) {
                sb.append(this.genusOrAbove.substring(0, 1)).append('.');
            } else {
                sb.append(this.genusOrAbove);
            }
        }
        if (this.specificEpithet == null) {
            if (Rank.SPECIES == rnk) {
                if (showIndet) {
                    sb.append(" spec.");
                }
            } else if (rnk != null && rnk.isInfraspecific()) {
                if (showIndet) {
                    sb.append(' ');
                    sb.append(rnk.getMarker());
                }
            } else if (this.infraGeneric != null) {
                if (rankMarker) {
                    if (this.rank == null) {
                        sb.append(' ').append(Rank.SUBGENUS.getMarker());
                    } else {
                        sb.append(' ').append(this.rank);
                    }
                }
                sb.append(' ').append(this.infraGeneric);
            }
            if (authorship) {
                this.appendAuthorship(sb);
            }
        } else {
            if (subgenus && this.infraGeneric != null && (this.rank == null || this.getRank() == Rank.GENUS)) {
                sb.append(" (");
                sb.append(this.infraGeneric);
                sb.append(')');
            }
            sb.append(' ');
            if (hybridMarker && NamePart.SPECIFIC == this.notho) {
                sb.append(HYBRID_MARKER);
            }
            String epi = this.specificEpithet.replaceAll("[ _-]", "-");
            sb.append(epi);
            if (this.infraSpecificEpithet == null) {
                if (showIndet && rnk != null && rnk.isInfraspecific() && (Rank.CULTIVAR != rnk || this.cultivarEpithet == null)) {
                    sb.append(' ');
                    sb.append(rnk.getMarker());
                }
                if (authorship) {
                    this.appendAuthorship(sb);
                }
            } else {
                String rm;
                sb.append(' ');
                if (hybridMarker && NamePart.INFRASPECIFIC == this.notho) {
                    if (rankMarker) {
                        sb.append("notho");
                    } else {
                        sb.append(HYBRID_MARKER);
                    }
                }
                if (rankMarker && (rm = this.getInfraspecificRankMarker(code)) != null) {
                    sb.append(rm);
                    sb.append(' ');
                }
                epi = this.infraSpecificEpithet.replaceAll("[ _-]", "-");
                sb.append(epi);
                if (authorship && !this.isAutonym()) {
                    this.appendAuthorship(sb);
                }
            }
        }
        if (showStrain && this.strain != null) {
            sb.append(" ");
            sb.append(this.strain);
        }
        if (showCultivar && this.cultivarEpithet != null) {
            sb.append(" '");
            sb.append(this.cultivarEpithet);
            sb.append("'");
        }
        if (showSensu && this.sensu != null) {
            sb.append(" ");
            sb.append(this.sensu);
        }
        if (nomNote && this.nomStatus != null) {
            sb.append(", ");
            sb.append(this.nomStatus);
        }
        if (remarks && this.remarks != null) {
            sb.append(" [");
            sb.append(this.remarks);
            sb.append("]");
        }
        if (decomposition) {
            return ParsedName.decompose(sb.toString().trim());
        }
        return sb.toString().trim();
    }

    private String getInfraspecificRankMarker(NomenclaturalCode code) {
        if (this.getRank() == Rank.SUBSPECIES && NomenclaturalCode.ZOOLOGICAL == code) {
            return null;
        }
        return this.rank;
    }

    private void appendAuthorship(StringBuilder sb) {
        if (this.bracketAuthorship == null) {
            if (this.bracketYear != null) {
                sb.append(" (");
                sb.append(this.bracketYear);
                sb.append(")");
            }
        } else {
            sb.append(" (");
            sb.append(this.bracketAuthorship);
            if (this.bracketYear != null) {
                sb.append(", ");
                sb.append(this.bracketYear);
            }
            sb.append(")");
        }
        if (this.authorship != null) {
            sb.append(" ").append(this.authorship);
        }
        if (this.year != null) {
            sb.append(", ");
            sb.append(this.year);
        }
    }

    @JsonProperty
    public String canonicalName() {
        return this.buildName(false, false, false, false, false, true, true, false, false, false, false, false);
    }

    @JsonProperty
    public String canonicalNameWithMarker() {
        return this.buildName(true, true, false, false, false, true, true, false, false, false, true, true);
    }

    @JsonProperty
    public String canonicalNameComplete() {
        return this.buildName(true, true, true, false, false, true, true, false, false, false, true, true);
    }

    public String canonicalSpeciesName() {
        if (this.genusOrAbove != null && this.specificEpithet != null) {
            return this.genusOrAbove + " " + this.specificEpithet;
        }
        return null;
    }

    public String fullName() {
        return this.buildName(true, true, true, true, false, false, true, true, true, true, true, true);
    }

    @JsonIgnore
    public Integer getBracketYearInt() {
        try {
            return Integer.parseInt(this.bracketYear);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @JsonIgnore
    public Rank getRank() {
        Rank rankEnum = Rank.inferRank(this.genusOrAbove, this.infraGeneric, this.specificEpithet, this.rank, this.infraSpecificEpithet);
        return Rank.UNRANKED == rankEnum ? null : rankEnum;
    }

    public String getRankMarker() {
        return this.rank;
    }

    @JsonIgnore
    public Integer getYearInt() {
        try {
            return Integer.parseInt(this.year);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @JsonIgnore
    public boolean isAutonym() {
        return this.specificEpithet != null && this.infraSpecificEpithet != null && this.specificEpithet.equals(this.infraSpecificEpithet);
    }

    @JsonIgnore
    public boolean isBinomial() {
        return this.genusOrAbove != null && this.specificEpithet != null;
    }

    @JsonIgnore
    public boolean isHybridFormula() {
        return NameType.HYBRID == this.type;
    }

    @JsonIgnore
    public boolean isIndetermined() {
        return this.rank != null && this.infraSpecificEpithet == null && (this.specificEpithet != null || this.infraGeneric == null);
    }

    @JsonIgnore
    public boolean isParsableType() {
        return this.type != null && this.type.isParsable();
    }

    @JsonIgnore
    public boolean isQualified() {
        return this.authorship != null && !this.authorship.isEmpty() || this.year != null && !this.year.isEmpty() || this.bracketAuthorship != null && !this.bracketAuthorship.isEmpty() || this.bracketYear != null && !this.bracketYear.isEmpty();
    }

    public void setGenusOrAbove(String genusOrAbove) {
        if (genusOrAbove != null && genusOrAbove.startsWith(HYBRID_MARKER.toString())) {
            this.genusOrAbove = genusOrAbove.substring(1);
            this.notho = NamePart.GENERIC;
        } else {
            this.genusOrAbove = genusOrAbove;
        }
    }

    public void setHybridFormula(boolean hybrid) {
        if (hybrid) {
            this.type = NameType.HYBRID;
        } else if (NameType.HYBRID == this.type) {
            this.type = null;
        }
    }

    public void setInfraGeneric(String infraGeneric) {
        if (infraGeneric != null && infraGeneric.startsWith(HYBRID_MARKER_STR)) {
            this.infraGeneric = infraGeneric.substring(1);
            this.notho = NamePart.INFRAGENERIC;
        } else {
            this.infraGeneric = infraGeneric;
        }
    }

    public void setInfraSpecificEpithet(String infraSpecies) {
        if (infraSpecies != null && infraSpecies.startsWith(HYBRID_MARKER_STR)) {
            this.infraSpecificEpithet = infraSpecies.substring(1);
            this.notho = NamePart.INFRASPECIFIC;
        } else {
            this.infraSpecificEpithet = infraSpecies;
        }
    }

    public void setRankMarker(String rankMarker) {
        if (rankMarker == null) {
            this.rank = null;
        } else {
            Rank r;
            if ((rankMarker = rankMarker.trim().toLowerCase()).startsWith("notho")) {
                rankMarker = rankMarker.substring(5);
                this.notho = NamePart.INFRASPECIFIC;
            }
            this.rank = (r = Rank.inferRank(rankMarker)) == null || Rank.UNCOMPARABLE_RANKS.contains((Object)r) ? rankMarker : r.getMarker();
        }
    }

    public void setSpecificEpithet(String species) {
        if (species != null && species.startsWith(HYBRID_MARKER_STR)) {
            this.specificEpithet = species.substring(1);
            this.notho = NamePart.SPECIFIC;
        } else {
            this.specificEpithet = species;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedName)) {
            return false;
        }
        ParsedName o = (ParsedName)obj;
        return Objects.equal((Object)this.key, (Object)o.key) && Objects.equal((Object)this.scientificName, (Object)o.scientificName) && Objects.equal((Object)((Object)this.type), (Object)((Object)o.type)) && Objects.equal((Object)this.genusOrAbove, (Object)o.genusOrAbove) && Objects.equal((Object)this.infraGeneric, (Object)o.infraGeneric) && Objects.equal((Object)this.specificEpithet, (Object)o.specificEpithet) && Objects.equal((Object)this.infraSpecificEpithet, (Object)o.infraSpecificEpithet) && Objects.equal((Object)this.cultivarEpithet, (Object)o.cultivarEpithet) && Objects.equal((Object)this.strain, (Object)o.strain) && Objects.equal((Object)this.authorship, (Object)o.authorship) && Objects.equal((Object)this.year, (Object)o.year) && Objects.equal((Object)this.bracketAuthorship, (Object)o.bracketAuthorship) && Objects.equal((Object)this.bracketYear, (Object)o.bracketYear) && Objects.equal((Object)this.rank, (Object)o.rank);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.scientificName, this.type, this.genusOrAbove, this.infraGeneric, this.specificEpithet, this.infraSpecificEpithet, this.cultivarEpithet, this.strain, this.authorship, this.year, this.bracketAuthorship, this.bracketYear, this.rank});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.scientificName);
        if (this.key != null) {
            sb.append(" [");
            sb.append(this.key);
            sb.append("]");
        }
        if (this.genusOrAbove != null) {
            sb.append(" G:").append(this.genusOrAbove);
        }
        if (this.infraGeneric != null) {
            sb.append(" IG:").append(this.infraGeneric);
        }
        if (this.specificEpithet != null) {
            sb.append(" S:").append(this.specificEpithet);
        }
        if (this.rank != null) {
            sb.append(" R:").append(this.rank);
        }
        if (this.infraSpecificEpithet != null) {
            sb.append(" IS:").append(this.infraSpecificEpithet);
        }
        if (this.cultivarEpithet != null) {
            sb.append(" CV:").append(this.cultivarEpithet);
        }
        if (this.strain != null) {
            sb.append(" STR:").append(this.strain);
        }
        if (this.authorship != null) {
            sb.append(" A:").append(this.authorship);
        }
        if (this.year != null) {
            sb.append(" Y:").append(this.year);
        }
        if (this.bracketAuthorship != null) {
            sb.append(" BA:").append(this.bracketAuthorship);
        }
        if (this.bracketYear != null) {
            sb.append(" BY:").append(this.bracketYear);
        }
        if (this.type != null) {
            sb.append(" [");
            sb.append((Object)this.type);
            sb.append("]");
        }
        return this.isHybridFormula() ? " [hybrid]" : sb.toString();
    }
}

