/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops.pool;

import java.net.SocketException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.Connection;
import org.scale7.cassandra.pelops.IConnection;
import org.scale7.cassandra.pelops.JmxMBeanManager;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.exceptions.NoConnectionsAvailableException;
import org.scale7.cassandra.pelops.exceptions.PelopsException;
import org.scale7.cassandra.pelops.pool.CommonsBackedPoolMBean;
import org.scale7.cassandra.pelops.pool.DescribeVersionConnectionValidator;
import org.scale7.cassandra.pelops.pool.IThriftPool;
import org.scale7.cassandra.pelops.pool.LeastLoadedNodeSelectionStrategy;
import org.scale7.cassandra.pelops.pool.NoOpNodeSuspensionStrategy;
import org.scale7.cassandra.pelops.pool.PooledNode;
import org.scale7.cassandra.pelops.pool.ThriftPoolBase;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class CommonsBackedPool
extends ThriftPoolBase
implements CommonsBackedPoolMBean {
    private static final Logger logger = SystemProxy.getLoggerFromFactory(CommonsBackedPool.class);
    private static final int DEFAULT_WAIT_PERIOD = 100;
    private final Cluster cluster;
    private final Policy policy;
    private final String keyspace;
    private final OperandPolicy operandPolicy;
    private final INodeSelectionStrategy nodeSelectionStrategy;
    private final INodeSuspensionStrategy nodeSuspensionStrategy;
    private final IConnectionValidator connectionValidator;
    private final Map<String, PooledNode> nodes = new ConcurrentHashMap<String, PooledNode>();
    private GenericKeyedObjectPool pool;
    private ScheduledExecutorService executorService;
    private final Object scheduledTasksLock = new Object();
    private RunningStatistics statistics;

    public CommonsBackedPool(Cluster cluster, String keyspace) {
        this(cluster, keyspace, new Policy(cluster), new OperandPolicy());
    }

    public CommonsBackedPool(Cluster cluster, String keyspace, Policy policy, OperandPolicy operandPolicy) {
        this(cluster, keyspace, policy, operandPolicy, null, null, null);
    }

    public CommonsBackedPool(Cluster cluster, String keyspace, Policy policy, OperandPolicy operandPolicy, INodeSelectionStrategy nodeSelectionStrategy, INodeSuspensionStrategy nodeSuspensionStrategy, IConnectionValidator connectionValidator) {
        if (cluster == null) {
            throw new IllegalArgumentException("cluster is a required argument");
        }
        if (keyspace == null) {
            throw new IllegalArgumentException("keyspace is a required argument");
        }
        this.cluster = cluster;
        this.keyspace = keyspace;
        this.policy = policy != null ? policy : new Policy(cluster);
        this.operandPolicy = operandPolicy != null ? operandPolicy : new OperandPolicy();
        logger.info("Initialising pool configuration policy: {}", (Object)this.policy.toString());
        this.nodeSelectionStrategy = nodeSelectionStrategy != null ? nodeSelectionStrategy : new LeastLoadedNodeSelectionStrategy();
        logger.info("Initialising pool node selection strategy: {}", (Object)this.nodeSelectionStrategy);
        this.nodeSuspensionStrategy = nodeSuspensionStrategy != null ? nodeSuspensionStrategy : new NoOpNodeSuspensionStrategy();
        logger.info("Initialising pool node suspension strategy: {}", (Object)this.nodeSuspensionStrategy);
        this.connectionValidator = connectionValidator != null ? connectionValidator : new DescribeVersionConnectionValidator();
        logger.info("Initialising pool connection validator: {}", (Object)this.connectionValidator);
        if (cluster.getConnectionConfig().getTimeout() >= this.policy.getMaxWaitForConnection()) {
            logger.warn("The thrift timeout value ({}ms) is greater than the pools maxWaitForConnection value ({}ms).  This could lead to errors when a node is down.  As a general rule the pools maxWaitForConnection should be three times larger than the thrift timeout value.", (Object)cluster.getConnectionConfig().getTimeout(), (Object)this.policy.getMaxWaitForConnection());
        }
        this.statistics = new RunningStatistics();
        this.configureBackingPool();
        Object[] currentNodes = cluster.getNodes();
        logger.info("Pre-initialising connections for nodes: {}", (Object)Arrays.toString(currentNodes));
        for (Object node : currentNodes) {
            this.addNode(((Cluster.Node)node).getAddress());
        }
        this.statistics.nodesActive.set(this.nodes.size());
        this.configureScheduledTasks();
        String beanName = this.getMBeanName();
        if (JmxMBeanManager.getInstance().isRegistered(beanName)) {
            logger.warn("MBean '{}' is already registered, removing...", (Object)beanName);
            JmxMBeanManager.getInstance().unregisterMBean(beanName);
        }
        logger.info("Registering MBean '{}'...", (Object)beanName);
        JmxMBeanManager.getInstance().registerMBean(this, beanName);
    }

    private void configureScheduledTasks() {
        if (this.policy.getTimeBetweenScheduledMaintenanceTaskRunsMillis() > 0) {
            if (this.policy.isRunMaintenanceTaskDuringInit()) {
                logger.info("Running maintenance tasks during initialization...");
                this.runMaintenanceTasks();
            }
            if (10000 >= this.policy.getTimeBetweenScheduledMaintenanceTaskRunsMillis()) {
                logger.warn("Setting the scheduled tasks to run less than every {} milliseconds is not a good idea...", (Object)10000);
            }
            logger.info("Configuring scheduled tasks to run every {} milliseconds", (Object)this.policy.getTimeBetweenScheduledMaintenanceTaskRunsMillis());
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "pelops-pool-worker-" + CommonsBackedPool.this.getKeyspace());
                    thread.setDaemon(true);
                    thread.setPriority(2);
                    return thread;
                }
            });
            this.executorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Background thread running maintenance tasks");
                    try {
                        CommonsBackedPool.this.runMaintenanceTasks();
                    }
                    catch (Exception e) {
                        logger.warn("An exception was thrown while running the maintenance tasks", (Throwable)e);
                    }
                }
            }, this.policy.getTimeBetweenScheduledMaintenanceTaskRunsMillis(), this.policy.getTimeBetweenScheduledMaintenanceTaskRunsMillis(), TimeUnit.MILLISECONDS);
        } else {
            logger.warn("Disabling maintenance tasks; dynamic node discovery, node suspension, idle connection termination and some running statistics will not be available to this pool.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runMaintenanceTasks() {
        logger.debug("Attempting to acquire lock for maintenance tasks");
        Object object = this.scheduledTasksLock;
        synchronized (object) {
            logger.debug("Starting maintenance tasks");
            logger.debug("Updating pool configuration properties based on policy: {}", (Object)this.policy);
            this.pool.setTestWhileIdle(this.policy.isTestConnectionsWhileIdle());
            this.pool.setMaxIdle(this.policy.getMaxIdlePerNode());
            this.pool.setMinIdle(this.policy.getMinIdlePerNode());
            this.pool.setMaxActive(this.policy.getMaxActivePerNode());
            this.pool.setMaxTotal(this.policy.getMaxTotal());
            this.handleClusterRefresh();
            logger.debug("Evaluating which nodes should be suspended");
            int nodesSuspended = 0;
            for (PooledNode node : this.nodes.values()) {
                logger.debug("Evaluating if node {} should be suspended", (Object)node.getAddress());
                if (!this.nodeSuspensionStrategy.evaluate(this, node)) continue;
                ++nodesSuspended;
                logger.info("Node {} was suspended from the pool, closing existing pooled connections", (Object)node.getAddress());
                this.pool.clear((Object)node.getAddress());
                node.reportSuspension();
            }
            this.statistics.nodesActive.set(this.nodes.size() - nodesSuspended);
            this.statistics.nodesSuspended.set(nodesSuspended);
            try {
                logger.debug("Validating and possibly evicting idle connections based on configuration rules");
                this.pool.evict();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.debug("Finished maintenance tasks");
        }
    }

    @Override
    public void shutdown() {
        String beanName = this.getMBeanName();
        logger.info("Removing MBean '{}'...", (Object)beanName);
        if (JmxMBeanManager.getInstance().isRegistered(beanName)) {
            JmxMBeanManager.getInstance().unregisterMBean(beanName);
        }
        if (this.executorService != null) {
            logger.info("Terminating background thread...");
            this.executorService.shutdownNow();
            while (!this.executorService.isTerminated()) {
                try {
                    if (this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) continue;
                    logger.info("Still waiting for background thread to terminate...");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        try {
            logger.info("Closing pooled connections...");
            this.pool.close();
        }
        catch (Exception e) {
            logger.error("Failed to close pool", (Throwable)e);
        }
        for (PooledNode pooledNode : this.nodes.values()) {
            logger.info("Decommissioning node '{}'", (Object)pooledNode.getAddress());
            pooledNode.decommission();
        }
    }

    @Override
    public IThriftPool.IPooledConnection getConnection() throws NoConnectionsAvailableException {
        return this.getConnectionExcept(null);
    }

    @Override
    public IThriftPool.IPooledConnection getConnectionExcept(Set<String> avoidNodes) throws NoConnectionsAvailableException {
        PooledNode node = null;
        IConnection connection = null;
        long timeout = -1L;
        while (connection == null) {
            if (timeout == -1L) {
                int maxWait = this.getPolicy().getMaxWaitForConnection();
                timeout = maxWait > 0 ? System.currentTimeMillis() + (long)maxWait : Long.MAX_VALUE;
            } else if (timeout < System.currentTimeMillis()) {
                logger.debug("Max wait time for connection exceeded");
                break;
            }
            node = this.nodeSelectionStrategy.select(this, this.nodes.keySet(), avoidNodes);
            if (node == null) {
                logger.debug("The node selection strategy was unable to choose a node, sleeping before trying again...");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            try {
                logger.debug("Attempting to borrow free connection for node '{}'", (Object)node.getAddress());
                connection = (IThriftPool.IPooledConnection)this.pool.borrowObject((Object)node.getAddress());
            }
            catch (IllegalStateException e) {
                throw new PelopsException("The pool has been shutdown", e);
            }
            catch (Exception e) {
                if (e instanceof NoSuchElementException) {
                    logger.debug("No free connections available for node '{}'.  Trying another node...", (Object)node.getAddress());
                } else if (e instanceof TTransportException) {
                    logger.warn(String.format("A TTransportException was thrown while attempting to create a connection to '%s'.  This node will be suspended for %sms.  Trying another node...", node.getAddress(), this.policy.getNodeDownSuspensionMillis()));
                    node.suspendForMillis(this.policy.getNodeDownSuspensionMillis());
                } else {
                    logger.warn(String.format("An exception was thrown while attempting to create a connection to '%s'.  Trying another node...", node.getAddress()), (Throwable)e);
                }
                if (avoidNodes == null) {
                    avoidNodes = new HashSet<String>(10);
                }
                avoidNodes.add(node.getAddress());
            }
        }
        if (node == null) {
            logger.error("Failed to get a connection within the configured wait time because there are no available nodes. This possibly indicates that either the suspension strategy is too aggressive or that your cluster is in a bad way.");
            throw new NoConnectionsAvailableException("Failed to get a connection within the configured max wait time.");
        }
        if (connection == null) {
            logger.error("Failed to get a connection within the maximum allowed wait time.  Try increasing the either the number of allowed connections or the max wait time.");
            throw new NoConnectionsAvailableException("Failed to get a connection within the configured max wait time.");
        }
        logger.debug("Borrowing connection '{}'", connection);
        this.statistics.connectionsActive.incrementAndGet();
        this.reportConnectionBorrowed(connection.getNode().getAddress());
        return connection;
    }

    public PooledNode getPooledNode(String nodeAddress) {
        return this.nodes.get(nodeAddress);
    }

    protected void configureBackingPool() {
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new ConnectionFactory());
        this.pool.setWhenExhaustedAction((byte)1);
        this.pool.setMaxWait(100L);
        this.pool.setLifo(true);
        this.pool.setMaxActive(this.policy.getMaxActivePerNode());
        this.pool.setMinIdle(this.policy.getMinIdlePerNode());
        this.pool.setMaxIdle(this.policy.getMaxIdlePerNode());
        this.pool.setMaxTotal(this.policy.getMaxTotal());
        this.pool.setTimeBetweenEvictionRunsMillis(-1L);
        this.pool.setTestWhileIdle(this.policy.isTestConnectionsWhileIdle());
    }

    private void handleClusterRefresh() {
        this.cluster.refresh(this.getKeyspace());
        Cluster.Node[] currentNodes = this.cluster.getNodes();
        logger.debug("Determining which nodes need to be added and removed based on latest nodes list");
        for (Cluster.Node node : currentNodes) {
            if (this.nodes.containsKey(node.getAddress())) continue;
            this.addNode(node.getAddress());
        }
        for (String nodeAddress : this.nodes.keySet()) {
            boolean isPresent = false;
            for (Cluster.Node node : currentNodes) {
                if (!node.getAddress().equals(nodeAddress)) continue;
                isPresent = true;
            }
            if (isPresent) continue;
            this.removeNode(nodeAddress);
        }
    }

    private void addNode(String nodeAddress) {
        logger.info("Adding node '{}' to the pool...", (Object)nodeAddress);
        PooledNode node = new PooledNode(this, nodeAddress);
        this.nodes.put(nodeAddress, node);
        this.pool.preparePool((Object)nodeAddress, true);
    }

    private void removeNode(String nodeAddress) {
        logger.info("Removing node '{}' from the pool", (Object)nodeAddress);
        PooledNode node = this.nodes.remove(nodeAddress);
        this.pool.clear((Object)nodeAddress);
        if (node != null) {
            node.decommission();
        }
    }

    protected void releaseConnection(PooledConnection connection) {
        try {
            this.statistics.connectionsActive.decrementAndGet();
            this.reportConnectionReleased(connection.getNode().getAddress());
            if (connection.isCorrupt() || !connection.isOpen()) {
                logger.debug("Returned connection '{}' has been closed or is marked as corrupt", (Object)connection);
                this.reportConnectionCorrupted(connection.getNode().getAddress());
                this.pool.invalidateObject((Object)connection.getNode().getAddress(), (Object)connection);
            } else {
                logger.debug("Returning connection '{}'", (Object)connection);
                this.pool.returnObject((Object)connection.getNode().getAddress(), (Object)connection);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void reportConnectionCreated(String nodeAddress) {
        this.statistics.connectionsCreated.incrementAndGet();
        PooledNode node = this.getPooledNode(nodeAddress);
        if (node != null) {
            node.reportConnectionCreated();
        }
    }

    protected void reportConnectionDestroyed(String nodeAddress) {
        this.statistics.connectionsDestroyed.incrementAndGet();
        PooledNode node = this.getPooledNode(nodeAddress);
        if (node != null) {
            node.reportConnectionDestroyed();
        }
    }

    protected void reportConnectionCorrupted(String nodeAddress) {
        this.statistics.connectionsCorrupted.incrementAndGet();
        PooledNode pooledNode = this.getPooledNode(nodeAddress);
        if (pooledNode != null) {
            pooledNode.reportConnectionCorrupted();
        }
    }

    protected void reportConnectionBorrowed(String nodeAddress) {
        this.statistics.connectionsBorrowedTotal.incrementAndGet();
        PooledNode pooledNode = this.getPooledNode(nodeAddress);
        if (pooledNode != null) {
            pooledNode.reportConnectionBorrowed();
        }
    }

    protected void reportConnectionReleased(String nodeAddress) {
        this.statistics.connectionsReleasedTotal.incrementAndGet();
        PooledNode pooledNode = this.getPooledNode(nodeAddress);
        if (pooledNode != null) {
            pooledNode.reportConnectionReleased();
        }
    }

    @Override
    public OperandPolicy getOperandPolicy() {
        return this.operandPolicy;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public INodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    public INodeSuspensionStrategy getNodeSuspensionStrategy() {
        return this.nodeSuspensionStrategy;
    }

    public IConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    public RunningStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public int getConnectionsCreated() {
        return this.getStatistics().getConnectionsCreated();
    }

    @Override
    public int getConnectionsDestroyed() {
        return this.getStatistics().getConnectionsCreated();
    }

    @Override
    public int getConnectionsCorrupted() {
        return this.getStatistics().getConnectionsCorrupted();
    }

    @Override
    public int getConnectionsActive() {
        return this.getStatistics().getConnectionsActive();
    }

    @Override
    public int getNodesActive() {
        return this.getStatistics().getNodesActive();
    }

    @Override
    public int getNodesSuspended() {
        return this.getStatistics().getNodesSuspended();
    }

    @Override
    public int getConnectionsBorrowedTotal() {
        return this.getStatistics().getConnectionsBorrowedTotal();
    }

    @Override
    public int getConnectionsReleasedTotal() {
        return this.getStatistics().getConnectionsReleasedTotal();
    }

    @Override
    public int getMaxActivePerNode() {
        return this.getPolicy().getMaxActivePerNode();
    }

    @Override
    public void setMaxActivePerNode(int maxActivePerNode) {
        this.getPolicy().setMaxActivePerNode(maxActivePerNode);
    }

    @Override
    public int getMaxIdlePerNode() {
        return this.getPolicy().getMaxIdlePerNode();
    }

    @Override
    public void setMaxIdlePerNode(int maxIdlePerNode) {
        this.getPolicy().setMaxIdlePerNode(maxIdlePerNode);
    }

    @Override
    public int getMaxTotal() {
        return this.getPolicy().getMaxTotal();
    }

    @Override
    public void setMaxTotal(int maxTotal) {
        this.getPolicy().setMaxTotal(maxTotal);
    }

    @Override
    public int getMinIdlePerNode() {
        return this.getPolicy().getMinIdlePerNode();
    }

    @Override
    public void setMinIdlePerNode(int minIdlePerNode) {
        this.getPolicy().setMinIdlePerNode(minIdlePerNode);
    }

    @Override
    public int getMaxWaitForConnection() {
        return this.getPolicy().getMaxWaitForConnection();
    }

    @Override
    public void setMaxWaitForConnection(int maxWaitForConnection) {
        this.getPolicy().setMaxWaitForConnection(maxWaitForConnection);
    }

    @Override
    public boolean isTestConnectionsWhileIdle() {
        return this.getPolicy().isTestConnectionsWhileIdle();
    }

    @Override
    public void setTestConnectionsWhileIdle(boolean testConnectionsWhileIdle) {
        this.getPolicy().setTestConnectionsWhileIdle(testConnectionsWhileIdle);
    }

    @Override
    public int getNodeDownSuspensionMillis() {
        return this.getPolicy().getNodeDownSuspensionMillis();
    }

    @Override
    public void setNodeDownSuspensionMillis(int nodeDownSuspensionMillis) {
        this.getPolicy().setNodeDownSuspensionMillis(nodeDownSuspensionMillis);
    }

    private String getMBeanName() {
        return "com.scale7.cassandra.pelops.pool:type=Pool-" + this.keyspace;
    }

    KeyedObjectPool getUnderlyingPool() {
        return this.pool;
    }

    public static interface IConnectionValidator {
        public boolean validate(PooledConnection var1);
    }

    public static interface INodeSuspensionState {
        public boolean isSuspended();
    }

    public static interface INodeSuspensionStrategy {
        public boolean evaluate(CommonsBackedPool var1, PooledNode var2);
    }

    public static interface INodeSelectionStrategy {
        public PooledNode select(CommonsBackedPool var1, Set<String> var2, Set<String> var3);
    }

    public static class RunningStatistics {
        private AtomicInteger nodesActive = new AtomicInteger();
        private AtomicInteger nodesSuspended = new AtomicInteger();
        private AtomicInteger connectionsCreated = new AtomicInteger();
        private AtomicInteger connectionsDestroyed = new AtomicInteger();
        private AtomicInteger connectionsCorrupted = new AtomicInteger();
        private AtomicInteger connectionsActive = new AtomicInteger();
        private AtomicInteger connectionsBorrowedTotal = new AtomicInteger();
        private AtomicInteger connectionsReleasedTotal = new AtomicInteger();

        public int getConnectionsCreated() {
            return this.connectionsCreated.get();
        }

        public int getConnectionsDestroyed() {
            return this.connectionsDestroyed.get();
        }

        public int getConnectionsCorrupted() {
            return this.connectionsCorrupted.get();
        }

        public int getConnectionsActive() {
            return this.connectionsActive.get();
        }

        public int getNodesActive() {
            return this.nodesActive.get();
        }

        public int getNodesSuspended() {
            return this.nodesSuspended.get();
        }

        public int getConnectionsBorrowedTotal() {
            return this.connectionsBorrowedTotal.get();
        }

        public int getConnectionsReleasedTotal() {
            return this.connectionsReleasedTotal.get();
        }
    }

    private class ConnectionFactory
    extends BaseKeyedPoolableObjectFactory {
        private ConnectionFactory() {
        }

        public Object makeObject(Object key) throws Exception {
            String nodeAddress = (String)key;
            PooledConnection connection = new PooledConnection(new Cluster.Node(nodeAddress, CommonsBackedPool.this.cluster.getConnectionConfig()), CommonsBackedPool.this.getKeyspace());
            logger.debug("Made new connection '{}'", (Object)connection);
            connection.open();
            CommonsBackedPool.this.reportConnectionCreated(nodeAddress);
            return connection;
        }

        public void destroyObject(Object key, Object obj) throws Exception {
            String nodeAddress = (String)key;
            PooledConnection connection = (PooledConnection)obj;
            logger.debug("Destroying connection '{}'", (Object)connection);
            connection.close();
            CommonsBackedPool.this.reportConnectionDestroyed(nodeAddress);
        }

        public boolean validateObject(Object key, Object obj) {
            String nodeAddress = (String)key;
            PooledConnection connection = (PooledConnection)obj;
            logger.debug("Validating connection '{}'", (Object)connection);
            return CommonsBackedPool.this.connectionValidator.validate(connection);
        }

        public void activateObject(Object key, Object obj) throws Exception {
        }

        public void passivateObject(Object key, Object obj) throws Exception {
        }
    }

    public class PooledConnection
    extends Connection
    implements IThriftPool.IPooledConnection {
        private boolean corrupt;

        public PooledConnection(Cluster.Node node, String keyspace) throws SocketException, TException, InvalidRequestException {
            super(node, keyspace);
            this.corrupt = false;
        }

        @Override
        public void release() {
            CommonsBackedPool.this.releaseConnection(this);
        }

        @Override
        public void corrupted() {
            this.corrupt = true;
        }

        public boolean isCorrupt() {
            return this.corrupt;
        }

        public String toString() {
            return String.format("Connection[%s][%s:%s][%s]", CommonsBackedPool.this.getKeyspace(), this.getNode().getAddress(), CommonsBackedPool.this.cluster.getConnectionConfig().getThriftPort(), super.hashCode());
        }
    }

    public static class Policy {
        public static final int ONE_SECOND = 1000;
        public static final int TEN_SECONDS = 10000;
        private static final int DEFAULT_TIME_BETWEEN_SCHEDULED_TASKS = 60000;
        private static final int MIN_TIME_BETWEEN_SCHEDULED_TASKS = 10000;
        private AtomicInteger maxActivePerNode = new AtomicInteger(20);
        private AtomicInteger maxTotal = new AtomicInteger(-1);
        private AtomicInteger maxIdlePerNode = new AtomicInteger(10);
        private AtomicInteger minIdlePerNode = new AtomicInteger(10);
        private AtomicInteger maxWaitForConnection = new AtomicInteger(4000);
        private int timeBetweenScheduledMaintenanceTaskRunsMillis = 60000;
        private AtomicBoolean testConnectionsWhileIdle = new AtomicBoolean(true);
        private AtomicInteger nodeDownSuspensionMillis = new AtomicInteger(10000);
        private AtomicBoolean runMaintenanceTaskDuringInit = new AtomicBoolean(true);

        public Policy() {
        }

        public Policy(Cluster cluster) {
            if (!cluster.getConnectionConfig().isTimeoutSet()) {
                this.maxWaitForConnection.set(Integer.MAX_VALUE);
            } else {
                this.maxWaitForConnection.set(cluster.getConnectionConfig().getTimeout() * 3);
            }
        }

        public int getMaxActivePerNode() {
            return this.maxActivePerNode.get();
        }

        public void setMaxActivePerNode(int maxActivePerNode) {
            this.maxActivePerNode.set(maxActivePerNode);
        }

        public int getMaxIdlePerNode() {
            return this.maxIdlePerNode.get();
        }

        public void setMaxIdlePerNode(int maxIdlePerNode) {
            this.maxIdlePerNode.set(maxIdlePerNode);
        }

        public int getMaxTotal() {
            return this.maxTotal.get();
        }

        public void setMaxTotal(int maxTotal) {
            this.maxTotal.set(maxTotal);
        }

        public int getMinIdlePerNode() {
            return this.minIdlePerNode.get();
        }

        public void setMinIdlePerNode(int minIdlePerNode) {
            this.minIdlePerNode.set(minIdlePerNode);
        }

        public int getMaxWaitForConnection() {
            return this.maxWaitForConnection.get();
        }

        public void setMaxWaitForConnection(int maxWaitForConnection) {
            this.maxWaitForConnection.set(maxWaitForConnection);
        }

        public int getTimeBetweenScheduledMaintenanceTaskRunsMillis() {
            return this.timeBetweenScheduledMaintenanceTaskRunsMillis;
        }

        public void setTimeBetweenScheduledMaintenanceTaskRunsMillis(int timeBetweenScheduledMaintenanceTaskRunsMillis) {
            this.timeBetweenScheduledMaintenanceTaskRunsMillis = timeBetweenScheduledMaintenanceTaskRunsMillis;
        }

        public boolean isTestConnectionsWhileIdle() {
            return this.testConnectionsWhileIdle.get();
        }

        public void setTestConnectionsWhileIdle(boolean testConnectionsWhileIdle) {
            this.testConnectionsWhileIdle.set(testConnectionsWhileIdle);
        }

        public int getNodeDownSuspensionMillis() {
            return this.nodeDownSuspensionMillis.get();
        }

        public void setNodeDownSuspensionMillis(int nodeDownSuspensionMillis) {
            this.nodeDownSuspensionMillis.set(nodeDownSuspensionMillis);
        }

        public void setRunMaintenanceTaskDuringInit(boolean runMaintenanceTaskDuringInit) {
            this.runMaintenanceTaskDuringInit.set(runMaintenanceTaskDuringInit);
        }

        public boolean isRunMaintenanceTaskDuringInit() {
            return this.runMaintenanceTaskDuringInit.get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Config");
            sb.append("{maxActivePerNode=").append(this.maxActivePerNode);
            sb.append(", maxTotal=").append(this.maxTotal);
            sb.append(", maxIdlePerNode=").append(this.maxIdlePerNode);
            sb.append(", minIdlePerNode=").append(this.minIdlePerNode);
            sb.append(", maxWaitForConnection=").append(this.maxWaitForConnection);
            sb.append(", testConnectionsWhileIdle=").append(this.testConnectionsWhileIdle);
            sb.append(", timeBetweenScheduledMaintenanceTaskRunsMillis=").append(this.timeBetweenScheduledMaintenanceTaskRunsMillis);
            sb.append(", nodeDownSuspensionMillis=").append(this.nodeDownSuspensionMillis);
            sb.append('}');
            return sb.toString();
        }
    }
}

