/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.text;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SimpleSaxHandler
extends DefaultHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String content;
    private StringBuffer chars;
    private Pattern normWhitespace = Pattern.compile("\\s+");
    protected String parents = "";

    public void characters(char[] ch, int start, int length) {
        this.chars.append(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.content = StringUtils.trimToNull((String)this.chars.toString());
        if (this.content != null) {
            this.content = this.normWhitespace.matcher(this.content).replaceAll(" ");
        }
        this.parents = this.parents.substring(0, this.parents.length() - localName.length() - 1);
    }

    public void startDocument() {
        this.parents = "";
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.chars = new StringBuffer();
        this.parents = this.parents + "/" + localName.toLowerCase();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

