/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.build.line;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.graph.build.GraphBuilder;
import org.geotools.graph.build.line.LineGraphGenerator;
import org.geotools.graph.build.line.OptLineGraphBuilder;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.line.OptXYNode;
import org.geotools.graph.structure.opt.OptEdge;
import org.geotools.graph.structure.opt.OptNode;

public class OptLineGraphGenerator
implements LineGraphGenerator {
    private HashMap m_coord2count = new HashMap();
    private ArrayList m_lines = new ArrayList();
    private GraphBuilder m_builder;

    public OptLineGraphGenerator() {
        this.setGraphBuilder(new OptLineGraphBuilder());
    }

    public Graphable add(Object obj) {
        LineSegment line = (LineSegment)obj;
        Integer count = (Integer)this.m_coord2count.get(line.p0);
        if (count == null) {
            this.m_coord2count.put(line.p0, new Integer(1));
        } else {
            this.m_coord2count.put(line.p0, new Integer(count + 1));
        }
        count = (Integer)this.m_coord2count.get(line.p1);
        if (count == null) {
            this.m_coord2count.put(line.p1, new Integer(1));
        } else {
            this.m_coord2count.put(line.p1, new Integer(count + 1));
        }
        this.m_lines.add(line);
        return null;
    }

    public Graphable get(Object obj) {
        LineSegment line = (LineSegment)obj;
        Node n1 = (Node)this.m_coord2count.get(line.p0);
        Node n2 = (Node)this.m_coord2count.get(line.p0);
        return n1.getEdge(n2);
    }

    public Graphable remove(Object obj) {
        throw new UnsupportedOperationException(this.getClass().getName() + "#remove(Object)");
    }

    public void setGraphBuilder(GraphBuilder builder) {
        this.m_builder = builder;
    }

    public GraphBuilder getGraphBuilder() {
        return this.m_builder;
    }

    public Graph getGraph() {
        return this.m_builder.getGraph();
    }

    public void generate() {
        this.generateNodes();
        this.generateEdges();
    }

    public Map getNodeMap() {
        return this.m_coord2count;
    }

    protected List getLines() {
        return this.m_lines;
    }

    protected void generateNodes() {
        for (Map.Entry entry : this.m_coord2count.entrySet()) {
            Coordinate coord = (Coordinate)entry.getKey();
            Integer count = (Integer)entry.getValue();
            OptXYNode node = (OptXYNode)this.m_builder.buildNode();
            node.setDegree(count);
            node.setCoordinate(coord);
            this.m_builder.addNode(node);
            entry.setValue(node);
        }
    }

    protected void generateEdges() {
        for (LineSegment line : this.m_lines) {
            this.generateEdge(line);
        }
    }

    protected Edge generateEdge(LineSegment line) {
        OptNode n1 = (OptNode)this.m_coord2count.get(line.p0);
        OptNode n2 = (OptNode)this.m_coord2count.get(line.p1);
        OptEdge edge = (OptEdge)this.m_builder.buildEdge(n1, n2);
        this.m_builder.addEdge(edge);
        return edge;
    }

    public Node getNode(Coordinate c) {
        return (Node)this.m_coord2count.get(c);
    }

    public Edge getEdge(Coordinate c1, Coordinate c2) {
        Node n1 = (Node)this.m_coord2count.get(c1);
        Node n2 = (Node)this.m_coord2count.get(c2);
        return n1.getEdge(n2);
    }
}

