/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.IOException;
import java.util.Set;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.ResourceInfo;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;

public class ShapefileFeatureLocking
extends AbstractFeatureLocking {
    private final ShapefileDataStore shapefile;
    private final SimpleFeatureType featureType;

    public ShapefileFeatureLocking(ShapefileDataStore shapefileDataStore, Set hints, SimpleFeatureType featureType) {
        super(hints);
        this.shapefile = shapefileDataStore;
        this.featureType = featureType;
    }

    public DataStore getDataStore() {
        return this.shapefile;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.shapefile.listenerManager.addFeatureListener(this, listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.shapefile.listenerManager.removeFeatureListener(this, listener);
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.shapefile.getBounds(query);
    }

    public ResourceInfo getInfo() {
        return this.shapefile.getInfo(this.featureType.getTypeName());
    }
}

