/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.intersect;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class SimpleRegion
implements Serializable {
    static final long serialVersionUID = -5509351896749940566L;
    public static final int UNDEFINED = 0;
    public static final int BOUNDING_BOX = 1;
    public static final int CIRCLE = 2;
    public static final int POLYGON = 3;
    public static final int GI_UNDEFINED = 0;
    public static final int GI_PARTIALLY_PRESENT = 1;
    public static final int GI_FULLY_PRESENT = 2;
    public static final int GI_ABSENCE = 0;
    int type = 0;
    double[] points;
    double[][] bounding_box;
    double radius;
    private int map_offset = 0x10000000;
    private double map_radius = (double)this.map_offset / Math.PI;

    public int getNumberOfPoints() {
        return this.points.length / 2;
    }

    public double[][] getBoundingBox() {
        return this.bounding_box;
    }

    public void setBox(double longitude1, double latitude1, double longitude2, double latitude2) {
        this.type = 1;
        this.points = new double[4];
        this.points[0] = Math.min(longitude1, longitude2);
        this.points[1] = Math.min(latitude1, latitude2);
        this.points[2] = Math.max(longitude1, longitude2);
        this.points[3] = Math.max(latitude1, latitude2);
        for (int i = 0; i < this.points.length; i += 2) {
            if (this.points[i] < -180.0) {
                this.points[i] = -180.0;
            }
            if (this.points[i] > 180.0) {
                this.points[i] = 180.0;
            }
            while (this.points[i + 1] < -90.0) {
                this.points[i + 1] = -90.0;
            }
            while (this.points[i + 1] > 90.0) {
                this.points[i + 1] = 90.0;
            }
        }
        this.bounding_box = new double[2][2];
        this.bounding_box[0][0] = this.points[0];
        this.bounding_box[0][1] = this.points[2];
        this.bounding_box[1][0] = this.points[1];
        this.bounding_box[1][1] = this.points[3];
    }

    public void setNone() {
        this.type = 0;
    }

    public void setCircle(double longitude, double latitude, double radius_) {
        this.type = 2;
        this.points = new double[2];
        this.points[0] = longitude;
        this.points[1] = latitude;
        this.radius = radius_;
    }

    public void setPolygon(double[] points_) {
        if (points_ != null && points_.length > 1) {
            int i;
            this.type = 3;
            for (i = 0; i < points_.length; i += 2) {
                if (points_[i] < -180.0) {
                    points_[i] = -180.0;
                }
                if (points_[i] > 180.0) {
                    points_[i] = 180.0;
                }
                while (points_[i + 1] < -90.0) {
                    points_[i + 1] = -90.0;
                }
                while (points_[i + 1] > 90.0) {
                    points_[i + 1] = 90.0;
                }
            }
            int len = points_.length - 2;
            if (points_[0] != points_[len] || points_[1] != points_[len + 1]) {
                this.points = new double[points_.length + 2];
                for (i = 0; i < points_.length; ++i) {
                    this.points[i] = points_[i];
                }
                this.points[points_.length] = points_[0];
                this.points[points_.length + 1] = points_[1];
            } else {
                this.points = new double[points_.length];
                for (i = 0; i < points_.length; ++i) {
                    this.points[i] = points_[i];
                }
            }
            this.bounding_box = new double[2][2];
            this.bounding_box[0][0] = this.points[0];
            this.bounding_box[0][1] = this.points[1];
            this.bounding_box[1][0] = this.points[0];
            this.bounding_box[1][1] = this.points[1];
            for (i = 2; i < this.points.length; i += 2) {
                if (this.bounding_box[0][0] > this.points[i]) {
                    this.bounding_box[0][0] = this.points[i];
                }
                if (this.bounding_box[1][0] < this.points[i]) {
                    this.bounding_box[1][0] = this.points[i];
                }
                if (this.bounding_box[0][1] > this.points[i + 1]) {
                    this.bounding_box[0][1] = this.points[i + 1];
                }
                if (!(this.bounding_box[1][1] < this.points[i + 1])) continue;
                this.bounding_box[1][1] = this.points[i + 1];
            }
        }
    }

    public boolean isWithin(double longitude, double latitude) {
        switch (this.type) {
            case 0: {
                return true;
            }
            case 1: {
                return longitude <= this.points[2] && longitude >= this.points[0] && latitude <= this.points[3] && latitude >= this.points[1];
            }
            case 2: {
                double x = longitude - this.points[0];
                double y = latitude - this.points[1];
                return Math.sqrt(x * x + y * y) <= this.radius;
            }
            case 3: {
                return this.isWithinPolygon(longitude, latitude);
            }
        }
        return false;
    }

    public boolean isWithin_EPSG900913(double longitude, double latitude) {
        switch (this.type) {
            case 0: {
                return true;
            }
            case 1: {
                return longitude <= this.points[2] && longitude >= this.points[0] && latitude <= this.points[3] && latitude >= this.points[1];
            }
            case 2: {
                double x = longitude - this.points[0];
                double y = latitude - this.points[1];
                return Math.sqrt(x * x + y * y) <= this.radius;
            }
            case 3: {
                return this.isWithinPolygon_EPSG900913(longitude, latitude);
            }
        }
        return false;
    }

    private boolean isWithinPolygon(double longitude, double latitude) {
        if (longitude > this.bounding_box[1][0] || longitude < this.bounding_box[0][0] || latitude > this.bounding_box[1][1] || latitude < this.bounding_box[0][1]) {
            return false;
        }
        boolean segment = this.points[0] > longitude;
        int len = this.points.length;
        int score = 0;
        for (int i = 2; i < len; i += 2) {
            if (this.points[i] > longitude != segment) {
                double y = (longitude - this.points[i]) * ((this.points[i + 1] - this.points[i - 1]) / (this.points[i] - this.points[i - 2])) + this.points[i + 1];
                if (y > latitude) {
                    ++score;
                } else if (y == latitude) {
                    return true;
                }
                segment = !segment;
                continue;
            }
            if (this.points[i] != longitude || this.points[i + 1] != latitude) continue;
            return true;
        }
        return score % 2 != 0;
    }

    private boolean isWithinPolygon_EPSG900913(double longitude, double latitude) {
        if (longitude <= this.bounding_box[1][0] && longitude >= this.bounding_box[0][0] && latitude <= this.bounding_box[1][1] && latitude >= this.bounding_box[0][1]) {
            int longitudePx = this.convertLngToPixel(longitude);
            boolean segment = this.convertLngToPixel(this.points[0]) > longitudePx;
            int len = this.points.length;
            int score = 0;
            for (int i = 2; i < len; i += 2) {
                if (this.convertLngToPixel(this.points[i]) > longitudePx != segment) {
                    int y = (int)((double)(longitudePx - this.convertLngToPixel(this.points[i])) * ((double)(this.convertLatToPixel(this.points[i + 1]) - this.convertLatToPixel(this.points[i - 1])) / (double)(this.convertLngToPixel(this.points[i]) - this.convertLngToPixel(this.points[i - 2]))) + (double)this.convertLatToPixel(this.points[i + 1]));
                    if (y > this.convertLatToPixel(latitude)) {
                        ++score;
                    } else if (y == this.convertLatToPixel(latitude)) {
                        return true;
                    }
                    segment = !segment;
                    continue;
                }
                if (this.points[i] != longitude || this.points[i + 1] != latitude) continue;
                return true;
            }
            return score % 2 != 0;
        }
        return false;
    }

    public int[][] getOverlapGridCells(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        int[][] cells = null;
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                cells = this.getOverlapGridCells_Box(longitude1, latitude1, longitude2, latitude2, width, height, this.bounding_box, three_state_map, noCellsReturned);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                cells = this.getOverlapGridCells_Polygon(longitude1, latitude1, longitude2, latitude2, width, height, three_state_map, noCellsReturned);
            }
        }
        return cells;
    }

    public void getOverlapGridCells_Acc(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map) {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                this.getOverlapGridCells_Box_Acc(longitude1, latitude1, longitude2, latitude2, width, height, this.bounding_box, three_state_map);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.getOverlapGridCells_Polygon_Acc(longitude1, latitude1, longitude2, latitude2, width, height, three_state_map);
            }
        }
    }

    public int[][] getOverlapGridCells(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map) {
        return this.getOverlapGridCells(longitude1, latitude1, longitude2, latitude2, width, height, three_state_map, false);
    }

    public int[][] getOverlapGridCells_Box(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, double[][] bb, byte[][] three_state_map, boolean noCellsReturned) {
        int[][] data;
        block23: {
            int p;
            int yend;
            int xend;
            int ystart;
            int xstart;
            block21: {
                int i;
                int j;
                block22: {
                    double xstep = Math.abs(longitude2 - longitude1) / (double)width;
                    double ystep = Math.abs(latitude2 - latitude1) / (double)height;
                    double minlong = Math.min(longitude1, longitude2);
                    double minlat = Math.min(latitude1, latitude2);
                    xstart = (int)Math.floor((bb[0][0] - minlong) / xstep);
                    ystart = (int)Math.floor((bb[0][1] - minlat) / ystep);
                    xend = (int)Math.ceil((bb[1][0] - minlong) / xstep);
                    yend = (int)Math.ceil((bb[1][1] - minlat) / ystep);
                    if (xstart < 0) {
                        xstart = 0;
                    }
                    if (ystart < 0) {
                        ystart = 0;
                    }
                    if (xend > width) {
                        xend = width;
                    }
                    if (yend > height) {
                        yend = height;
                    }
                    int out_width = xend - xstart;
                    int out_height = yend - ystart;
                    p = 0;
                    data = null;
                    if (noCellsReturned) break block21;
                    data = new int[out_width * out_height][2];
                    if (three_state_map != null) break block22;
                    for (int j2 = ystart; j2 < yend; ++j2) {
                        int i2 = xstart;
                        while (i2 < xend) {
                            data[p][0] = i2++;
                            data[p][1] = j2;
                            ++p;
                        }
                    }
                    break block23;
                }
                for (j = ystart; j < yend; ++j) {
                    for (i = xstart; i < xend; ++i) {
                        data[p][0] = i;
                        data[p][1] = j;
                        three_state_map[j][i] = 2;
                        ++p;
                    }
                }
                if (xstart < xend && xend > 0) {
                    for (j = ystart; j < yend; ++j) {
                        three_state_map[j][xstart] = 1;
                        three_state_map[j][xend - 1] = 1;
                    }
                }
                if (ystart >= yend || yend <= 0) break block23;
                for (i = xstart; i < xend; ++i) {
                    three_state_map[ystart][i] = 1;
                    three_state_map[yend - 1][i] = 1;
                }
                break block23;
            }
            if (three_state_map == null) {
                for (int j = ystart; j < yend; ++j) {
                    int i = xstart;
                    while (i < xend) {
                        data[p][0] = i++;
                        data[p][1] = j;
                        ++p;
                    }
                }
            } else {
                int i;
                int j;
                for (j = ystart; j < yend; ++j) {
                    for (i = xstart; i < xend; ++i) {
                        three_state_map[j][i] = 2;
                    }
                }
                if (xstart < xend && xend > 0) {
                    for (j = ystart; j < yend; ++j) {
                        three_state_map[j][xstart] = 1;
                        three_state_map[j][xend - 1] = 1;
                    }
                }
                if (ystart < yend && yend > 0) {
                    for (i = xstart; i < xend; ++i) {
                        three_state_map[ystart][i] = 1;
                        three_state_map[yend - 1][i] = 1;
                    }
                }
            }
        }
        return data;
    }

    public static SimpleRegion parseSimpleRegion(String pointsString) {
        int pos;
        if (pointsString.equalsIgnoreCase("none")) {
            return null;
        }
        SimpleRegion simpleregion = new SimpleRegion();
        ArrayList<Double> points = new ArrayList<Double>();
        int lastpos = 0;
        while ((pos = Math.min(pointsString.indexOf(44, lastpos), pointsString.indexOf(32, lastpos))) > 0) {
            try {
                points.add(Double.parseDouble(pointsString.substring(lastpos, pos)));
            }
            catch (Exception e) {
                points.add(0.0);
            }
            lastpos = pos + 1;
        }
        pos = pointsString.indexOf(32, lastpos);
        try {
            points.add(Double.parseDouble(pointsString.substring(lastpos, pos)));
            lastpos = pos + 1;
        }
        catch (Exception e) {
            points.add(0.0);
        }
        try {
            points.add(Double.parseDouble(pointsString.substring(lastpos, pointsString.length())));
        }
        catch (Exception e) {
            points.add(0.0);
        }
        if (points.size() == 8 && (points.get(0) != points.get(6) || points.get(1) != points.get(7)) || points.size() == 5 && points.get(0) == points.get(8) && points.get(1) == points.get(9)) {
            double minlong = 0.0;
            double minlat = 0.0;
            double maxlong = 0.0;
            double maxlat = 0.0;
            for (int i = 0; i < points.size(); i += 2) {
                if (i == 0 || minlong > (Double)points.get(i)) {
                    minlong = (Double)points.get(i);
                }
                if (i == 0 || maxlong < (Double)points.get(i)) {
                    maxlong = (Double)points.get(i);
                }
                if (i == 0 || minlat > (Double)points.get(i + 1)) {
                    minlat = (Double)points.get(i + 1);
                }
                if (i != 0 && !(maxlat < (Double)points.get(i + 1))) continue;
                maxlat = (Double)points.get(i + 1);
            }
            int prev_idx = 6;
            int i = 0;
            for (i = 0; i < 8 && points.get(i) == points.get(prev_idx) != (points.get(i + 1) == points.get(prev_idx + 1)); i += 2) {
                prev_idx = i;
            }
            if (i == 8) {
                simpleregion.setBox(minlong, minlat, maxlong, maxlat);
                return simpleregion;
            }
        }
        double[] pointsArray = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            pointsArray[i] = (Double)points.get(i);
        }
        simpleregion.setPolygon(pointsArray);
        return simpleregion;
    }

    public double getWidth() {
        return this.bounding_box[1][0] - this.bounding_box[0][0];
    }

    public double getHeight() {
        return this.bounding_box[1][1] - this.bounding_box[0][1];
    }

    public int getType() {
        return this.type;
    }

    public void saveGridAsImage(byte[][] three_state_map) {
        try {
            long t1 = System.currentTimeMillis();
            BufferedImage bi = new BufferedImage(three_state_map[0].length, three_state_map.length, 1);
            for (int i = 0; i < three_state_map.length; ++i) {
                for (int j = 0; j < three_state_map[i].length; ++j) {
                    if (three_state_map[i][j] == 0) {
                        bi.setRGB(j, three_state_map.length - 1 - i, 0xFFFFFF);
                        continue;
                    }
                    if (three_state_map[i][j] == 1) {
                        bi.setRGB(j, three_state_map.length - 1 - i, 0x99FF99);
                        continue;
                    }
                    if (three_state_map[i][j] != 2) continue;
                    bi.setRGB(j, three_state_map.length - 1 - i, 0x9999FF);
                }
            }
            ImageIO.write((RenderedImage)bi, "png", File.createTempFile("grd", ".png", new File("d:\\")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[][] getOverlapGridCells_Polygon(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        int j;
        if (three_state_map == null) {
            three_state_map = new byte[height][width];
        }
        double divx = (longitude2 - longitude1) / (double)width;
        double divy = (latitude2 - latitude1) / (double)height;
        for (j = 2; j < this.points.length; j += 2) {
            double dy2;
            double dx2;
            double dy1;
            double dx1;
            if (this.points[j + 1] < this.points[j - 1]) {
                dx1 = this.points[j];
                dy1 = this.points[j + 1];
                dx2 = this.points[j - 2];
                dy2 = this.points[j - 1];
            } else {
                dx2 = this.points[j];
                dy2 = this.points[j + 1];
                dx1 = this.points[j - 2];
                dy1 = this.points[j - 1];
            }
            int x = (int)((dx1 - longitude1) / divx);
            int y = (int)((dy1 - latitude1) / divy);
            int xend = (int)((dx2 - longitude1) / divx);
            int yend = (int)((dy2 - latitude1) / divy);
            if (y >= 0 && y < height && x >= 0 && x < width) {
                three_state_map[y][x] = 1;
            }
            if (x == xend && y == yend) continue;
            int xDirection = x < xend ? 1 : -1;
            double slope = (dy1 - dy2) / (dx1 - dx2);
            double intercept = dy1 - slope * dx1;
            if (x == xend) {
                while (y != yend) {
                    if (++y < 0 || y >= height || x < 0 || x >= width) continue;
                    three_state_map[y][x] = 1;
                }
                continue;
            }
            if (y == yend) {
                while (x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    three_state_map[y][x] = 1;
                }
                continue;
            }
            double endlat = dy2;
            for (double k = (double)(y + 1) * divy + latitude1; k < endlat; k += divy) {
                double xcross = (k - intercept) / slope;
                int icross = (int)((xcross - longitude1) / divx);
                while (x != icross && x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    three_state_map[y][x] = 1;
                }
                if (y == yend || ++y < 0 || y >= height || x < 0 || x >= width) continue;
                three_state_map[y][x] = 1;
            }
            while (x != xend) {
                if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                three_state_map[y][x] = 1;
            }
        }
        int[][] data = new int[width * height][2];
        boolean cellsReturned = !noCellsReturned;
        int p = 0;
        for (j = 0; j < three_state_map[0].length; ++j) {
            for (int i = 0; i < three_state_map.length; ++i) {
                if (three_state_map[i][j] != 1) {
                    if (j == 0 || three_state_map[i][j - 1] == 1) {
                        if (i > 0 && (three_state_map[i - 1][j] == 2 || three_state_map[i - 1][j] == 0)) {
                            three_state_map[i][j] = three_state_map[i - 1][j];
                        } else if (this.isWithin((double)j * divx + divx / 2.0 + longitude1, (double)i * divy + divy / 2.0 + latitude1)) {
                            three_state_map[i][j] = 2;
                        }
                    } else {
                        three_state_map[i][j] = three_state_map[i][j - 1];
                    }
                }
                if (!cellsReturned || three_state_map[i][j] == 0) continue;
                data[p][0] = j;
                data[p][1] = i;
                ++p;
            }
        }
        return (int[][])Arrays.copyOfRange(data, 0, p);
    }

    public void getOverlapGridCells_Polygon_Acc(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map) {
        double divx = (longitude2 - longitude1) / (double)width;
        double divy = (latitude2 - latitude1) / (double)height;
        for (int j = 2; j < this.points.length; j += 2) {
            double dy2;
            double dx2;
            double dy1;
            double dx1;
            if (this.points[j + 1] < this.points[j - 1]) {
                dx1 = this.points[j];
                dy1 = this.points[j + 1];
                dx2 = this.points[j - 2];
                dy2 = this.points[j - 1];
            } else {
                dx2 = this.points[j];
                dy2 = this.points[j + 1];
                dx1 = this.points[j - 2];
                dy1 = this.points[j - 1];
            }
            int x = (int)((dx1 - longitude1) / divx);
            int y = (int)((dy1 - latitude1) / divy);
            int xend = (int)((dx2 - longitude1) / divx);
            int yend = (int)((dy2 - latitude1) / divy);
            if (x == xend && y == yend) continue;
            int xDirection = x < xend ? 1 : -1;
            double slope = (dy1 - dy2) / (dx1 - dx2);
            double intercept = dy1 - slope * dx1;
            if (y >= 0 && y < height && x >= 0 && x < width) {
                three_state_map[y][x] = 1;
            }
            if (x == xend) {
                while (y != yend) {
                    if (++y < 0 || y >= height || x < 0 || x >= width) continue;
                    three_state_map[y][x] = 1;
                }
                continue;
            }
            if (y == yend) {
                while (x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    three_state_map[y][x] = 1;
                }
                continue;
            }
            double endlat = dy2;
            for (double k = (double)(y + 1) * divy + latitude1; k < endlat; k += divy) {
                double xcross = (k - intercept) / slope;
                int icross = (int)((xcross - longitude1) / divx);
                while (x != icross && x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    three_state_map[y][x] = 1;
                }
                if (y == yend || ++y < 0 || y >= height || x < 0 || x >= width) continue;
                three_state_map[y][x] = 1;
            }
            while (x != xend) {
                if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                three_state_map[y][x] = 1;
            }
        }
    }

    public int[][] fillAccMask(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        boolean cellsReturned;
        double divx = (longitude2 - longitude1) / (double)width;
        double divy = (latitude2 - latitude1) / (double)height;
        int[][] data = null;
        boolean bl = cellsReturned = !noCellsReturned;
        if (cellsReturned) {
            data = new int[width * height][2];
        }
        int p = 0;
        for (int j = 0; j < three_state_map[0].length; ++j) {
            for (int i = 0; i < three_state_map.length; ++i) {
                if (three_state_map[i][j] != 1) {
                    if (j == 0 || three_state_map[i][j - 1] == 1) {
                        if (i > 0 && (three_state_map[i - 1][j] == 2 || three_state_map[i - 1][j] == 0)) {
                            three_state_map[i][j] = three_state_map[i - 1][j];
                        } else if (this.isWithin((double)j * divx + divx / 2.0 + longitude1, (double)i * divy + divy / 2.0 + latitude1)) {
                            three_state_map[i][j] = 2;
                        }
                    } else {
                        three_state_map[i][j] = three_state_map[i][j - 1];
                    }
                }
                if (!cellsReturned || three_state_map[i][j] == 0) continue;
                data[p][0] = j;
                data[p][1] = i;
                ++p;
            }
        }
        if (data != null) {
            data = (int[][])Arrays.copyOf(data, p);
        }
        return data;
    }

    private void getOverlapGridCells_Box_Acc(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, double[][] bb, byte[][] three_state_map) {
        double xstep = Math.abs(longitude2 - longitude1) / (double)width;
        double ystep = Math.abs(latitude2 - latitude1) / (double)height;
        double minlong = Math.min(longitude1, longitude2);
        double minlat = Math.min(latitude1, latitude2);
        int xstart = (int)Math.floor((bb[0][0] - minlong) / xstep);
        int ystart = (int)Math.floor((bb[0][1] - minlat) / ystep);
        int xend = (int)Math.ceil((bb[1][0] - minlong) / xstep);
        int yend = (int)Math.ceil((bb[1][1] - minlat) / ystep);
        if (xstart < 0) {
            xstart = 0;
        }
        if (ystart < 0) {
            ystart = 0;
        }
        if (xend > width) {
            xend = width;
        }
        if (yend > height) {
            yend = height;
        }
        boolean p = false;
        if (xstart < xend && xend > 0) {
            for (int j = ystart; j < yend; ++j) {
                three_state_map[j][xstart] = 1;
                three_state_map[j][xend - 1] = 1;
            }
        }
        if (ystart < yend && yend > 0) {
            for (int i = xstart; i < xend; ++i) {
                three_state_map[ystart][i] = 1;
                three_state_map[yend - 1][i] = 1;
            }
        }
    }

    public int[][] getOverlapGridCells_EPSG900913(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        int[][] cells = null;
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                cells = this.getOverlapGridCells_Box(longitude1, latitude1, longitude2, latitude2, width, height, this.bounding_box, three_state_map, noCellsReturned);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                cells = this.getOverlapGridCells_Polygon_EPSG900913(longitude1, latitude1, longitude2, latitude2, width, height, three_state_map, noCellsReturned);
            }
        }
        return cells;
    }

    public void getOverlapGridCells_Acc_EPSG900913(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map) {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                this.getOverlapGridCells_Box_Acc(longitude1, latitude1, longitude2, latitude2, width, height, this.bounding_box, three_state_map);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.getOverlapGridCells_Polygon_Acc_EPSG900913(longitude1, latitude1, longitude2, latitude2, width, height, three_state_map);
            }
        }
    }

    public int[][] getOverlapGridCells_EPSG900913(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map) {
        return this.getOverlapGridCells_EPSG900913(longitude1, latitude1, longitude2, latitude2, width, height, three_state_map, false);
    }

    public int[][] getOverlapGridCells_Polygon_EPSG900913(double olongitude1, double olatitude1, double olongitude2, double olatitude2, int owidth, int oheight, byte[][] three_state_map, boolean noCellsReturned) {
        int j;
        if (three_state_map == null) {
            three_state_map = new byte[oheight][owidth];
        }
        int longitude1 = this.convertLngToPixel(olongitude1);
        int longitude2 = this.convertLngToPixel(olongitude2);
        int latitude1 = this.convertLatToPixel(olatitude2);
        int latitude2 = this.convertLatToPixel(olatitude1);
        int scale = 100;
        int width = owidth * scale;
        int height = oheight * scale;
        double divx = (longitude2 - longitude1) / width;
        double divy = (latitude2 - latitude1) / height;
        double odivx = (olongitude2 - olongitude1) / (double)owidth;
        double odivy = (olatitude2 - olatitude1) / (double)oheight;
        for (j = 2; j < this.points.length; j += 2) {
            int ox;
            int oy;
            int dy2;
            int dx2;
            int dy1;
            int dx1;
            if (this.points[j + 1] > this.points[j - 1]) {
                dx1 = this.convertLngToPixel(this.points[j]);
                dy1 = this.convertLatToPixel(this.points[j + 1]);
                dx2 = this.convertLngToPixel(this.points[j - 2]);
                dy2 = this.convertLatToPixel(this.points[j - 1]);
            } else {
                dx2 = this.convertLngToPixel(this.points[j]);
                dy2 = this.convertLatToPixel(this.points[j + 1]);
                dx1 = this.convertLngToPixel(this.points[j - 2]);
                dy1 = this.convertLatToPixel(this.points[j - 1]);
            }
            int x = (int)((double)(dx1 - longitude1) / divx);
            int y = (int)((double)(dy1 - latitude1) / divy);
            int xend = (int)((double)(dx2 - longitude1) / divx);
            int yend = (int)((double)(dy2 - latitude1) / divy);
            if (y >= 0 && y < height && x >= 0 && x < width) {
                oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                if (oy >= oheight) {
                    oy = oheight - 1;
                }
                if (ox >= owidth) {
                    ox = owidth - 1;
                }
                if (oy < 0) {
                    oy = 0;
                }
                if (ox < 0) {
                    ox = 0;
                }
                three_state_map[oy][ox] = 1;
            }
            if (x == xend && y == yend) continue;
            int xDirection = x < xend ? 1 : -1;
            double slope = (double)(dy1 - dy2) / (double)(dx1 - dx2);
            double intercept = (double)dy1 - slope * (double)dx1;
            if (x == xend) {
                while (y != yend) {
                    if (++y < 0 || y >= height || x < 0 || x >= width) continue;
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                continue;
            }
            if (y == yend) {
                while (x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                continue;
            }
            int endlat = dy2;
            int k = (int)((double)(y + 1) * divy + (double)latitude1);
            while (k < endlat) {
                int xcross = (int)(((double)k - intercept) / slope);
                int icross = (int)((double)(xcross - longitude1) / divx);
                while (x != icross && x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                if (y != yend && ++y >= 0 && y < height && x >= 0 && x < width) {
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                k = (int)((double)k + divy);
            }
            while (x != xend) {
                if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                if (oy >= oheight) {
                    oy = oheight - 1;
                }
                if (ox >= owidth) {
                    ox = owidth - 1;
                }
                if (oy < 0) {
                    oy = 0;
                }
                if (ox < 0) {
                    ox = 0;
                }
                three_state_map[oy][ox] = 1;
            }
        }
        int[][] data = new int[owidth * oheight][2];
        boolean cellsReturned = !noCellsReturned;
        int p = 0;
        for (j = 0; j < three_state_map[0].length; ++j) {
            for (int i = 0; i < three_state_map.length; ++i) {
                if (three_state_map[i][j] != 1) {
                    if (j == 0 || three_state_map[i][j - 1] == 1) {
                        if (i > 0 && (three_state_map[i - 1][j] == 2 || three_state_map[i - 1][j] == 0)) {
                            three_state_map[i][j] = three_state_map[i - 1][j];
                        } else if (this.isWithin_EPSG900913((double)j * odivx + odivx / 2.0 + olongitude1, (double)i * odivy + odivy / 2.0 + olatitude1)) {
                            three_state_map[i][j] = 2;
                        }
                    } else {
                        three_state_map[i][j] = three_state_map[i][j - 1];
                    }
                }
                if (!cellsReturned || three_state_map[i][j] == 0) continue;
                data[p][0] = j;
                data[p][1] = i;
                ++p;
            }
        }
        return (int[][])Arrays.copyOfRange(data, 0, p);
    }

    public void getOverlapGridCells_Polygon_Acc_EPSG900913(double olongitude1, double olatitude1, double olongitude2, double olatitude2, int owidth, int oheight, byte[][] three_state_map) {
        if (three_state_map == null) {
            three_state_map = new byte[oheight][owidth];
        }
        int longitude1 = this.convertLngToPixel(olongitude1);
        int longitude2 = this.convertLngToPixel(olongitude2);
        int latitude1 = this.convertLatToPixel(olatitude2);
        int latitude2 = this.convertLatToPixel(olatitude1);
        int scale = 16;
        int width = owidth * scale;
        int height = oheight * scale;
        double divx = (longitude2 - longitude1) / width;
        double divy = (latitude2 - latitude1) / height;
        double odivx = (olongitude2 - olongitude1) / (double)owidth;
        double odivy = (olatitude2 - olatitude1) / (double)oheight;
        for (int j = 2; j < this.points.length; j += 2) {
            int ox;
            int oy;
            int dy2;
            int dx2;
            int dy1;
            int dx1;
            if (this.points[j + 1] > this.points[j - 1]) {
                dx1 = this.convertLngToPixel(this.points[j]);
                dy1 = this.convertLatToPixel(this.points[j + 1]);
                dx2 = this.convertLngToPixel(this.points[j - 2]);
                dy2 = this.convertLatToPixel(this.points[j - 1]);
            } else {
                dx2 = this.convertLngToPixel(this.points[j]);
                dy2 = this.convertLatToPixel(this.points[j + 1]);
                dx1 = this.convertLngToPixel(this.points[j - 2]);
                dy1 = this.convertLatToPixel(this.points[j - 1]);
            }
            int x = (int)((double)(dx1 - longitude1) / divx);
            int y = (int)((double)(dy1 - latitude1) / divy);
            int xend = (int)((double)(dx2 - longitude1) / divx);
            int yend = (int)((double)(dy2 - latitude1) / divy);
            if (y >= 0 && y < height && x >= 0 && x < width) {
                oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                if (oy >= oheight) {
                    oy = oheight - 1;
                }
                if (ox >= owidth) {
                    ox = owidth - 1;
                }
                if (oy < 0) {
                    oy = 0;
                }
                if (ox < 0) {
                    ox = 0;
                }
                three_state_map[oy][ox] = 1;
            }
            if (x == xend && y == yend) continue;
            int xDirection = x < xend ? 1 : -1;
            double slope = (double)(dy1 - dy2) / (double)(dx1 - dx2);
            double intercept = (double)dy1 - slope * (double)dx1;
            if (x == xend) {
                while (y != yend) {
                    if (++y < 0 || y >= height || x < 0 || x >= width) continue;
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                continue;
            }
            if (y == yend) {
                while (x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                continue;
            }
            int endlat = dy2;
            int k = (int)((double)(y + 1) * divy + (double)latitude1);
            while (k < endlat) {
                int xcross = (int)(((double)k - intercept) / slope);
                int icross = (int)((double)(xcross - longitude1) / divx);
                while (x != icross && x != xend) {
                    if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                if (y != yend && ++y >= 0 && y < height && x >= 0 && x < width) {
                    oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                    ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                    if (oy >= oheight) {
                        oy = oheight - 1;
                    }
                    if (ox >= owidth) {
                        ox = owidth - 1;
                    }
                    if (oy < 0) {
                        oy = 0;
                    }
                    if (ox < 0) {
                        ox = 0;
                    }
                    three_state_map[oy][ox] = 1;
                }
                k = (int)((double)k + divy);
            }
            while (x != xend) {
                if (y < 0 || y >= height || (x += xDirection) < 0 || x >= width) continue;
                oy = (int)((this.convertPixelToLat((int)((double)y * divy + (double)latitude1)) - olatitude1) / odivy);
                ox = (int)((this.convertPixelToLng((int)((double)x * divx + (double)longitude1)) - olongitude1) / odivx);
                if (oy >= oheight) {
                    oy = oheight - 1;
                }
                if (ox >= owidth) {
                    ox = owidth - 1;
                }
                if (oy < 0) {
                    oy = 0;
                }
                if (ox < 0) {
                    ox = 0;
                }
                three_state_map[oy][ox] = 1;
            }
        }
    }

    public int[][] fillAccMask_EPSG900913(double longitude1, double latitude1, double longitude2, double latitude2, int width, int height, byte[][] three_state_map, boolean noCellsReturned) {
        boolean cellsReturned;
        double divx = (longitude2 - longitude1) / (double)width;
        double divy = (latitude2 - latitude1) / (double)height;
        int[][] data = null;
        boolean bl = cellsReturned = !noCellsReturned;
        if (cellsReturned) {
            data = new int[width * height][2];
        }
        int p = 0;
        for (int j = 0; j < three_state_map[0].length; ++j) {
            for (int i = 0; i < three_state_map.length; ++i) {
                if (three_state_map[i][j] != 1) {
                    if (j == 0 || three_state_map[i][j - 1] == 1) {
                        if (i > 0 && (three_state_map[i - 1][j] == 2 || three_state_map[i - 1][j] == 0)) {
                            three_state_map[i][j] = three_state_map[i - 1][j];
                        } else if (this.isWithin_EPSG900913((double)j * divx + divx / 2.0 + longitude1, (double)i * divy + divy / 2.0 + latitude1)) {
                            three_state_map[i][j] = 2;
                        }
                    } else {
                        three_state_map[i][j] = three_state_map[i][j - 1];
                    }
                }
                if (!cellsReturned || three_state_map[i][j] == 0) continue;
                data[p][0] = j;
                data[p][1] = i;
                ++p;
            }
        }
        if (data != null) {
            data = (int[][])Arrays.copyOf(data, p);
        }
        return data;
    }

    public int convertLngToPixel(double lng) {
        return (int)Math.round((double)this.map_offset + this.map_radius * lng * Math.PI / 180.0);
    }

    public double convertPixelToLng(int px) {
        return (double)(px - this.map_offset) / this.map_radius * 180.0 / Math.PI;
    }

    public int convertLatToPixel(double lat) {
        return (int)Math.round((double)this.map_offset - this.map_radius * Math.log((1.0 + Math.sin(lat * Math.PI / 180.0)) / (1.0 - Math.sin(lat * Math.PI / 180.0))) / 2.0);
    }

    public double convertPixelToLat(int px) {
        return Math.asin((Math.pow(Math.E, (double)(this.map_offset - px) / this.map_radius * 2.0) - 1.0) / (1.0 + Math.pow(Math.E, (double)(this.map_offset - px) / this.map_radius * 2.0))) * 180.0 / Math.PI;
    }

    public double convertMetersToPixels(double meters, double latitude, int zoom) {
        return meters / (Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / (256.0 * Math.pow(2.0, zoom)));
    }

    public double convertPixelsToMeters(int pixels, double latitude, int zoom) {
        return Math.cos(latitude * Math.PI / 180.0) * 2.0 * Math.PI * 6378137.0 / (256.0 * Math.pow(2.0, zoom)) * (double)pixels;
    }

    public double convertMetersToLng(double meters) {
        return meters / 2.0037508342789244E7 * 180.0;
    }

    public double convertMetersToLat(double meters) {
        return 57.29577951308232 * (2.0 * Math.atan(Math.exp(meters / 2.0037508342789244E7 * Math.PI)) - 1.5707963267948966);
    }
}

