/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.client;

import java.util.List;
import org.ala.layers.dao.AnalysisLayerDAO;
import org.ala.layers.dao.FieldDAO;
import org.ala.layers.dao.LayerDAO;
import org.ala.layers.dao.LayerIntersectDAO;
import org.ala.layers.dao.ObjectDAO;
import org.ala.layers.dto.Layer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Client {
    static ApplicationContext gContext = null;

    public static void main(String[] args) {
        System.out.println("Layers Store CLI client");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring/app-config.xml");
        LayerDAO layerDao = (LayerDAO)context.getBean("layerDao");
        List<Layer> layers = layerDao.getLayers();
        System.out.println("Got " + layers.size() + " layers");
        for (Layer l : layers) {
            System.out.println(" > " + l.getName());
        }
    }

    static void initContext() {
        if (gContext == null) {
            gContext = new ClassPathXmlApplicationContext("spring/app-config.xml");
        }
    }

    public static LayerDAO getLayerDao() {
        Client.initContext();
        return (LayerDAO)gContext.getBean("layerDao");
    }

    public static LayerIntersectDAO getLayerIntersectDao() {
        Client.initContext();
        LayerIntersectDAO lidao = (LayerIntersectDAO)gContext.getBean("layerIntersectDao");
        lidao.getConfig();
        return lidao;
    }

    public static FieldDAO getFieldDao() {
        Client.initContext();
        return (FieldDAO)gContext.getBean("fieldDao");
    }

    public static AnalysisLayerDAO getAnalysisLayerDao() {
        Client.initContext();
        return (AnalysisLayerDAO)gContext.getBean("analysislayerDao");
    }

    public static ObjectDAO getObjectDao() {
        Client.initContext();
        return (ObjectDAO)gContext.getBean("objectDao");
    }
}

