/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.validation;

import au.org.ala.sds.model.Message;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.validation.ValidationReport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SdsValidationReport
implements ValidationReport,
Serializable {
    private static final long serialVersionUID = 1287347805422093157L;
    private final SensitiveTaxon species;
    private final List<Message> messages;
    private String category;
    private String assertion;

    public SdsValidationReport(SensitiveTaxon species) {
        this.species = species;
        this.messages = new ArrayList<Message>();
    }

    public SensitiveTaxon getSpecies() {
        return this.species;
    }

    @Override
    public List<Message> getMessages() {
        return this.messages;
    }

    @Override
    public List<Message> getMessagesByType(Message.Type type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (Message msg : this.messages) {
            if (!msg.getType().equals((Object)type)) continue;
            msgList.add(msg);
        }
        return msgList;
    }

    @Override
    public void addMessage(Message message) {
        if (message != null) {
            this.messages.add(message);
        }
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void setAssertion(String assertion) {
        this.assertion = assertion;
    }

    @Override
    public String getAssertion() {
        return this.assertion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Message message : this.messages) {
            sb.append(message).append("\n");
        }
        return sb.toString();
    }
}

