/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.model.SensitivityZoneFactory;
import au.org.ala.sds.util.GeoLocationHelper;
import au.org.ala.sds.validation.FactCollection;
import au.org.ala.sds.validation.MessageFactory;
import au.org.ala.sds.validation.ValidationReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.gbif.dwc.terms.DwcTerm;

public class ValidationUtils {
    protected static final Logger logger = Logger.getLogger(ValidationUtils.class);

    public static boolean validateLocation(FactCollection facts, ValidationReport report) {
        String state = facts.get("stateProvince");
        String decimalLatitude = facts.get("decimalLatitude");
        String decimalLongitude = facts.get("decimalLongitude");
        Set<Object> zones = new HashSet<SensitivityZone>();
        if (state == null) {
            if (StringUtils.isNotBlank((String)decimalLatitude) && StringUtils.isNotBlank((String)decimalLongitude)) {
                try {
                    zones = GeoLocationHelper.getZonesContainingPoint(decimalLatitude, decimalLongitude);
                }
                catch (Exception e) {
                    logger.error((Object)"Problem getting zone from lat/long", (Throwable)e);
                }
            } else if (StringUtils.isNotBlank((String)facts.get("country"))) {
                if (facts.get("country").equalsIgnoreCase(SensitivityZoneFactory.getZone("AUS").getName())) {
                    zones.add(SensitivityZoneFactory.getZone("AUS"));
                } else {
                    zones.add(SensitivityZoneFactory.getZone("NOTAUS"));
                }
            }
        } else {
            SensitivityZone zone = SensitivityZoneFactory.getZoneByName(state);
            if (zone == null) {
                zone = SensitivityZoneFactory.getZone(state.toUpperCase());
            }
            if (zone == null) {
                String country = facts.get("country");
                if (StringUtils.isNotBlank((String)country) && !country.equalsIgnoreCase("Australia") && !country.equalsIgnoreCase("AUS")) {
                    report.addMessage(MessageFactory.createErrorMessage("NotAus", country));
                } else {
                    report.addMessage(MessageFactory.createErrorMessage("StateInvalid", state));
                }
                return false;
            }
            zones.add(zone);
        }
        facts.add("zone", zones.toString());
        return true;
    }

    public static boolean validateLocationCoords(FactCollection facts, ValidationReport report) {
        String decimalLatitude = facts.get("decimalLatitude");
        String decimalLongitude = facts.get("decimalLongitude");
        if (StringUtils.isBlank((String)decimalLatitude) || StringUtils.isBlank((String)decimalLongitude)) {
            if (StringUtils.isBlank((String)facts.get("stateProvince"))) {
                report.addMessage(MessageFactory.createInfoMessage("LatLongMissing"));
                return false;
            }
            return true;
        }
        return ValidationUtils.isValidNumber(decimalLatitude) && ValidationUtils.isValidNumber(decimalLongitude);
    }

    public static String validateName(Map<String, String> facts) {
        String scientificName = facts.get("scientificName");
        if (StringUtils.isNotBlank((String)scientificName) && !scientificName.equalsIgnoreCase("\\N")) {
            return scientificName;
        }
        String genus = facts.get("genus");
        String specificEpithet = facts.get("specificEpithet");
        String intraSpecificEpithet = facts.get("intraspecificEpithet");
        if (StringUtils.isBlank((String)specificEpithet)) {
            return StringUtils.isBlank((String)genus) ? "" : genus;
        }
        StringBuilder name = new StringBuilder(genus);
        name.append(" ").append(specificEpithet);
        if (StringUtils.isNotBlank((String)intraSpecificEpithet)) {
            name.append(" ").append(intraSpecificEpithet);
        }
        return name.toString();
    }

    public static boolean isValidNumber(String number) {
        if (StringUtils.isBlank((String)number)) {
            return false;
        }
        try {
            Float.parseFloat(number);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static Map<String, Object> restrictForPests(Map<String, String> properties) {
        return ValidationUtils.restrictToTypes(properties, new String[]{"dataResourceUid", "institutionCode", "collectionCode"}, "Taxon");
    }

    public static Map<String, Object> restrictToTypes(Map<String, String> properties, String[] extraFields, String ... types) {
        ArrayList<String> list = new ArrayList<String>();
        for (String type : types) {
            List terms = DwcTerm.listByGroup((String)type);
            for (DwcTerm term : terms) {
                list.add(term.simpleName());
            }
        }
        if (extraFields != null) {
            for (String f : extraFields) {
                list.add(f);
            }
        }
        return ValidationUtils.restrictProperties(properties, list, false);
    }

    public static Map<String, Object> restrictProperties(Map<String, String> properties, List<String> list, boolean isBlacklist) {
        HashMap<String, String> originalSensitiveValues = new HashMap<String, String>();
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String key : properties.keySet()) {
            String value = properties.get(key);
            if (StringUtils.isNotBlank((String)value) && (list.contains(key) && isBlacklist || !list.contains(key) && !isBlacklist)) {
                results.put(key, "");
                originalSensitiveValues.put(key, value);
                continue;
            }
            results.put(key, value);
        }
        results.put("originalSensitiveValues", originalSensitiveValues);
        return results;
    }
}

