/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.names.search.SearchResultException;
import au.org.ala.sds.dao.SensitiveSpeciesDao;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitivityInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SensitiveTaxonStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = Logger.getLogger(SensitiveTaxonStore.class);
    private final List<SensitiveTaxon> taxonList;
    private final Map<String, Integer> lsidMap;
    private final Map<String, Integer> nameMap;
    private final transient ALANameSearcher namesSearcher;

    public SensitiveTaxonStore(SensitiveSpeciesDao dao, ALANameSearcher nameSearcher) throws Exception {
        this.namesSearcher = nameSearcher;
        this.lsidMap = new HashMap<String, Integer>();
        this.nameMap = new HashMap<String, Integer>();
        this.taxonList = dao.getAll();
        this.verifyAndInitialiseSpeciesList();
    }

    private void verifyAndInitialiseSpeciesList() {
        ArrayList<SensitiveTaxon> additionalAcceptedTaxons = new ArrayList<SensitiveTaxon>();
        for (SensitiveTaxon st : this.taxonList) {
            NameSearchResult match = this.lookupName(st);
            if (match != null) {
                NameSearchResult accepted;
                st.setLsid(match.getLsid());
                if (match.isSynonym() && (accepted = this.getAcceptedNameFromSynonym(match)) != null) {
                    String acceptedName = accepted.getRankClassification().getScientificName();
                    logger.info((Object)("Sensitive species '" + st.getName() + "' is not accepted name - using '" + acceptedName + "'"));
                    SensitiveTaxon acceptedTaxon = this.findByExactMatch(acceptedName);
                    if (acceptedTaxon == null) {
                        acceptedTaxon = new SensitiveTaxon(acceptedName, StringUtils.contains((String)acceptedName, (char)' ') ? SensitiveTaxon.Rank.SPECIES : SensitiveTaxon.Rank.GENUS);
                        acceptedTaxon.setLsid(accepted.getLsid());
                        if (!additionalAcceptedTaxons.contains(acceptedTaxon)) {
                            additionalAcceptedTaxons.add(acceptedTaxon);
                            logger.info((Object)("Accepted name '" + acceptedName + "' (" + acceptedTaxon.getLsid() + ") added to sensitive taxon list"));
                        }
                    }
                    st.setAcceptedName(acceptedName);
                }
                logger.debug((Object)(st.getName() + (st.getAcceptedName() == null ? "" : " (" + st.getAcceptedName() + ")") + "\t" + st.getLsid()));
                continue;
            }
            logger.warn((Object)("Sensitive species '" + st.getName() + "' not found in NameMatching index"));
        }
        this.taxonList.addAll(additionalAcceptedTaxons);
        Collections.sort(this.taxonList);
        for (int i = 0; i < this.taxonList.size(); ++i) {
            SensitiveTaxon st;
            st = this.taxonList.get(i);
            String lsid = st.getLsid();
            if (StringUtils.isNotBlank((String)lsid)) {
                this.lsidMap.put(st.getLsid(), i);
            }
            if (st.getAcceptedName() != null) {
                SensitiveTaxon acceptedTaxon = this.findByExactMatch(st.getAcceptedName());
                if (acceptedTaxon != null) {
                    for (SensitivityInstance si : st.getInstances()) {
                        if (acceptedTaxon.getInstances().contains(si)) continue;
                        acceptedTaxon.getInstances().add(si);
                    }
                    st.setAcceptedTaxon(acceptedTaxon);
                    continue;
                }
                logger.error((Object)("Accepted taxon '" + st.getAcceptedName() + "' not found in taxon list"));
                continue;
            }
            if (!StringUtils.isNotBlank((String)lsid)) continue;
            this.nameMap.put(st.getName(), i);
            logger.debug((Object)("Added '" + st.getName() + "' to nameMap"));
        }
    }

    public SensitiveTaxon findByName(String name) {
        Integer index;
        String acceptedName = name;
        NameSearchResult result = this.getAcceptedName(name);
        if (result != null) {
            acceptedName = result.getRankClassification().getScientificName();
        }
        if ((index = this.nameMap.get(acceptedName)) != null) {
            return this.taxonList.get(index);
        }
        return this.findByExactMatch(name);
    }

    public SensitiveTaxon findByAcceptedName(String acceptedName) {
        Integer index = this.nameMap.get(acceptedName);
        if (index != null) {
            return this.taxonList.get(index);
        }
        return null;
    }

    public SensitiveTaxon findByLsid(String lsid) {
        Integer index = this.lsidMap.get(lsid);
        if (index != null) {
            return this.taxonList.get(index);
        }
        return null;
    }

    public SensitiveTaxon findByExactMatch(String name) {
        int idx = Collections.binarySearch(this.taxonList, new SensitiveTaxon(name, StringUtils.contains((String)name, (char)' ') ? SensitiveTaxon.Rank.SPECIES : SensitiveTaxon.Rank.GENUS));
        if (idx >= 0 && this.taxonList.get(idx).getName().equalsIgnoreCase(name)) {
            return this.taxonList.get(idx);
        }
        return null;
    }

    private NameSearchResult getAcceptedName(String name) {
        NameSearchResult match = null;
        if (this.namesSearcher != null) {
            try {
                match = this.namesSearcher.searchForRecord(name, null);
                if (match != null && match.isSynonym()) {
                    match = this.getAcceptedNameFromSynonym(match);
                }
            }
            catch (SearchResultException e) {
                logger.debug((Object)("'" + name + "' - " + e.getMessage()));
            }
            catch (RuntimeException e) {
                logger.error((Object)("'" + name + "'"), (Throwable)e);
            }
        }
        return match;
    }

    private NameSearchResult lookupName(SensitiveTaxon st) {
        String name = null;
        NameSearchResult match = null;
        if (this.namesSearcher != null) {
            try {
                name = st.getTaxonName();
                LinnaeanRankClassification lrc = new LinnaeanRankClassification(null, null, null, null, st.getFamily().equals("") ? null : st.getFamily(), null, name);
                match = this.namesSearcher.searchForRecord(name, lrc, null);
            }
            catch (SearchResultException e) {
                logger.debug((Object)("'" + name + "' - " + e.getMessage()));
            }
            catch (RuntimeException e) {
                logger.error((Object)("'" + name + "'"), (Throwable)e);
            }
        }
        return match;
    }

    private NameSearchResult getAcceptedNameFromSynonym(NameSearchResult match) {
        if (match.isSynonym()) {
            NameSearchResult accepted = this.namesSearcher.searchForRecordByLsid(match.getAcceptedLsid());
            if (accepted == null) {
                logger.error((Object)("Could not find accepted name for synonym '" + match.getCleanName() + "'"));
            }
            return accepted;
        }
        return match;
    }
}

