/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dao;

import au.org.ala.sds.dao.RawOccurrenceDao;
import au.org.ala.sds.dto.SpeciesOccurrenceDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class RawOccurrenceDaoImpl
extends JdbcDaoSupport
implements RawOccurrenceDao {
    protected static final Logger logger = Logger.getLogger(RawOccurrenceDaoImpl.class);
    public static final String SELECT_ALL_OCCURRENCES = "SELECT id, scientific_name, latitude, longitude FROM raw_occurrence_record";
    public static final String UPDATE_OCCURRENCE = "UPDATE raw_occurrence_record SET latitude=?, longitude=?, generalised_metres=?, raw_latitude=?, raw_longitude=? WHERE id=?";
    public static final String REUPDATE_OCCURRENCE = "UPDATE raw_occurrence_record SET latitude=?, longitude=?, generalised_metres=? WHERE id=?";

    public RawOccurrenceDaoImpl(DataSource dataSource) {
        this.setDataSource(dataSource);
        logger.debug((Object)("Occurrence data source set - " + dataSource.toString()));
    }

    @Override
    public void updateLocation(int id, String generalisedLat, String generalisedLong, String generalisedMetres, String rawLat, String rawLong) {
        int rows = this.getJdbcTemplate().update(UPDATE_OCCURRENCE, new Object[]{generalisedLat, generalisedLong, generalisedMetres, rawLat, rawLong, new Integer(id)});
        if (rows == 0) {
            logger.warn((Object)("No rows updated for id=" + id));
        }
    }

    @Override
    public void updateLocation(int id, String generalisedLat, String generalisedLong, String generalisedMetres) {
        int rows = this.getJdbcTemplate().update(REUPDATE_OCCURRENCE, new Object[]{generalisedLat, generalisedLong, generalisedMetres, new Integer(id)});
        if (rows == 0) {
            logger.warn((Object)("No rows updated for id=" + id));
        }
    }

    @Override
    public List<SpeciesOccurrenceDto> getOccurrences() {
        return this.getJdbcTemplate().query(SELECT_ALL_OCCURRENCES, new Object[0], (RowMapper)new RowMapper<SpeciesOccurrenceDto>(){

            public SpeciesOccurrenceDto mapRow(ResultSet rs, int row) throws SQLException {
                SpeciesOccurrenceDto occ = new SpeciesOccurrenceDto();
                occ.setId(rs.getInt("id"));
                occ.setScientificName(rs.getString("scientific_name"));
                occ.setLatitude(rs.getString("latitude"));
                occ.setLongitude(rs.getString("longitude"));
                return occ;
            }
        });
    }
}

