/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds;

import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.sds.SensitiveSpeciesFinder;
import au.org.ala.sds.dao.SensitiveSpeciesMySqlDao;
import au.org.ala.sds.dao.SensitiveSpeciesXmlDao;
import au.org.ala.sds.model.SensitiveTaxonStore;
import au.org.ala.sds.util.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class SensitiveSpeciesFinderFactory {
    protected static final Logger logger = Logger.getLogger(SensitiveSpeciesFinderFactory.class);
    private static final String SPECIES_RESOURCE = "sensitive-species.xml";

    public static SensitiveSpeciesFinder getSensitiveSpeciesFinder(DataSource dataSource, ALANameSearcher nameSearcher) throws Exception {
        SensitiveSpeciesMySqlDao dao = new SensitiveSpeciesMySqlDao(dataSource);
        SensitiveTaxonStore store = new SensitiveTaxonStore(dao, nameSearcher);
        return new SensitiveSpeciesFinder(store);
    }

    public static SensitiveSpeciesFinder getSensitiveSpeciesFinder(String dataUrl, ALANameSearcher nameSearcher) throws Exception {
        return SensitiveSpeciesFinderFactory.getSensitiveSpeciesFinder(dataUrl, nameSearcher, false);
    }

    public static SensitiveSpeciesFinder getSensitiveSpeciesFinder(String dataUrl, ALANameSearcher nameSearcher, boolean forceReload) throws Exception {
        SensitiveTaxonStore store = null;
        if (Configuration.getInstance().isCached() && !forceReload) {
            File cache = new File(Configuration.getInstance().getCacheUrl());
            if (cache.exists()) {
                logger.info((Object)("Reading SensitveTaxonStore from serialized cache file " + cache.getPath()));
                store = SensitiveSpeciesFinderFactory.getStoreFromCache(cache);
            } else {
                store = SensitiveSpeciesFinderFactory.getStoreFromUrl(dataUrl, nameSearcher);
                SensitiveSpeciesFinderFactory.writeStoreCache(cache, store);
            }
        } else {
            store = SensitiveSpeciesFinderFactory.getStoreFromUrl(dataUrl, nameSearcher);
        }
        return new SensitiveSpeciesFinder(store);
    }

    public static SensitiveSpeciesFinder getSensitiveSpeciesFinder(ALANameSearcher nameSearcher) throws Exception {
        return SensitiveSpeciesFinderFactory.getSensitiveSpeciesFinder(Configuration.getInstance().getSpeciesUrl(), nameSearcher);
    }

    private static SensitiveTaxonStore getStoreFromUrl(String dataUrl, ALANameSearcher cbIndexSearcher) throws Exception {
        URL url = null;
        InputStream is = null;
        try {
            url = new URL(dataUrl);
            is = url.openStream();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting species list from " + dataUrl), (Throwable)e);
            is = SensitiveSpeciesFinderFactory.class.getClassLoader().getResourceAsStream(SPECIES_RESOURCE);
            if (is == null) {
                logger.error((Object)"Unable to read sensitive-species.xml from jar file");
            }
            logger.info((Object)"Reading bundled resource sensitive-species.xml from jar file");
        }
        SensitiveSpeciesXmlDao dao = null;
        try {
            dao = new SensitiveSpeciesXmlDao(is);
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred parsing species list from " + is.toString()), (Throwable)e);
        }
        return new SensitiveTaxonStore(dao, cbIndexSearcher);
    }

    private static SensitiveTaxonStore getStoreFromCache(File cache) {
        SensitiveTaxonStore store = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(cache));
            store = (SensitiveTaxonStore)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error deserializing SensitiveTaxonStore", (Throwable)e);
        }
        return store;
    }

    private static void writeStoreCache(File cache, SensitiveTaxonStore store) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(cache));
            oos.writeObject(store);
            oos.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error serializing SensitiveTaxonStore", (Throwable)e);
        }
    }
}

