/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.lucene.util.OpenBitSet;

public class BlockLocks {
    private AtomicLongArray bits;
    private int wlen;

    public BlockLocks(long numBits) {
        int length = OpenBitSet.bits2words((long)numBits);
        this.bits = new AtomicLongArray(length);
        this.wlen = length;
    }

    public int nextClearBit(int index) {
        int i = index >> 6;
        if (i >= this.wlen) {
            return -1;
        }
        int subIndex = index & 0x3F;
        long word = (this.bits.get(i) ^ 0xFFFFFFFFFFFFFFFFL) >> subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex + Long.numberOfTrailingZeros(word);
        }
        while (++i < this.wlen) {
            word = this.bits.get(i) ^ 0xFFFFFFFFFFFFFFFFL;
            if (word == 0L) continue;
            return (i << 6) + Long.numberOfTrailingZeros(word);
        }
        return -1;
    }

    public boolean set(int index) {
        long word;
        long oword;
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        do {
            if (((word = this.bits.get(wordNum)) & bitmask) == 0L) continue;
            return false;
        } while (!this.bits.compareAndSet(wordNum, oword = word, word |= bitmask));
        return true;
    }

    public void clear(int index) {
        long word;
        long oword;
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        while (!this.bits.compareAndSet(wordNum, oword = (word = this.bits.get(wordNum)), word &= bitmask ^ 0xFFFFFFFFFFFFFFFFL)) {
        }
    }
}

