/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.store.blockcache.BlockCache;
import org.apache.solr.store.blockcache.BlockCacheKey;
import org.apache.solr.store.blockcache.Cache;
import org.apache.solr.store.blockcache.Metrics;

public class BlockDirectoryCache
implements Cache {
    private BlockCache blockCache;
    private AtomicInteger counter = new AtomicInteger();
    private Map<String, Integer> names = new ConcurrentHashMap<String, Integer>();
    private Metrics metrics;

    public BlockDirectoryCache(BlockCache blockCache, Metrics metrics) {
        this.blockCache = blockCache;
        this.metrics = metrics;
    }

    @Override
    public void delete(String name) {
        this.names.remove(name);
    }

    @Override
    public void update(String name, long blockId, int blockOffset, byte[] buffer, int offset, int length) {
        Integer file = this.names.get(name);
        if (file == null) {
            file = this.counter.incrementAndGet();
            this.names.put(name, file);
        }
        BlockCacheKey blockCacheKey = new BlockCacheKey();
        blockCacheKey.setBlock(blockId);
        blockCacheKey.setFile(file);
        this.blockCache.store(blockCacheKey, blockOffset, buffer, offset, length);
    }

    @Override
    public boolean fetch(String name, long blockId, int blockOffset, byte[] b, int off, int lengthToReadInBlock) {
        Integer file = this.names.get(name);
        if (file == null) {
            return false;
        }
        BlockCacheKey blockCacheKey = new BlockCacheKey();
        blockCacheKey.setBlock(blockId);
        blockCacheKey.setFile(file);
        boolean fetch = this.blockCache.fetch(blockCacheKey, b, blockOffset, off, lengthToReadInBlock);
        if (fetch) {
            this.metrics.blockCacheHit.incrementAndGet();
        } else {
            this.metrics.blockCacheMiss.incrementAndGet();
        }
        return fetch;
    }

    @Override
    public long size() {
        return this.blockCache.getSize();
    }

    @Override
    public void renameCacheFile(String source, String dest) {
        Integer file = this.names.remove(source);
        if (file != null) {
            this.names.put(dest, file);
        }
    }
}

