/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.Locale;
import org.apache.solr.rest.schema.CopyFieldCollectionResource;
import org.apache.solr.rest.schema.DefaultSchemaResource;
import org.apache.solr.rest.schema.DefaultSearchFieldResource;
import org.apache.solr.rest.schema.DynamicFieldCollectionResource;
import org.apache.solr.rest.schema.DynamicFieldResource;
import org.apache.solr.rest.schema.FieldCollectionResource;
import org.apache.solr.rest.schema.FieldResource;
import org.apache.solr.rest.schema.FieldTypeCollectionResource;
import org.apache.solr.rest.schema.FieldTypeResource;
import org.apache.solr.rest.schema.SchemaNameResource;
import org.apache.solr.rest.schema.SchemaResource;
import org.apache.solr.rest.schema.SchemaSimilarityResource;
import org.apache.solr.rest.schema.SchemaVersionResource;
import org.apache.solr.rest.schema.SolrQueryParserDefaultOperatorResource;
import org.apache.solr.rest.schema.SolrQueryParserResource;
import org.apache.solr.rest.schema.UniqueKeyFieldResource;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRestApi
extends Application {
    public static final Logger log = LoggerFactory.getLogger(SolrRestApi.class);
    public static final String FIELDS_PATH = "/fields";
    public static final String DYNAMIC_FIELDS = "dynamicFields".toLowerCase(Locale.ROOT);
    public static final String DYNAMIC_FIELDS_PATH = "/" + DYNAMIC_FIELDS;
    public static final String FIELDTYPES = "fieldTypes".toLowerCase(Locale.ROOT);
    public static final String FIELDTYPES_PATH = "/" + FIELDTYPES;
    public static final String NAME_PATH = "/" + "name".toLowerCase(Locale.ROOT);
    public static final String NAME_SEGMENT = "/{" + "name".toLowerCase(Locale.ROOT) + "}";
    public static final String COPY_FIELDS = "copyFields".toLowerCase(Locale.ROOT);
    public static final String COPY_FIELDS_PATH = "/" + COPY_FIELDS;
    public static final String VERSION_PATH = "/" + "version".toLowerCase(Locale.ROOT);
    public static final String DEFAULT_SEARCH_FIELD = "defaultSearchField".toLowerCase(Locale.ROOT);
    public static final String DEFAULT_SEARCH_FIELD_PATH = "/" + DEFAULT_SEARCH_FIELD;
    public static final String SIMILARITY_PATH = "/" + "similarity".toLowerCase(Locale.ROOT);
    public static final String SOLR_QUERY_PARSER = "solrQueryParser".toLowerCase(Locale.ROOT);
    public static final String SOLR_QUERY_PARSER_PATH = "/" + SOLR_QUERY_PARSER;
    public static final String DEFAULT_OPERATOR = "defaultOperator".toLowerCase(Locale.ROOT);
    public static final String DEFAULT_OPERATOR_PATH = SOLR_QUERY_PARSER_PATH + "/" + DEFAULT_OPERATOR;
    public static final String UNIQUE_KEY_FIELD = "uniqueKey".toLowerCase(Locale.ROOT);
    public static final String UNIQUE_KEY_FIELD_PATH = "/" + UNIQUE_KEY_FIELD;
    private Router router = new Router(this.getContext());

    public void stop() throws Exception {
        if (null != this.router) {
            this.router.stop();
        }
    }

    public synchronized Restlet createInboundRoot() {
        log.info("createInboundRoot started");
        this.router.attach("", SchemaResource.class);
        this.router.attach("/", SchemaResource.class);
        this.router.attach(FIELDS_PATH, FieldCollectionResource.class);
        this.router.attach("/fields/", FieldCollectionResource.class);
        this.router.attach(FIELDS_PATH + NAME_SEGMENT, FieldResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH, DynamicFieldCollectionResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH + "/", DynamicFieldCollectionResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH + NAME_SEGMENT, DynamicFieldResource.class);
        this.router.attach(FIELDTYPES_PATH, FieldTypeCollectionResource.class);
        this.router.attach(FIELDTYPES_PATH + "/", FieldTypeCollectionResource.class);
        this.router.attach(FIELDTYPES_PATH + NAME_SEGMENT, FieldTypeResource.class);
        this.router.attach(COPY_FIELDS_PATH, CopyFieldCollectionResource.class);
        this.router.attach(COPY_FIELDS_PATH + "/", CopyFieldCollectionResource.class);
        this.router.attach(NAME_PATH, SchemaNameResource.class);
        this.router.attach(VERSION_PATH, SchemaVersionResource.class);
        this.router.attach(UNIQUE_KEY_FIELD_PATH, UniqueKeyFieldResource.class);
        this.router.attach(DEFAULT_SEARCH_FIELD_PATH, DefaultSearchFieldResource.class);
        this.router.attach(SIMILARITY_PATH, SchemaSimilarityResource.class);
        this.router.attach(SOLR_QUERY_PARSER_PATH, SolrQueryParserResource.class);
        this.router.attach(DEFAULT_OPERATOR_PATH, SolrQueryParserDefaultOperatorResource.class);
        this.router.attachDefault(DefaultSchemaResource.class);
        log.info("createInboundRoot complete");
        return this.router;
    }
}

