/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv.writer;

import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import org.apache.solr.internal.csv.writer.CSVConfig;
import org.apache.solr.internal.csv.writer.CSVField;

public class CSVWriter {
    private CSVConfig config;
    private Writer writer;

    public CSVWriter() {
    }

    public CSVWriter(CSVConfig config) {
        this.setConfig(config);
    }

    public void writeRecord(Map map) {
        CSVField[] fields = this.config.getFields();
        try {
            int i;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < fields.length; ++i) {
                Object o = map.get(fields[i].getName());
                if (o != null) {
                    String value = o.toString();
                    value = this.writeValue(fields[i], value);
                    sb.append(value);
                }
                if (this.config.isDelimiterIgnored() || fields.length == i + 1) continue;
                sb.append(this.config.getDelimiter());
            }
            if (this.config.isEndTrimmed()) {
                for (i = sb.length() - 1; i >= 0; --i) {
                    System.out.println("i : " + i);
                    if (!Character.isWhitespace(sb.charAt(i))) break;
                    sb.deleteCharAt(i);
                }
            }
            sb.append("\n");
            String line = sb.toString();
            this.writer.write(line);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String writeValue(CSVField field, String value) throws Exception {
        if (this.config.isFixedWidth()) {
            if (value.length() < field.getSize()) {
                int fillPattern = this.config.getFill();
                if (field.overrideFill()) {
                    fillPattern = field.getFill();
                }
                StringBuffer sb = new StringBuffer();
                int fillSize = field.getSize() - value.length();
                char[] fill = new char[fillSize];
                Arrays.fill(fill, this.config.getFillChar());
                if (fillPattern == 1) {
                    sb.append(fill);
                    sb.append(value);
                    value = sb.toString();
                } else {
                    sb.append(value);
                    sb.append(fill);
                    value = sb.toString();
                }
            } else if (value.length() > field.getSize()) {
                value = value.substring(0, field.getSize());
            }
            if (!this.config.isValueDelimiterIgnored()) {
                value = this.config.getValueDelimiter() + value + this.config.getValueDelimiter();
            }
        }
        return value;
    }

    public CSVConfig getConfig() {
        return this.config;
    }

    public void setConfig(CSVConfig config) {
        this.config = config;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

