/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamUtils.class);

    public InputStream classpathStream(String path) {
        InputStream in = null;
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url != null) {
            try {
                in = url.openStream();
            }
            catch (IOException e) {
                LOG.warn("Cant open classpath input stream " + path, (Throwable)e);
            }
        }
        return in;
    }

    public String readEntireStream(InputStream source) {
        return this.readEntireStream(source, "UTF8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readEntireStream(InputStream source, String encoding) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(source, encoding));
        }
        catch (UnsupportedEncodingException e1) {
            throw new IllegalArgumentException("Unsupported encoding" + encoding, e1);
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException e) {
            LOG.warn("Caught exception", (Throwable)e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {
                LOG.warn("Caught exception", (Throwable)e);
            }
        }
        return sb.toString();
    }
}

