/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.load.BVPLoader;
import au.org.ala.biocache.load.IngestTool$;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class BVPLoader$
implements Tool {
    public static final BVPLoader$ MODULE$;
    private final Logger logger;

    static {
        new BVPLoader$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "volunteer-ingest";
    }

    @Override
    public String desc() {
        return "Harvests data from the volunteer portal";
    }

    @Override
    public void main(String[] args) {
        BooleanRef ingestResources = new BooleanRef(false);
        BooleanRef syncOnly = new BooleanRef(false);
        BooleanRef debugOnly = new BooleanRef(false);
        BooleanRef skipLoading = new BooleanRef(false);
        BooleanRef skipSampling = new BooleanRef(false);
        BooleanRef skipProcessing = new BooleanRef(false);
        BooleanRef skipIndexing = new BooleanRef(false);
        ObjectRef startAt = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(ingestResources, syncOnly, debugOnly, skipLoading, skipSampling, skipProcessing, skipIndexing, startAt){
            {
                this.opt("debug", "Display the list of expeditions. For debug purposes.", (Function0<BoxedUnit>)new Serializable(this, debugOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef debugOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.debugOnly$1.elem = true;
                    }
                    {
                        this.debugOnly$1 = debugOnly$1;
                    }
                });
                this.opt("sync-only", "synchronise the list of data resources. Dont ingest.", (Function0<BoxedUnit>)new Serializable(this, syncOnly$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef syncOnly$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.syncOnly$1.elem = true;
                    }
                    {
                        this.syncOnly$1 = syncOnly$1;
                    }
                });
                this.opt("skip-loading", "Ingest but don't load.", (Function0<BoxedUnit>)new Serializable(this, skipLoading$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipLoading$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipLoading$1.elem = true;
                    }
                    {
                        this.skipLoading$1 = skipLoading$1;
                    }
                });
                this.opt("skip-sampling", "Ingest but don't sample.", (Function0<BoxedUnit>)new Serializable(this, skipSampling$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipSampling$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipSampling$1.elem = true;
                    }
                    {
                        this.skipSampling$1 = skipSampling$1;
                    }
                });
                this.opt("skip-processing", "Ingest but don't process.", (Function0<BoxedUnit>)new Serializable(this, skipProcessing$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipProcessing$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipProcessing$1.elem = true;
                    }
                    {
                        this.skipProcessing$1 = skipProcessing$1;
                    }
                });
                this.opt("skip-indexing", "Ingest but don't indexing.", (Function0<BoxedUnit>)new Serializable(this, skipIndexing$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef skipIndexing$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.skipIndexing$1.elem = true;
                    }
                    {
                        this.skipIndexing$1 = skipIndexing$1;
                    }
                });
                this.opt("i", "ingest", "flag to indicate all resources should be loaded", (Function0<BoxedUnit>)new Serializable(this, ingestResources$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef ingestResources$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.ingestResources$1.elem = true;
                    }
                    {
                        this.ingestResources$1 = ingestResources$1;
                    }
                });
                this.opt("sa", "start-at-uid", "Start ingesting resources at the supplied UID", (Function1<String, BoxedUnit>)new Serializable(this, startAt$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startAt$1;

                    public final void apply(String v) {
                        this.startAt$1.elem = v;
                    }
                    {
                        this.startAt$1 = startAt$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            BVPLoader b = new BVPLoader();
            if (debugOnly.elem) {
                b.displayList();
            } else {
                Seq drsToIngest;
                Seq seq;
                Seq drsList = b.retrieveList();
                this.logger().info(new StringBuilder().append((Object)"Number of resources to harvest: ").append((Object)BoxesRunTime.boxToInteger((int)drsList.size())).toString());
                if (this.logger().isDebugEnabled()) {
                    drsList.foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(String dr) {
                            BVPLoader$.MODULE$.logger().debug(new StringBuilder().append((Object)"Will harvest: ").append((Object)dr).toString());
                        }
                    });
                }
                String string = (String)startAt.elem;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    seq = drsList;
                } else {
                    int idx = drsList.indexOf((Object)((String)startAt.elem));
                    seq = drsToIngest = idx > 0 ? (Seq)drsList.drop(idx) : drsList;
                }
                if (ingestResources.elem && !syncOnly.elem) {
                    drsToIngest.foreach((Function1)new Serializable(skipLoading, skipSampling, skipProcessing, skipIndexing){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef skipLoading$1;
                        private final BooleanRef skipSampling$1;
                        private final BooleanRef skipProcessing$1;
                        private final BooleanRef skipIndexing$1;

                        public final void apply(String drUid) {
                            try {
                                String x$3 = drUid;
                                boolean x$4 = this.skipLoading$1.elem;
                                boolean x$5 = this.skipSampling$1.elem;
                                boolean x$6 = this.skipProcessing$1.elem;
                                boolean x$7 = this.skipIndexing$1.elem;
                                IngestTool$.MODULE$.ingestResource(x$3, x$7, x$4, x$6, x$5);
                            }
                            catch (Exception exception) {
                                BVPLoader$.MODULE$.logger().error(exception.getMessage(), (Throwable)exception);
                            }
                        }
                        {
                            this.skipLoading$1 = skipLoading$1;
                            this.skipSampling$1 = skipSampling$1;
                            this.skipProcessing$1 = skipProcessing$1;
                            this.skipIndexing$1 = skipIndexing$1;
                        }
                    });
                }
            }
        }
    }

    private BVPLoader$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"BVPLoader");
    }
}

