/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.sds.model.SensitivityCategory;
import au.org.ala.sds.model.SensitivityInstance;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.util.DateHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PlantPestInstance
extends SensitivityInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date fromDate;
    private final Date toDate;
    private List<TransientEvent> transientEventList;

    public PlantPestInstance(SensitivityCategory category, String authority, String dataResourceId, SensitivityZone zone, String reason, String remarks, String fromDate, String toDate) {
        super(category, authority, dataResourceId, zone, reason, remarks);
        this.fromDate = StringUtils.isNotEmpty((String)fromDate) ? DateHelper.parseDate(fromDate) : null;
        this.toDate = StringUtils.isNotEmpty((String)toDate) ? DateHelper.parseDate(toDate) : null;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void addTransientEvent(String eventDate, SensitivityZone zone) {
        if (this.transientEventList == null) {
            this.transientEventList = new ArrayList<TransientEvent>();
        }
        this.transientEventList.add(new TransientEvent(eventDate, zone));
    }

    public List<TransientEvent> getTransientEventList() {
        return this.transientEventList;
    }

    public class TransientEvent
    implements Serializable {
        private final Date eventDate;
        private final SensitivityZone zone;

        public TransientEvent(String eventDate, SensitivityZone zone) {
            this.eventDate = StringUtils.isNotEmpty((String)eventDate) ? DateHelper.parseDate(eventDate) : null;
            this.zone = zone;
        }

        public Date getEventDate() {
            return this.eventDate;
        }

        public SensitivityZone getZone() {
            return this.zone;
        }

        public String toString() {
            return "TransientEvent{eventDate=" + this.eventDate + ", zone=" + this.zone + '}';
        }
    }
}

