/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dto;

import org.apache.commons.lang.StringUtils;

public class DataStreamProperties {
    private final int startRow;
    private final int endRow;
    private final int sheetIndex;

    public DataStreamProperties(int startRow, int endRow, int sheetIndex) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.sheetIndex = sheetIndex;
    }

    public DataStreamProperties(int startRow, int endRow) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.sheetIndex = 0;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public static int validateStartRow(String row) {
        if (StringUtils.isBlank((String)row) || row.equals("0") || !StringUtils.isNumeric((String)row)) {
            return 1;
        }
        return Integer.parseInt(row);
    }

    public static int validateEndRow(String row) {
        if (StringUtils.isBlank((String)row) || !StringUtils.isNumeric((String)row)) {
            return 0;
        }
        return Integer.parseInt(row);
    }

    public static int validateSheetIndex(String index) {
        if (StringUtils.isBlank((String)index) || !StringUtils.isNumeric((String)index)) {
            return 1;
        }
        return Integer.parseInt(index);
    }
}

