/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.gbif.api.vocabulary.Language;
import org.gbif.common.parsers.core.EnumParser;

public class LanguageParser
extends EnumParser<Language> {
    private static LanguageParser singletonObject = null;
    private static final Splitter TAB_SPLITTER = Splitter.on((char)'\t').trimResults();
    private static final Splitter SEMICOLON_SPLITTER = Splitter.on((char)';').trimResults();

    private LanguageParser() {
        super(Language.class, false, new InputStream[0]);
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(LanguageParser.class.getResourceAsStream("/dictionaries/parse/iso-639-1.txt"), Charsets.UTF_8));
            do {
                if ((line = r.readLine()) == null) continue;
                Iterator cols = TAB_SPLITTER.split((CharSequence)line).iterator();
                String iso = ((String)cols.next()).toLowerCase();
                Language lang = Language.fromIsoCode((String)iso);
                if (lang == null) {
                    this.log.warn("ISO code {} not part of our language enumeration", (Object)iso);
                    continue;
                }
                cols.next();
                cols.next();
                cols.next();
                for (String s : SEMICOLON_SPLITTER.split((CharSequence)cols.next())) {
                    this.add(s, lang);
                }
            } while (line != null);
        }
        catch (IOException e) {
            this.log.error("Cannot initiate language parser: {}", (Object)e.getMessage());
            throw new IllegalStateException("Cannot initiate language parser", e);
        }
        for (Language r : Language.values()) {
            this.add(r.name(), r);
            this.add(r.getTitleEnglish(), r);
            this.add(r.getTitleNative(), r);
            this.add(r.getIso2LetterCode(), r);
            this.add(r.getIso3LetterCode(), r);
        }
    }

    @Override
    protected String normalize(String value) {
        if (value != null) {
            if (value.contains("_")) {
                int index = value.indexOf("_");
                return super.normalize(value.substring(0, index));
            }
            return super.normalize(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageParser getInstance() {
        Class<LanguageParser> clazz = LanguageParser.class;
        synchronized (LanguageParser.class) {
            if (singletonObject == null) {
                singletonObject = new LanguageParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }
}

