/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.record;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.RecordImpl;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.text.ArchiveField;
import org.gbif.dwc.text.ArchiveFile;
import org.gbif.file.CSVReader;
import org.gbif.utils.file.ClosableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordIterator
implements ClosableIterator<Record> {
    private static final Logger LOG = LoggerFactory.getLogger(RecordIterator.class);
    private ClosableIterator<String[]> closable;
    private final PeekingIterator<String[]> iter;
    private int lineCount = 0;
    private final ArchiveField id;
    private final Map<Term, ArchiveField> fields;
    private final Term rowType;
    private final boolean replaceEntities;
    private final boolean replaceNulls;

    public RecordIterator(ClosableIterator<String[]> recordSource, ArchiveField id, Map<Term, ArchiveField> fields, Term rowType, boolean replaceNulls, boolean replaceEntities) {
        this.id = id;
        this.fields = fields;
        this.rowType = rowType;
        this.replaceNulls = replaceNulls;
        this.replaceEntities = replaceEntities;
        this.closable = recordSource;
        if (this.closable == null) {
            UnmodifiableIterator empty = Iterators.emptyIterator();
            this.iter = Iterators.peekingIterator((Iterator)empty);
        } else {
            this.iter = Iterators.peekingIterator(this.closable);
        }
    }

    public static RecordIterator build(ArchiveFile source, boolean replaceNulls, boolean replaceEntities) {
        try {
            CSVReader csvr = CSVReader.build(source);
            return new RecordIterator((ClosableIterator<String[]>)csvr, source.getId(), source.getFields(), source.getRowType(), replaceNulls, replaceEntities);
        }
        catch (IOException e) {
            LOG.error("Can't open archive file " + source + " for building a record iterator", (Throwable)e);
            return null;
        }
    }

    public void close() {
        this.closable.close();
    }

    public boolean hasNext() {
        return this.iter.hasNext() && this.iter.peek() != null;
    }

    public Record next() {
        ++this.lineCount;
        RecordImpl record = null;
        try {
            record = new RecordImpl(this.id, this.fields, this.rowType, this.replaceNulls, this.replaceEntities);
            String[] row = (String[])this.iter.next();
            while (row.length == 0) {
                row = (String[])this.iter.next();
            }
            record.setRow(row);
        }
        catch (Exception e) {
            LOG.warn("Bad row somewhere around line: {}", (Object)this.lineCount, (Object)e);
        }
        return record;
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove a row from an archive file");
    }
}

