/*
 * Decompiled with CFR 0.152.
 */
package org.rev6.scf;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rev6.scf.ScpFile;
import org.rev6.scf.SshException;
import org.rev6.scf.SshTask;

public class ScpUpload
extends SshTask {
    private ScpFile scpFile;
    private static final String SCP_UPLOAD_COMMAND = "scp -p -t ";

    public ScpUpload() {
    }

    public ScpUpload(ScpFile scpFile) {
        this.scpFile = scpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(Session sshSession) throws SshException {
        if (this.scpFile == null) {
            throw new SshException("scpFile property has not been set and is null", new NullPointerException());
        }
        InputStream in = null;
        OutputStream out = null;
        InputStream fis = null;
        ChannelExec channel = null;
        try {
            try {
                String cmd = SCP_UPLOAD_COMMAND + this.scpFile.getRemoteDirectory();
                channel = this.setUpChannel(sshSession, cmd);
                fis = new FileInputStream(this.scpFile.getLocalFile());
                in = channel.getInputStream();
                out = channel.getOutputStream();
                channel.connect();
                if (this.checkAck(in) != 0) {
                    throw new SshException("Acknowledgement check failed: Initializing session returned a status code other than 0");
                }
                this.sendFileSizeAndRemotePath(this.scpFile, out);
                if (this.checkAck(in) != 0) {
                    throw new SshException("Scp upload failed. Reason: sending filesize and filename returned a status code other than 0.");
                }
                this.sendPayloadToServer(out, fis);
                this.sendEOFToServer(out);
                if (this.checkAck(in) != 0) {
                    throw new SshException("Scp upload failed.  Reason: sending the   file payload resulted a status code other than 0");
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    private void sendEOFToServer(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    private void sendFileSizeAndRemotePath(ScpFile scpfile, OutputStream out) throws IOException {
        String command = "C0644 " + Long.toString(scpfile.getFileSize()) + " " + scpfile.getRemoteFilename() + "\n";
        out.write(command.getBytes());
        out.flush();
    }

    private void sendPayloadToServer(OutputStream out, InputStream fis) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = fis.read(buf, 0, buf.length)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public void setScpFile(ScpFile scpFile) {
        if (scpFile == null) {
            throw new IllegalArgumentException("scpFile can't be null");
        }
        this.scpFile = scpFile;
    }

    public String toString() {
        if (this.scpFile != null) {
            return this.getClass().getName() + " Task: " + this.scpFile.getLocalFile().getAbsolutePath() + " to " + this.scpFile.getRemoteDirectory() + this.scpFile.getRemoteFilename() + " at a remote host.";
        }
        return this.getClass().getName() + " Task: scpFile property is null.";
    }
}

