/*
 * Decompiled with CFR 0.152.
 */
package org.rev6.scf;

import java.io.File;

public class ScpFile {
    private final File localFile;
    private final String remoteDirectory;
    private final String remoteFilename;

    public ScpFile(File localFile, String remotePath) {
        if (localFile == null || remotePath == null) {
            throw new IllegalArgumentException("File reference and path must be non-null");
        }
        this.localFile = localFile;
        if (remotePath.contains("/")) {
            int lastSlashIndex = remotePath.lastIndexOf("/");
            this.remoteDirectory = remotePath.substring(0, lastSlashIndex + 1);
            String filename = remotePath.substring(lastSlashIndex + 1);
            this.remoteFilename = "".equals(filename.trim()) ? localFile.getName() : filename;
        } else {
            this.remoteDirectory = remotePath;
            this.remoteFilename = remotePath;
        }
    }

    public ScpFile(File file) {
        this(file, file.getName());
    }

    File getLocalFile() {
        return this.localFile;
    }

    String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    String getRemoteFilename() {
        return this.remoteFilename;
    }

    String getRemoteFullPath() {
        if (this.remoteDirectory.equals(this.remoteFilename)) {
            return this.remoteFilename;
        }
        return this.remoteDirectory + this.remoteFilename;
    }

    long getFileSize() {
        return this.localFile.length();
    }
}

