/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common.search;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PagingResponse;
import org.gbif.api.model.common.search.Facet;
import org.gbif.api.model.common.search.SearchParameter;

public class SearchResponse<T, P extends SearchParameter>
extends PagingResponse<T> {
    private final List<Facet<P>> facets = Lists.newArrayList();

    public SearchResponse() {
    }

    public SearchResponse(Pageable page) {
        super(page);
    }

    public SearchResponse(PagingResponse<T> response) {
        super(response, response.getCount(), response.getResults());
    }

    public SearchResponse(long offset, int limit) {
        super(offset, limit);
    }

    public SearchResponse(long offset, int pageSize, Long count, List<T> results, List<Facet<P>> facets) {
        super(offset, pageSize, count, results);
        this.setFacets(facets);
    }

    public List<Facet<P>> getFacets() {
        return this.facets;
    }

    public final void setFacets(List<Facet<P>> facets) {
        this.facets.clear();
        if (facets != null) {
            this.facets.addAll(facets);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchResponse)) {
            return false;
        }
        SearchResponse that = (SearchResponse)o;
        return Objects.equal((Object)this.getCount(), (Object)that.getCount()) && Objects.equal(this.getResults(), that.getResults()) && Objects.equal(this.facets, that.getFacets()) && Objects.equal((Object)this.getOffset(), (Object)that.getOffset()) && Objects.equal((Object)this.getLimit(), (Object)that.getLimit());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.facets});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("count", (Object)this.getCount()).add("results", this.getResults()).add("facets", this.facets).add("offset", this.getOffset()).add("limit", this.getLimit()).toString();
    }
}

