/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common.search;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.search.SearchParameter;
import org.gbif.api.model.common.search.SearchRequest;

public class FacetedSearchRequest<P extends SearchParameter>
extends SearchRequest<P> {
    private Set<P> facets = Sets.newHashSet();
    private boolean multiSelectFacets;
    private Integer facetMinCount;

    public FacetedSearchRequest() {
    }

    public FacetedSearchRequest(Pageable page) {
        super(page);
    }

    public FacetedSearchRequest(SearchRequest<P> searchRequest) {
        super(searchRequest);
        this.setHighlight(searchRequest.isHighlight());
        this.setParameters(searchRequest.getParameters());
        this.setQ(searchRequest.getQ());
    }

    public FacetedSearchRequest(long offset, int limit) {
        super(offset, limit);
    }

    public Integer getFacetMinCount() {
        return this.facetMinCount;
    }

    public void setFacetMinCount(Integer facetMinCount) {
        this.facetMinCount = facetMinCount;
    }

    public Set<P> getFacets() {
        return this.facets;
    }

    public void setFacets(Set<P> facets) {
        this.facets = facets;
    }

    public boolean isMultiSelectFacets() {
        return this.multiSelectFacets;
    }

    public void setMultiSelectFacets(boolean multiSelectFacets) {
        this.multiSelectFacets = multiSelectFacets;
    }

    public void addFacets(P ... facets) {
        if (this.facets == null) {
            this.facets = Sets.newHashSet((Object[])facets);
        } else {
            this.facets.addAll(Sets.newHashSet((Object[])facets));
        }
    }
}

