/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common.paging;

import org.gbif.api.model.common.paging.Pageable;

public class PageableBase
implements Pageable {
    protected long offset;
    protected int limit;

    protected PageableBase() {
        this.offset = 0L;
        this.limit = 20;
    }

    protected PageableBase(Pageable page) {
        this.setOffset(page.getOffset());
        this.setLimit(page.getLimit());
    }

    protected PageableBase(long offset, int limit) {
        this.setOffset(offset);
        this.setLimit(limit);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit cannot be negative");
        }
        this.limit = limit;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset cannot be negative");
        }
        this.offset = offset;
    }

    public void addOffset(long offsetDiff) {
        this.offset += offsetDiff;
        if (this.offset < 0L) {
            this.offset = 0L;
        }
    }

    public void copyPagingValues(Pageable pageable) {
        this.limit = pageable.getLimit();
        this.offset = pageable.getOffset();
    }
}

