/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata.parse.converter;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.gbif.api.util.VocabularyUtils;

public class EnumTypeConverter<T extends Enum<?>>
extends AbstractConverter {
    private final Class<T> clazz;
    private final T defaultValue;
    private final Map<String, T> lookup = Maps.newHashMap();

    public EnumTypeConverter(Class<T> clazz, T defaultValue) {
        this.clazz = clazz;
        this.defaultValue = defaultValue;
    }

    public void addMappings(Map<String, T> mapping) {
        for (Map.Entry<String, T> entry : mapping.entrySet()) {
            this.lookup.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    protected Class getDefaultType() {
        return this.clazz;
    }

    protected Object convertToType(Class type, Object value) throws Throwable {
        String val = value.toString();
        if (this.lookup.containsKey(val)) {
            return this.lookup.get(val);
        }
        try {
            Enum eVal = VocabularyUtils.lookupEnum((String)val, this.clazz);
            return eVal == null ? this.defaultValue : eVal;
        }
        catch (IllegalArgumentException e) {
            return this.defaultValue;
        }
    }
}

