/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata.parse;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.gbif.api.model.common.DOI;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.model.registry.eml.Collection;
import org.gbif.api.model.registry.eml.DataDescription;
import org.gbif.api.model.registry.eml.KeywordCollection;
import org.gbif.api.model.registry.eml.Project;
import org.gbif.api.model.registry.eml.SamplingDescription;
import org.gbif.api.model.registry.eml.TaxonomicCoverage;
import org.gbif.api.model.registry.eml.TaxonomicCoverages;
import org.gbif.api.model.registry.eml.curatorial.CuratorialUnitComposite;
import org.gbif.api.model.registry.eml.geospatial.GeospatialCoverage;
import org.gbif.api.model.registry.eml.temporal.TemporalCoverage;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.DatasetSubtype;
import org.gbif.api.vocabulary.DatasetType;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.api.vocabulary.Language;
import org.gbif.api.vocabulary.PreservationMethodType;
import org.gbif.api.vocabulary.Rank;
import org.gbif.common.parsers.RankParser;
import org.gbif.common.parsers.core.ParseResult;
import org.gbif.registry.metadata.CleanUtils;
import org.gbif.registry.metadata.parse.ParagraphContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(DatasetWrapper.class);
    private final Dataset target = new Dataset();
    private ParagraphContainer description = new ParagraphContainer();

    private static Date calendarDate(String dateString) throws ParseException {
        Date date;
        if (Strings.isNullOrEmpty((String)dateString)) {
            return null;
        }
        dateString = dateString.replaceAll("\\s", "");
        dateString = dateString.replaceAll("[\\,._#//]", "-");
        try {
            SimpleDateFormat iso = new SimpleDateFormat("yyyy-MM-dd");
            date = iso.parse(dateString);
        }
        catch (ParseException e) {
            if (dateString.length() == 4) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                date = sdf.parse(dateString);
                date = new Date(date.getTime() + 1L);
            }
            throw e;
        }
        return date;
    }

    public void addBibliographicCitation(Citation citation) {
        this.target.getBibliographicCitations().add(citation);
    }

    public void addCollection(Collection collection) {
        this.target.getCollections().add(collection);
    }

    public void addContact(Contact contact) {
        CleanUtils.removeEmptyStrings(contact);
        if (this.verifyContact(contact)) {
            this.target.getContacts().add(contact);
        }
    }

    private boolean verifyContact(Contact contact) {
        return contact.getFirstName() != null || contact.getLastName() != null || !contact.getPosition().isEmpty() || !contact.getEmail().isEmpty() || !contact.getPhone().isEmpty() || contact.getOrganization() != null || !contact.getAddress().isEmpty() && contact.getCity() != null;
    }

    public void addCuratorial(CuratorialUnitComposite curatorialUnit) {
        if (this.target.getCollections().isEmpty()) {
            this.target.getCollections().add(new Collection());
        }
        ((Collection)this.target.getCollections().get(0)).addCuratorialUnitComposite(curatorialUnit);
    }

    public void addDataDescription(DataDescription dataDescription) {
        this.target.getDataDescriptions().add(dataDescription);
    }

    public void addGeographicCoverage(GeospatialCoverage coverage) {
        this.target.getGeographicCoverages().add(coverage);
    }

    public void addIdentifier(Identifier identifier) {
        this.target.getIdentifiers().add(identifier);
    }

    public void addKeywordCollection(KeywordCollection collection) {
        this.target.getKeywordCollections().add(collection);
    }

    public void addSubjects(String subjects) {
        Splitter keywordSplitter = Splitter.on((Pattern)Pattern.compile("[,;]")).trimResults().omitEmptyStrings();
        if (!Strings.isNullOrEmpty((String)subjects)) {
            KeywordCollection collection = new KeywordCollection();
            for (String keyword : keywordSplitter.split((CharSequence)subjects)) {
                collection.addKeyword(keyword);
            }
            this.target.getKeywordCollections().add(collection);
        }
    }

    public void addCreator(String creator) {
        if (!Strings.isNullOrEmpty((String)creator)) {
            Contact contact = new Contact();
            contact.setLastName(creator);
            contact.setType(ContactType.ORIGINATOR);
            this.addContact(contact);
        }
    }

    public void addBibCitation(String citation) {
        if (!Strings.isNullOrEmpty((String)citation)) {
            Citation c = new Citation();
            c.setText(citation);
            this.target.setCitation(c);
        }
    }

    public void addIdentifier(String id) {
        if (!Strings.isNullOrEmpty((String)id)) {
            Identifier i = new Identifier();
            i.setIdentifier(id);
            i.setType(IdentifierType.UNKNOWN);
            this.target.getIdentifiers().add(i);
        }
    }

    public void addDescription(ParagraphContainer para) {
        if (para != null) {
            this.target.setDescription(para.toString());
        }
    }

    public void addAbstract(String para) {
        if (!Strings.isNullOrEmpty((String)para)) {
            this.description.appendParagraph(para.trim());
            this.target.setDescription(this.description.toString());
        }
    }

    public void addLicense(String license) {
        if (!Strings.isNullOrEmpty((String)license)) {
            if (Strings.isNullOrEmpty((String)this.target.getRights())) {
                this.target.setRights(license);
            } else {
                this.target.setRights(this.target.getRights() + " \n" + license);
            }
        }
    }

    public void addDataUrl(URI uri) {
        if (uri != null) {
            DataDescription d = new DataDescription();
            d.setUrl(uri);
            this.target.getDataDescriptions().add(d);
        }
    }

    public void addPreferredAdministrativeContact(Contact contact) {
        contact.setPrimary(true);
        contact.setType(ContactType.ADMINISTRATIVE_POINT_OF_CONTACT);
        this.addContact(contact);
    }

    public void addPreferredMetadataContact(Contact contact) {
        contact.setPrimary(true);
        contact.setType(ContactType.METADATA_AUTHOR);
        this.addContact(contact);
    }

    public void addPreferredOriginatorContact(Contact contact) {
        contact.setPrimary(true);
        contact.setType(ContactType.ORIGINATOR);
        this.addContact(contact);
    }

    public void addTaxonomicCoverages(TaxonomicCoverages taxonomicCoverages) {
        this.target.getTaxonomicCoverages().add(taxonomicCoverages);
    }

    public void addTemporalCoverage(TemporalCoverage coverage) {
        this.target.getTemporalCoverages().add(coverage);
    }

    public Dataset getTarget() {
        return this.target;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.target.setAdditionalInfo(additionalInfo);
    }

    public void setBibliographicCitations(List<Citation> bibliographicCitations) {
        this.target.setBibliographicCitations(bibliographicCitations);
    }

    public void setCitation(Citation citation) {
        CleanUtils.removeEmptyStrings(citation);
        this.target.setCitation(citation);
    }

    public void setContacts(List<Contact> contacts) {
        this.target.setContacts(contacts);
    }

    public void setCuratorialUnits(List<CuratorialUnitComposite> curatorialUnits) {
        this.target.setCuratorialUnits(curatorialUnits);
    }

    public void setDataLanguage(Language language) {
        this.target.setDataLanguage(language);
    }

    public void setLanguage(Language language) {
        this.target.setLanguage(language);
    }

    public void setDescription(String description) {
        this.target.setDescription(description);
    }

    public void setGeographicCoverageDescription(String geographicCoverageDescription) {
        this.target.setGeographicCoverageDescription(geographicCoverageDescription);
    }

    public void setGeographicCoverages(List<GeospatialCoverage> geographicCoverages) {
        this.target.setGeographicCoverages(geographicCoverages);
    }

    public void setHomepage(URI homepage) throws URISyntaxException {
        this.target.setHomepage(homepage);
    }

    public void setIdentifiers(List<Identifier> identifiers) {
        this.target.setIdentifiers(identifiers);
    }

    public void setRights(String rights) {
        this.target.setRights(rights);
    }

    public void setCountryCoverage(Set<Country> countryCoverage) {
        this.target.setCountryCoverage(countryCoverage);
    }

    public void setKey(UUID key) {
        this.target.setKey(key);
    }

    public void setKeywordCollections(List<KeywordCollection> keywordCollections) {
        this.target.setKeywordCollections(keywordCollections);
    }

    public void setLogoURL(URI logoURL) {
        this.target.setLogoUrl(logoURL);
    }

    public void setPublishingOrganizationKey(UUID publishingOrganizationKey) {
        this.target.setPublishingOrganizationKey(publishingOrganizationKey);
    }

    public void setProject(Project project) {
        this.target.setProject(project);
    }

    private String appendParagraph(String existing, String para) {
        if (!para.isEmpty()) {
            return existing + "<br/>" + para.trim();
        }
        return existing;
    }

    public void appendMethodStepParagraph(String paragraph) {
        int lastIdx = this.target.getSamplingDescription().getMethodSteps().size() - 1;
        this.target.getSamplingDescription().getMethodSteps().set(lastIdx, this.appendParagraph((String)this.target.getSamplingDescription().getMethodSteps().get(lastIdx), paragraph));
    }

    public void addMethodStep(ParagraphContainer para) {
        if (para != null) {
            this.target.getSamplingDescription().getMethodSteps().add(para.toString());
        }
    }

    public void setPubDateAsString(String pubDateAsString) {
        try {
            this.target.setPubDate(DatasetWrapper.calendarDate(pubDateAsString));
        }
        catch (ParseException e) {
            LOG.error("The publication date was invalid: {}. Expected format is YYYY-MM-DD", (Object)pubDateAsString);
        }
    }

    public void setPurpose(String purpose) {
        this.target.setPurpose(purpose);
    }

    public void setSamplingDescription(SamplingDescription samplingDescription) {
        this.target.setSamplingDescription(samplingDescription);
    }

    public void setSpecimenPreservationMethod(PreservationMethodType type) {
        if (this.target.getCollections() != null) {
            if (this.target.getCollections().isEmpty()) {
                this.target.getCollections().add(new Collection());
            }
            ((Collection)this.target.getCollections().get(0)).setSpecimenPreservationMethod(type);
        }
    }

    public void setPackageId(String id) {
        if (DOI.isParsable((String)id)) {
            this.target.setDoi(new DOI(id));
        }
    }

    public void setSubtype(DatasetSubtype subtype) {
        this.target.setSubtype(subtype);
    }

    public void setTaxonomicCoverages(List<TaxonomicCoverages> taxonomicCoverages) {
        this.target.setTaxonomicCoverages(taxonomicCoverages);
    }

    public void setTechnicalInstallationKey(UUID technicalInstallationKey) {
        this.target.setInstallationKey(technicalInstallationKey);
    }

    public void setTemporalCoverages(List<TemporalCoverage> temporalCoverages) {
        this.target.setTemporalCoverages(temporalCoverages);
    }

    public void setTitle(String title) {
        this.target.setTitle((String)Objects.firstNonNull((Object)this.target.getTitle(), (Object)title));
    }

    public void setType(DatasetType type) {
        this.target.setType(type);
    }

    public void postProcess() {
        this.updateTaxonomicCoverageRanks();
        this.updatePrimaryDOI();
    }

    private void updateTaxonomicCoverageRanks() {
        for (TaxonomicCoverages tc : this.target.getTaxonomicCoverages()) {
            for (TaxonomicCoverage t : tc.getCoverages()) {
                if (t.getRank() == null) continue;
                t.getRank().setInterpreted((Object)this.toRank((String)t.getRank().getVerbatim()));
            }
        }
    }

    private void updatePrimaryDOI() {
        if (this.target.getDoi() == null) {
            Iterator iter = this.target.getIdentifiers().iterator();
            while (iter.hasNext()) {
                Identifier i = (Identifier)iter.next();
                if (i.getType() != IdentifierType.DOI || !DOI.isParsable((String)i.getIdentifier())) continue;
                this.target.setDoi(new DOI(i.getIdentifier()));
                iter.remove();
                return;
            }
            if (!Strings.isNullOrEmpty((String)this.target.getCitation().getIdentifier())) {
                try {
                    this.target.setDoi(new DOI(this.target.getCitation().getIdentifier()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private Rank toRank(String rank) {
        ParseResult result = RankParser.getInstance().parse(rank);
        return result.getStatus() == ParseResult.STATUS.SUCCESS ? (Rank)result.getPayload() : null;
    }
}

