/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.registry.metadata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.eml.temporal.TemporalCoverage;
import org.gbif.api.model.registry.eml.temporal.VerbatimTimePeriod;
import org.gbif.api.model.registry.eml.temporal.VerbatimTimePeriodType;
import org.gbif.api.vocabulary.ContactType;

public class EMLWriter {
    private static final String TEMPLATE_PATH = "/gbif-eml-profile-template";
    private static final String EML_TEMPLATE = "eml-dataset.ftl";
    private static final Configuration FTL = EMLWriter.provideFreemarker();

    private EMLWriter() {
    }

    private static Configuration provideFreemarker() {
        ClassTemplateLoader tl = new ClassTemplateLoader(EMLWriter.class, TEMPLATE_PATH);
        Configuration fm = new Configuration();
        fm.setDefaultEncoding("utf8");
        fm.setTemplateLoader((TemplateLoader)tl);
        return fm;
    }

    public static void write(Dataset dataset, Writer writer) throws IOException {
        EMLWriter.write(dataset, writer, false);
    }

    public static void write(Dataset dataset, Writer writer, boolean useDoiAsIdentifier) throws IOException {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset can't be null");
        }
        HashMap map = Maps.newHashMap();
        map.put("dataset", dataset);
        map.put("eml", new EmlDatasetWrapper(dataset));
        map.put("useDoiAsIdentifier", useDoiAsIdentifier);
        try {
            FTL.getTemplate(EML_TEMPLATE).process((Object)map, writer);
        }
        catch (TemplateException e) {
            throw new IOException("Error while processing the EML freemarker template for dataset " + dataset.getKey(), e);
        }
    }

    public static class EmlDatasetWrapper {
        private final Dataset dataset;

        public EmlDatasetWrapper(Dataset dataset) {
            this.dataset = dataset;
        }

        public List<Contact> getAssociatedParties() {
            ArrayList contacts = Lists.newArrayList();
            for (Contact c : this.dataset.getContacts()) {
                if (c.isPrimary()) continue;
                contacts.add(c);
            }
            return contacts;
        }

        public Contact getResourceCreator() {
            return this.getFirstPreferredType(ContactType.ORIGINATOR);
        }

        public Contact getAdministrativeContact() {
            return this.getFirstPreferredType(ContactType.ADMINISTRATIVE_POINT_OF_CONTACT);
        }

        public Contact getMetadataProvider() {
            return this.getFirstPreferredType(ContactType.METADATA_AUTHOR);
        }

        private Contact getFirstPreferredType(ContactType type) {
            Contact pref = null;
            for (Contact c : this.dataset.getContacts()) {
                if (type != c.getType() || pref != null && !c.isPrimary()) continue;
                pref = c;
            }
            return pref;
        }

        public List getFormationPeriods() {
            return this.getTimePeriods(VerbatimTimePeriodType.FORMATION_PERIOD);
        }

        public List getLivingTimePeriods() {
            return this.getTimePeriods(VerbatimTimePeriodType.LIVING_TIME_PERIOD);
        }

        private List<VerbatimTimePeriod> getTimePeriods(VerbatimTimePeriodType type) {
            ArrayList periods = Lists.newArrayList();
            for (TemporalCoverage tc : this.dataset.getTemporalCoverages()) {
                VerbatimTimePeriod tp;
                if (!(tc instanceof VerbatimTimePeriod) || !type.equals((Object)(tp = (VerbatimTimePeriod)tc).getType())) continue;
                periods.add(tp);
            }
            return periods;
        }
    }
}

