/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiffFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    protected FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    protected Diff diff;
    SimpleFeature next;
    SimpleFeature live;
    SimpleFeature current;

    public DiffFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> reader, Diff diff) {
        this(reader, diff, (Filter)Filter.INCLUDE);
    }

    public DiffFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> reader, Diff diff, Filter filter) {
        this.reader = new DiffFeatureReader<SimpleFeatureType, SimpleFeature>(reader, diff, filter);
        this.diff = diff;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.reader.getFeatureType();
    }

    @Override
    public SimpleFeature next() throws IOException {
        SimpleFeatureType type = this.getFeatureType();
        if (this.hasNext()) {
            try {
                this.live = this.next;
                this.next = null;
                this.current = SimpleFeatureBuilder.copy(this.live);
                return this.current;
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Could not modify content").initCause((Throwable)((Object)e));
            }
        }
        try {
            this.live = null;
            this.next = null;
            this.current = SimpleFeatureBuilder.build(type, new Object[type.getAttributeCount()], "new" + this.diff.nextFID);
            ++this.diff.nextFID;
            return this.current;
        }
        catch (IllegalAttributeException e) {
            throw new IOException("Could not create new content");
        }
    }

    @Override
    public void remove() throws IOException {
        if (this.live != null) {
            this.diff.remove(this.live.getID());
            this.fireNotification(-1, ReferencedEnvelope.reference(this.live.getBounds()));
            this.live = null;
            this.current = null;
        } else if (this.current != null) {
            this.current = null;
        }
    }

    @Override
    public void write() throws IOException {
        if (this.live != null) {
            this.diff.modify(this.live.getID(), this.current);
            ReferencedEnvelope bounds = new ReferencedEnvelope((CoordinateReferenceSystem)null);
            bounds.include(this.live.getBounds());
            bounds.include(this.current.getBounds());
            this.fireNotification(0, bounds);
            this.live = null;
            this.current = null;
        } else if (this.live == null && this.current != null) {
            this.diff.add(this.current.getID(), this.current);
            this.fireNotification(1, ReferencedEnvelope.reference(this.current.getBounds()));
            this.current = null;
        } else {
            throw new IOException("No feature available to write");
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.live = null;
        this.current = null;
        if (this.reader.hasNext()) {
            try {
                this.next = this.reader.next();
            }
            catch (NoSuchElementException e) {
                throw new DataSourceException("No more content", e);
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("No more content", (Throwable)((Object)e));
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.current = null;
        this.live = null;
        this.next = null;
        this.diff = null;
    }

    protected abstract void fireNotification(int var1, ReferencedEnvelope var2);
}

