/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.util.ClassUtils;
import org.kie.internal.utils.ClassLoaderUtil;

public class ProjectClassLoader
extends ClassLoader {
    private static final boolean CACHE_NON_EXISTING_CLASSES = true;
    private static final ClassNotFoundException dummyCFNE = new ClassNotFoundException("This is just a cached Exception. Disable non existing classes cache to see the actual one.");
    private Map<String, byte[]> store;
    private Map<String, ClassBytecode> definedTypes;
    private final Set<String> nonExistingClasses = new HashSet<String>();
    private ClassLoader droolsClassLoader;
    private InternalTypesClassLoader typesClassLoader;

    private ProjectClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static ClassLoader getClassLoader(ClassLoader[] classLoaders, Class<?> cls, boolean enableCache) {
        if (classLoaders == null || classLoaders.length == 0) {
            return cls == null ? ProjectClassLoader.createProjectClassLoader() : ProjectClassLoader.createProjectClassLoader(cls.getClassLoader());
        }
        if (classLoaders.length == 1) {
            ProjectClassLoader classLoader = ProjectClassLoader.createProjectClassLoader(classLoaders[0]);
            if (cls != null) {
                classLoader.setDroolsClassLoader(cls.getClassLoader());
            }
            return classLoader;
        }
        return ClassLoaderUtil.getClassLoader((ClassLoader[])classLoaders, cls, (boolean)enableCache);
    }

    public static ProjectClassLoader createProjectClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (parent == null) {
            parent = ProjectClassLoader.class.getClassLoader();
        }
        return new ProjectClassLoader(parent);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent) {
        if (parent == null) {
            return ProjectClassLoader.createProjectClassLoader();
        }
        return parent instanceof ProjectClassLoader ? (ProjectClassLoader)parent : new ProjectClassLoader(parent);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, Map<String, byte[]> store) {
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader(parent);
        projectClassLoader.store = store;
        return projectClassLoader;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.internalLoadClass(name, resolve);
        }
        catch (ClassNotFoundException e2) {
            return this.loadType(name, resolve);
        }
    }

    private Class<?> internalLoadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.nonExistingClasses.contains(name)) {
            throw dummyCFNE;
        }
        if (this.droolsClassLoader != null) {
            try {
                return Class.forName(name, resolve, this.droolsClassLoader);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(name, resolve, this.getParent());
        }
    }

    private Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
        ClassNotFoundException cnfe = null;
        if (this.typesClassLoader != null) {
            try {
                return this.typesClassLoader.loadType(name, resolve);
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        return this.tryDefineType(name, cnfe);
    }

    private Class<?> tryDefineType(String name, ClassNotFoundException cnfe) throws ClassNotFoundException {
        byte[] bytecode = this.getBytecode(ClassUtils.convertClassToResourcePath(name));
        if (bytecode == null) {
            this.nonExistingClasses.add(name);
            throw cnfe != null ? cnfe : new ClassNotFoundException(name);
        }
        return this.defineType(name, bytecode);
    }

    private Class<?> defineType(String name, byte[] bytecode) {
        if (this.definedTypes == null) {
            this.definedTypes = new HashMap<String, ClassBytecode>();
        } else {
            ClassBytecode existingClass = this.definedTypes.get(name);
            if (existingClass != null && Arrays.equals(bytecode, existingClass.bytes)) {
                return existingClass.clazz;
            }
        }
        if (this.typesClassLoader == null) {
            this.typesClassLoader = new InternalTypesClassLoader(this);
        }
        Class<?> clazz = this.typesClassLoader.defineClass(name, bytecode);
        this.definedTypes.put(name, new ClassBytecode(clazz, bytecode));
        return clazz;
    }

    public Class<?> defineClass(String name, byte[] bytecode) {
        return this.defineClass(name, ClassUtils.convertClassToResourcePath(name), bytecode);
    }

    public Class<?> defineClass(String name, String resourceName, byte[] bytecode) {
        this.storeClass(name, resourceName, bytecode);
        return this.defineType(name, bytecode);
    }

    public void storeClass(String name, String resourceName, byte[] bytecode) {
        if (this.store == null) {
            this.store = new HashMap<String, byte[]>();
        }
        this.store.put(resourceName, bytecode);
        this.nonExistingClasses.remove(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getParent().getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytecode = this.getBytecode(name);
        return bytecode != null ? new ByteArrayInputStream(bytecode) : super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        URL resource;
        if (this.droolsClassLoader != null && (resource = this.droolsClassLoader.getResource(name)) != null) {
            return resource;
        }
        return super.getResource(name);
    }

    public byte[] getBytecode(String resourceName) {
        return this.store == null ? null : this.store.get(resourceName);
    }

    public Map<String, byte[]> getStore() {
        return this.store;
    }

    public void setDroolsClassLoader(ClassLoader droolsClassLoader) {
        if (this.getParent() != droolsClassLoader) {
            this.droolsClassLoader = droolsClassLoader;
            this.nonExistingClasses.clear();
        }
    }

    public void initFrom(ProjectClassLoader other) {
        if (other.store != null) {
            if (this.store == null) {
                this.store = new HashMap<String, byte[]>();
            }
            this.store.putAll(other.store);
        }
        this.nonExistingClasses.addAll(other.nonExistingClasses);
    }

    public synchronized void reinitTypes() {
        this.typesClassLoader = null;
        this.nonExistingClasses.clear();
    }

    private static class ClassBytecode {
        private final Class<?> clazz;
        private final byte[] bytes;

        private ClassBytecode(Class<?> clazz, byte[] bytes) {
            this.clazz = clazz;
            this.bytes = bytes;
        }
    }

    private static class InternalTypesClassLoader
    extends ClassLoader {
        private final ProjectClassLoader projectClassLoader;

        private InternalTypesClassLoader(ProjectClassLoader projectClassLoader) {
            this.projectClassLoader = projectClassLoader;
        }

        public Class<?> defineClass(String name, byte[] bytecode) {
            String pkgName;
            int lastDot = name.lastIndexOf(46);
            if (lastDot > 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, "", "", "", "", "", "", null);
            }
            return this.defineClass(name, bytecode, 0, bytecode.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return this.loadType(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                ProjectClassLoader projectClassLoader = this.projectClassLoader;
                synchronized (projectClassLoader) {
                    try {
                        return this.projectClassLoader.internalLoadClass(name, resolve);
                    }
                    catch (ClassNotFoundException cnfe2) {
                        return this.projectClassLoader.tryDefineType(name, cnfe);
                    }
                }
            }
        }

        private Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

