/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;

public class JpegDescriptor
extends TagDescriptor<JpegDirectory> {
    public JpegDescriptor(@NotNull JpegDirectory jpegDirectory) {
        super(jpegDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case -3: {
                return this.getImageCompressionTypeDescription();
            }
            case 6: {
                return this.getComponentDataDescription(0);
            }
            case 7: {
                return this.getComponentDataDescription(1);
            }
            case 8: {
                return this.getComponentDataDescription(2);
            }
            case 9: {
                return this.getComponentDataDescription(3);
            }
            case 0: {
                return this.getDataPrecisionDescription();
            }
            case 1: {
                return this.getImageHeightDescription();
            }
            case 3: {
                return this.getImageWidthDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getImageCompressionTypeDescription() {
        Integer n = ((JpegDirectory)this._directory).getInteger(-3);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Baseline";
            }
            case 1: {
                return "Extended sequential, Huffman";
            }
            case 2: {
                return "Progressive, Huffman";
            }
            case 3: {
                return "Lossless, Huffman";
            }
            case 5: {
                return "Differential sequential, Huffman";
            }
            case 6: {
                return "Differential progressive, Huffman";
            }
            case 7: {
                return "Differential lossless, Huffman";
            }
            case 8: {
                return "Reserved for JPEG extensions";
            }
            case 9: {
                return "Extended sequential, arithmetic";
            }
            case 10: {
                return "Progressive, arithmetic";
            }
            case 11: {
                return "Lossless, arithmetic";
            }
            case 13: {
                return "Differential sequential, arithmetic";
            }
            case 14: {
                return "Differential progressive, arithmetic";
            }
            case 15: {
                return "Differential lossless, arithmetic";
            }
        }
        return "Unknown type: " + n;
    }

    @Nullable
    public String getImageWidthDescription() {
        String string = ((JpegDirectory)this._directory).getString(3);
        if (string == null) {
            return null;
        }
        return string + " pixels";
    }

    @Nullable
    public String getImageHeightDescription() {
        String string = ((JpegDirectory)this._directory).getString(1);
        if (string == null) {
            return null;
        }
        return string + " pixels";
    }

    @Nullable
    public String getDataPrecisionDescription() {
        String string = ((JpegDirectory)this._directory).getString(0);
        if (string == null) {
            return null;
        }
        return string + " bits";
    }

    @Nullable
    public String getComponentDataDescription(int n) {
        JpegComponent jpegComponent = ((JpegDirectory)this._directory).getComponent(n);
        if (jpegComponent == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(jpegComponent.getComponentName());
        stringBuilder.append(" component: Quantization table ");
        stringBuilder.append(jpegComponent.getQuantizationTableNumber());
        stringBuilder.append(", Sampling factors ");
        stringBuilder.append(jpegComponent.getHorizontalSamplingFactor());
        stringBuilder.append(" horiz/");
        stringBuilder.append(jpegComponent.getVerticalSamplingFactor());
        stringBuilder.append(" vert");
        return stringBuilder.toString();
    }
}

