/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.ala.layers.intersect.IniReader;

public class Diva2bil {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("diva to hdr bil.\n\n");
            System.out.println("args[0] = diva grid (without .grd or .gri)\nargs[1] = bil (.bil and .hdr appended)\n");
            return;
        }
        Diva2bil.diva2bil(args[0], args[1]);
    }

    public static boolean diva2bil(String divaFilename, String bilFilename) {
        boolean ret = true;
        try {
            int len;
            File dataFile = new File(divaFilename + ".gri");
            IniReader ir = new IniReader(divaFilename + ".grd");
            double minx = ir.getDoubleValue("GeoReference", "MinX");
            double maxy = ir.getDoubleValue("GeoReference", "MaxY");
            double xdiv = ir.getDoubleValue("GeoReference", "ResolutionX");
            double ydiv = ir.getDoubleValue("GeoReference", "ResolutionY");
            double nodatavalue = -9999.0;
            if (ir.valueExists("Data", "NoDataValue")) {
                nodatavalue = ir.getDoubleValue("Data", "NoDataValue");
            }
            int nrows = ir.getIntegerValue("GeoReference", "Rows");
            int ncols = ir.getIntegerValue("GeoReference", "Columns");
            String type = Diva2bil.getType(ir.getStringValue("Data", "DataType"));
            int nbytes = Diva2bil.getByteCount(type);
            FileWriter fw = new FileWriter(bilFilename + ".hdr");
            fw.append("BYTEORDER      I\n");
            fw.append("LAYOUT         BIL\n");
            fw.append("NROWS      " + nrows + "\n");
            fw.append("NCOLS      " + ncols + "\n");
            fw.append("NBANDS      1\n");
            fw.append("NBITS      " + nbytes * 8 + "\n");
            fw.append("BANDROWBYTES      " + nbytes * ncols + "\n");
            fw.append("TOTALROWBYTES      " + nbytes * ncols + "\n");
            fw.append("PIXELTYPE      " + type + "\n");
            fw.append("ULXMAP      " + (minx + xdiv / 2.0) + "\n");
            fw.append("ULYMAP      " + (maxy - ydiv / 2.0) + "\n");
            fw.append("XDIM      " + xdiv + "\n");
            fw.append("YDIM      " + ydiv + "\n");
            fw.append("NODATA      " + nodatavalue + "\n");
            fw.close();
            FileInputStream fis = new FileInputStream(dataFile);
            FileOutputStream fos = new FileOutputStream(bilFilename + ".bil");
            byte[] buf = new byte[0x100000];
            while ((len = fis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fis.close();
            fos.close();
            System.out.println("finished\n");
        }
        catch (Exception e) {
            ret = false;
            e.printStackTrace();
        }
        return ret;
    }

    static String getType(String datatype) {
        if ((datatype = datatype.toUpperCase()).equals("INT1BYTE")) {
            datatype = "BYTE";
        } else if (datatype.equals("INT2BYTES")) {
            datatype = "SHORT";
        } else if (datatype.equals("INT4BYTES")) {
            datatype = "INT";
        } else if (datatype.equals("INT8BYTES")) {
            datatype = "LONG";
        } else if (datatype.equals("FLT4BYTES")) {
            datatype = "FLOAT";
        } else if (datatype.equals("FLT8BYTES")) {
            datatype = "DOUBLE";
        } else if (datatype.equals("INT1B") || datatype.equals("BYTE")) {
            datatype = "BYTE";
        } else if (datatype.equals("INT1U") || datatype.equals("UBYTE")) {
            datatype = "UBYTE";
        } else if (datatype.equals("INT2B") || datatype.equals("INT16") || datatype.equals("INT2S")) {
            datatype = "SHORT";
        } else if (datatype.equals("INT4B")) {
            datatype = "INT";
        } else if (datatype.equals("INT8B") || datatype.equals("INT32")) {
            datatype = "LONG";
        } else if (datatype.equals("FLT4B") || datatype.equals("FLOAT32") || datatype.equals("FLT4S")) {
            datatype = "FLOAT";
        } else if (datatype.equals("FLT8B")) {
            datatype = "DOUBLE";
        } else if (datatype.equals("BYTE")) {
            datatype = "BYTE";
        } else if (datatype.equals("SHORT")) {
            datatype = "SHORT";
        } else if (datatype.equals("INT")) {
            datatype = "INT";
        } else if (datatype.equals("LONG")) {
            datatype = "LONG";
        } else if (datatype.equals("FLOAT")) {
            datatype = "FLOAT";
        } else if (datatype.equals("DOUBLE")) {
            datatype = "DOUBLE";
        } else if (datatype.equals("INTEGER")) {
            datatype = "INT";
        } else if (datatype.equals("SMALLINT")) {
            datatype = "INT";
        } else if (datatype.equals("SINGLE")) {
            datatype = "FLOAT";
        } else if (datatype.equals("REAL")) {
            datatype = "FLOAT";
        } else {
            System.out.println("GRID unknown type: " + datatype);
            datatype = "UNKNOWN";
        }
        return datatype;
    }

    static int getByteCount(String datatype) {
        int nbytes = datatype.equals("BYTE") || datatype.equals("UBYTE") ? 1 : (datatype.equals("SHORT") ? 2 : (datatype.equals("INT") ? 4 : (datatype.equals("LONG") ? 8 : (datatype.equals("SINGLE") ? 4 : (datatype.equals("FLOAT") ? 4 : (datatype.equals("DOUBLE") ? 8 : 0))))));
        return nbytes;
    }

    static double[] getMinMax(int nbits, String datatype, int nrows, int ncols, String byteOrder, double missingValue, File bilFile) {
        double[] minmax = new double[]{Double.NaN, Double.NaN};
        try {
            RandomAccessFile raf = new RandomAccessFile(bilFile, "r");
            byte[] b = new byte[(int)raf.length()];
            raf.read(b);
            ByteBuffer bb = ByteBuffer.wrap(b);
            raf.close();
            if (byteOrder == null || byteOrder.equals("m")) {
                bb.order(ByteOrder.BIG_ENDIAN);
            } else {
                bb.order(ByteOrder.LITTLE_ENDIAN);
            }
            int length = nrows * ncols;
            if (datatype.equalsIgnoreCase("UBYTE") || datatype.equalsIgnoreCase("INT1U")) {
                for (int i = 0; i < length; ++i) {
                    double ret = bb.get();
                    if (ret < 0.0) {
                        ret += 256.0;
                    }
                    Diva2bil.updateMinMax(minmax, ret, missingValue);
                }
            } else if (datatype.equalsIgnoreCase("BYTE") || datatype.equalsIgnoreCase("INT1BYTE") || datatype.equalsIgnoreCase("INT1B")) {
                for (int i = 0; i < length; ++i) {
                    Diva2bil.updateMinMax(minmax, bb.get(), missingValue);
                }
            } else if (nbits == 16) {
                for (int i = 0; i < length; ++i) {
                    Diva2bil.updateMinMax(minmax, bb.getShort(), missingValue);
                }
            } else if (datatype.equalsIgnoreCase("INT") || datatype.equalsIgnoreCase("INTEGER") || datatype.equalsIgnoreCase("INT4BYTES") || datatype.equalsIgnoreCase("INT4B") || datatype.equalsIgnoreCase("INT32") || datatype.equalsIgnoreCase("SMALLINT")) {
                for (int i = 0; i < length; ++i) {
                    Diva2bil.updateMinMax(minmax, bb.getInt(), missingValue);
                }
            } else if (datatype.equalsIgnoreCase("LONG") || datatype.equalsIgnoreCase("INT8BYTES") || datatype.equalsIgnoreCase("INT8B") || datatype.equalsIgnoreCase("INT64")) {
                for (int i = 0; i < length; ++i) {
                    Diva2bil.updateMinMax(minmax, bb.getLong(), missingValue);
                }
            } else if (datatype.equalsIgnoreCase("FLOAT") || datatype.equalsIgnoreCase("FLT4BYTES") || datatype.equalsIgnoreCase("FLT4B") || datatype.equalsIgnoreCase("FLOAT32") || datatype.equalsIgnoreCase("FLT4S") || datatype.equalsIgnoreCase("REAL") || datatype.equalsIgnoreCase("SINGLE")) {
                for (int i = 0; i < length; ++i) {
                    Diva2bil.updateMinMax(minmax, bb.getFloat(), missingValue);
                }
            } else if (datatype.equalsIgnoreCase("DOUBLE") || datatype.equalsIgnoreCase("FLT8BYTES") || datatype.equalsIgnoreCase("FLT8B") || datatype.equalsIgnoreCase("FLOAT64") || datatype.equalsIgnoreCase("FLT8S")) {
                for (int i = 0; i < length; ++i) {
                    Diva2bil.updateMinMax(minmax, bb.getDouble(), missingValue);
                }
            } else {
                System.out.println("UNKNOWN TYPE: " + datatype);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return minmax;
    }

    static void updateMinMax(double[] minmax, double d, double missingValue) {
        if (d != missingValue) {
            if (Double.isNaN(minmax[0])) {
                minmax[0] = d;
                minmax[1] = d;
            } else {
                if (minmax[0] > d) {
                    minmax[0] = d;
                }
                if (minmax[1] < d) {
                    minmax[1] = d;
                }
            }
        }
    }
}

