/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.dto;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Entity
@Table(name="layers")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class Layer {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="layers_id_seq")
    @SequenceGenerator(name="layers_id_seq", sequenceName="layers_id_seq")
    @Column(name="id", insertable=false, updatable=false)
    private Long id;
    @Column(name="uid")
    private String uid;
    @Column(name="name")
    private String name;
    @Column(name="displayname")
    private String displayname;
    @Column(name="description")
    private String description;
    @Column(name="type")
    private String type;
    @Column(name="source")
    private String source;
    @Column(name="path")
    private String path;
    @Column(name="displaypath")
    private String displaypath;
    @Column(name="scale")
    private String scale;
    @Column(name="extents")
    private String extent;
    @Column(name="minlatitude")
    private Double minlatitude;
    @Column(name="minlongitude")
    private Double minlongitude;
    @Column(name="maxlatitude")
    private Double maxlatitude;
    @Column(name="maxlongitude")
    private Double maxlongitude;
    @Column(name="notes")
    private String notes;
    @Column(name="enabled")
    private Boolean enabled;
    @Column(name="environmentalvaluemin")
    private String environmentalvaluemin;
    @Column(name="environmentalvaluemax")
    private String environmentalvaluemax;
    @Column(name="environmentalvalueunits")
    private String environmentalvalueunits;
    @Column(name="lookuptablepath")
    private String lookuptablepath;
    @Column(name="metadatapath")
    private String metadatapath;
    @Column(name="classification1")
    private String classification1;
    @Column(name="classification2")
    private String classification2;
    @Column(name="mddatest")
    private String mddatest;
    @Column(name="citation_date")
    private String citation_date;
    @Column(name="datalang")
    private String datalang;
    @Column(name="mdhrlv")
    private String mdhrlv;
    @Column(name="respparty_role")
    private String respparty_role;
    @Column(name="licence_level")
    private String licence_level;
    @Column(name="licence_link")
    private String licence_link;
    @Column(name="licence_notes")
    private String licence_notes;
    @Column(name="source_link")
    private String source_link;
    @Column(name="keywords")
    private String keywords;
    @Column(name="path_orig")
    private String path_orig;
    @Column(name="path_1km")
    private String path_1km;
    @Column(name="path_250m")
    private String path_250m;
    @Column(name="domain")
    private String domain;
    @Column(name="pid")
    private String pid;

    public Layer() {
    }

    public Layer(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getExtent() {
        return this.extent;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Double getMaxlatitude() {
        return this.maxlatitude;
    }

    public void setMaxlatitude(Double maxlatitude) {
        if (maxlatitude != null) {
            this.maxlatitude = (double)maxlatitude;
        }
    }

    public Double getMaxlongitude() {
        return this.maxlongitude;
    }

    public void setMaxlongitude(Double maxlongitude) {
        if (maxlongitude != null) {
            this.maxlongitude = (double)maxlongitude;
        }
    }

    public Double getMinlatitude() {
        return this.minlatitude;
    }

    public void setMinlatitude(Double minlatitude) {
        if (minlatitude != null) {
            this.minlatitude = (double)minlatitude;
        }
    }

    public Double getMinlongitude() {
        return this.minlongitude;
    }

    public void setMinlongitude(Double minlongitude) {
        if (minlongitude != null) {
            this.minlongitude = (double)minlongitude;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDisplaypath() {
        return this.displaypath;
    }

    public void setDisplaypath(String displaypath) {
        this.displaypath = displaypath;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getScale() {
        return this.scale;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public String getClassification1() {
        return this.classification1;
    }

    public void setClassification1(String classification1) {
        this.classification1 = classification1;
    }

    public String getClassification2() {
        return this.classification2;
    }

    public void setClassification2(String classification2) {
        this.classification2 = classification2;
    }

    public String getEnvironmentalvaluemax() {
        return this.environmentalvaluemax;
    }

    public void setEnvironmentalvaluemax(String environmentalvaluemax) {
        this.environmentalvaluemax = environmentalvaluemax;
    }

    public String getEnvironmentalvaluemin() {
        return this.environmentalvaluemin;
    }

    public void setEnvironmentalvaluemin(String environmentalvaluemin) {
        this.environmentalvaluemin = environmentalvaluemin;
    }

    public String getEnvironmentalvalueunits() {
        return this.environmentalvalueunits;
    }

    public void setEnvironmentalvalueunits(String environmentalvalueunits) {
        this.environmentalvalueunits = environmentalvalueunits;
    }

    public String getLookuptablepath() {
        return this.lookuptablepath;
    }

    public void setLookuptablepath(String lookuptablepath) {
        this.lookuptablepath = lookuptablepath;
    }

    public String getMetadatapath() {
        return this.metadatapath;
    }

    public void setMetadatapath(String metadatapath) {
        this.metadatapath = metadatapath;
    }

    public String getCitation_date() {
        return this.citation_date;
    }

    public void setCitation_date(String citationdate) {
        this.citation_date = citationdate;
    }

    public String getDatalang() {
        return this.datalang;
    }

    public void setDatalang(String datalang) {
        this.datalang = datalang;
    }

    public String getLicence_link() {
        return this.licence_link;
    }

    public void setLicence_link(String licence_link) {
        this.licence_link = licence_link;
    }

    public String getLicence_notes() {
        return this.licence_notes;
    }

    public void setLicence_notes(String licence_notes) {
        this.licence_notes = licence_notes;
    }

    public String getLicence_level() {
        return this.licence_level;
    }

    public void setLicence_level(String licencelevel) {
        this.licence_level = licencelevel;
    }

    public String getMddatest() {
        return this.mddatest;
    }

    public void setMddatest(String mddatest) {
        this.mddatest = mddatest;
    }

    public String getMdhrlv() {
        return this.mdhrlv;
    }

    public void setMdhrlv(String mdhrlv) {
        this.mdhrlv = mdhrlv;
    }

    public String getRespparty_role() {
        return this.respparty_role;
    }

    public void setRespparty_role(String resppartyrole) {
        this.respparty_role = resppartyrole;
    }

    public String getSource_link() {
        return this.source_link;
    }

    public void setSource_link(String sourcelink) {
        this.source_link = sourcelink;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getPath_1km() {
        return this.path_1km;
    }

    public void setPath_1km(String path1km) {
        this.path_1km = path1km;
    }

    public String getPath_250m() {
        return this.path_250m;
    }

    public void setPath250m(String path250m) {
        this.path_250m = path250m;
    }

    public String getPath_orig() {
        return this.path_orig;
    }

    public void setPath_orig(String pathorig) {
        this.path_orig = pathorig;
    }

    public String getdomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String[] toArray() {
        if (this.description == null) {
            this.description = "";
        }
        if (this.licence_notes == null) {
            this.licence_notes = "";
        }
        if (this.notes == null) {
            this.notes = "";
        }
        if (this.keywords == null) {
            this.keywords = "";
        }
        Vector<String> v = new Vector<String>();
        v.add(this.uid);
        v.add(this.name);
        v.add(this.displayname);
        v.add(this.description.replaceAll("\n", " "));
        v.add(this.source);
        v.add(this.source_link);
        v.add(this.respparty_role);
        v.add(this.mddatest);
        v.add(this.citation_date);
        v.add(this.licence_level);
        v.add(this.licence_link);
        v.add(this.licence_notes.replaceAll("\n", " "));
        v.add(this.type);
        v.add(this.classification1);
        v.add(this.classification2);
        v.add(this.environmentalvalueunits);
        v.add(this.notes.replaceAll("\n", " "));
        v.add(this.metadatapath);
        v.add(this.keywords);
        return v.toArray(new String[v.size()]);
    }

    public String toString() {
        if (this.description == null) {
            this.description = "";
        }
        if (this.licence_notes == null) {
            this.licence_notes = "";
        }
        if (this.notes == null) {
            this.notes = "";
        }
        if (this.keywords == null) {
            this.keywords = "";
        }
        String lyr = "";
        lyr = lyr + "\"" + this.uid + "\", ";
        lyr = lyr + "\"" + this.displayname + "\", ";
        lyr = lyr + "\"" + this.description.replaceAll("\n", " ").replaceAll("\"", "\\\"") + "\", ";
        lyr = lyr + "\"" + this.source + "\", ";
        lyr = lyr + "\"" + this.source_link + "\", ";
        lyr = lyr + "\"" + this.respparty_role + "\", ";
        lyr = lyr + "\"" + this.mddatest + "\", ";
        lyr = lyr + "\"" + this.citation_date + "\", ";
        lyr = lyr + "\"" + this.licence_level + "\", ";
        lyr = lyr + "\"" + this.licence_link + "\", ";
        lyr = lyr + "\"" + this.licence_notes.replaceAll("\n", " ").replaceAll("\"", "\\\"") + "\", ";
        lyr = lyr + "\"" + this.type + "\", ";
        lyr = lyr + "\"" + this.classification1 + "\", ";
        lyr = lyr + "\"" + this.classification2 + "\", ";
        lyr = lyr + "\"" + this.environmentalvalueunits + "\", ";
        lyr = lyr + "\"" + this.datalang + "\", ";
        lyr = lyr + "\"" + this.mdhrlv + "\", ";
        lyr = lyr + "\"" + this.notes.replaceAll("\n", " ").replaceAll("\"", "\\\"") + "\", ";
        lyr = lyr + "\"" + this.metadatapath + "\", ";
        lyr = lyr + "\"" + this.keywords + "\"";
        return lyr;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("citation_date", this.citation_date);
        m.put("classification1", this.classification1);
        m.put("classification2", this.classification2);
        m.put("datalang", this.datalang);
        m.put("description", this.description);
        m.put("displayname", this.displayname);
        m.put("displaypath", this.displaypath);
        m.put("enabled", this.enabled);
        m.put("domain", this.domain);
        m.put("environmentalvaluemax", this.environmentalvaluemax);
        m.put("environmentalvaluemin", this.environmentalvaluemin);
        m.put("environmentalvalueunits", this.environmentalvalueunits);
        m.put("extents", this.extent);
        m.put("keywords", this.keywords);
        m.put("licence_link", this.licence_link);
        m.put("licence_notes", this.licence_notes);
        m.put("licence_level", this.licence_level);
        m.put("lookuptablepath", this.lookuptablepath);
        m.put("maxlatitude", this.maxlatitude);
        m.put("maxlongitude", this.maxlongitude);
        m.put("mddatest", this.mddatest);
        m.put("mdhrlv", this.mdhrlv);
        m.put("metadatapath", this.metadatapath);
        m.put("minlatitude", this.minlatitude);
        m.put("minlongitude", this.minlongitude);
        m.put("name", this.name);
        m.put("notes", this.notes);
        m.put("path", this.path);
        m.put("path_1km", this.path_1km);
        m.put("path_250m", this.path_250m);
        m.put("path_orig", this.path_orig);
        m.put("pid", this.pid);
        m.put("respparty_role", this.respparty_role);
        m.put("scale", this.scale);
        m.put("source", this.source);
        m.put("source_link", this.source_link);
        m.put("type", this.type);
        m.put("uid", this.uid);
        m.put("id", this.id);
        return m;
    }

    public boolean isShape() {
        return this.type != null && "contextual".equals(this.type.toLowerCase());
    }

    public boolean isGrid() {
        return this.type != null && "environmental".equals(this.type.toLowerCase());
    }
}

