/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.dao;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.ala.layers.dao.LayerIntersectDAO;
import org.ala.layers.dao.SearchDAO;
import org.ala.layers.dto.GridClass;
import org.ala.layers.dto.IntersectionFile;
import org.ala.layers.dto.SearchObject;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="searchDao")
public class SearchDAOImpl
implements SearchDAO {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    private SimpleJdbcTemplate jdbcTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Override
    public List<SearchObject> findByCriteria(String criteria, int limit) {
        logger.info((Object)("Getting search results for query: " + criteria));
        String sql = "select pid, id, name, \"desc\" as description, fid, fieldname from searchobjects(?,?)";
        return this.addGridClassesToSearch(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(SearchObject.class), new Object[]{"%" + criteria + "%", limit}), criteria, limit);
    }

    private List<SearchObject> addGridClassesToSearch(List<SearchObject> search, String criteria, int limit) {
        int pos;
        criteria = criteria.toLowerCase();
        int maxPos = Integer.MAX_VALUE;
        for (SearchObject so : search) {
            pos = so.getName().toLowerCase().indexOf(criteria);
            if (pos < 0 || pos >= maxPos) continue;
            maxPos = pos;
        }
        for (IntersectionFile f : this.layerIntersectDao.getConfig().getIntersectionFiles().values()) {
            if (!f.getType().equalsIgnoreCase("a") || f.getClasses() == null) continue;
            for (Map.Entry<Integer, GridClass> c : f.getClasses().entrySet()) {
                pos = c.getValue().getName().toLowerCase().indexOf(criteria);
                if (pos < 0 || pos > maxPos) continue;
                search.add(SearchObject.create(f.getLayerPid() + ":" + c.getKey(), f.getLayerPid() + ":" + c.getKey(), c.getValue().getName(), null, f.getFieldId(), f.getFieldName()));
            }
        }
        return search;
    }
}

