/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.ala.layers.dao.FieldDAO;
import org.ala.layers.dao.LayerIntersectDAO;
import org.ala.layers.dto.Field;
import org.ala.layers.intersect.IntersectConfig;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="fieldDao")
public class FieldDAOImpl
implements FieldDAO {
    private static final Logger logger = Logger.getLogger(FieldDAOImpl.class);
    private SimpleJdbcTemplate jdbcTemplate;
    @Resource(name="layerIntersectDao")
    private LayerIntersectDAO layerIntersectDao;

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    @Override
    public List<Field> getFields() {
        logger.info((Object)"Getting a list of all enabled fields");
        String sql = "select * from fields where enabled=true";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Field.class), new Object[0]);
    }

    @Override
    public Field getFieldById(String id) {
        logger.info((Object)("Getting enabled field info for id = " + id));
        String sql = "select * from fields where enabled=true and id = ?";
        List l = this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Field.class), new Object[]{id});
        if (l.size() > 0) {
            return (Field)l.get(0);
        }
        return null;
    }

    @Override
    public List<Field> getFieldsByDB() {
        this.layerIntersectDao.getConfig();
        if (IntersectConfig.getLayerIndexUrl() != null) {
            return this.layerIntersectDao.getConfig().getFieldsByDB();
        }
        logger.info((Object)"Getting a list of all enabled fields with indb");
        String sql = "select * from fields where enabled=TRUE and indb=TRUE";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Field.class), new Object[0]);
    }
}

