/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.dao;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.ala.layers.dao.DistributionDAO;
import org.ala.layers.dto.Distribution;
import org.ala.layers.dto.Facet;
import org.ala.layers.intersect.IntersectConfig;
import org.apache.log4j.Logger;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="distributionDao")
public class DistributionDAOImpl
implements DistributionDAO {
    private static final Logger logger = Logger.getLogger(DistributionDAOImpl.class);
    private SimpleJdbcTemplate jdbcTemplate;
    private String viewName = "distributions";
    private final String SELECT_CLAUSE = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid";

    @Override
    public Distribution findDistributionByLSIDOrName(String lsidOrName) {
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid from " + this.viewName + " WHERE " + "lsid=:lsid OR caab_species_number=:caab_species_number " + "OR scientific like :scientificName OR scientific like :scientificNameWithSubgenus limit 1";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lsid", lsidOrName);
        params.put("scientificName", lsidOrName);
        params.put("scientificNameWithSubgenus", this.removeSubGenus(lsidOrName));
        params.put("caab_species_number", lsidOrName);
        List<Distribution> ds = this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
        if (!ds.isEmpty()) {
            return ds.get(0);
        }
        return null;
    }

    private String removeSubGenus(String str) {
        if (str != null && str.contains("(") && str.contains(")")) {
            return str.replaceAll(" \\([A-Z][a-z]{1,}\\) ", " ");
        }
        return str;
    }

    @Override
    public List<Distribution> queryDistributions(String wkt, double min_depth, double max_depth, Integer geomIdx, String lsids, String type, String[] dataResources) {
        return this.queryDistributions(wkt, min_depth, max_depth, null, null, null, null, null, geomIdx, lsids, null, null, null, null, type, dataResources);
    }

    @Override
    public List<Distribution> queryDistributions(String wkt, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources) {
        logger.info((Object)"Getting distributions list");
        StringBuilder whereClause = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause);
        if (wkt != null && wkt.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("ST_INTERSECTS(the_geom, ST_GEOMFROMTEXT( :wkt , 4326))");
            params.put("wkt", wkt);
        }
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid from " + this.viewName;
        if (whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause.toString();
        }
        return this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
    }

    @Override
    public List<Facet> queryDistributionsFamilyCounts(String wkt, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources) {
        logger.info((Object)"Getting distributions list - family counts");
        StringBuilder whereClause = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause);
        if (wkt != null && wkt.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("ST_INTERSECTS(the_geom, ST_GEOMFROMTEXT( :wkt , 4326))");
            params.put("wkt", wkt);
        }
        String sql = "Select family as name, count(*) as count from " + this.viewName;
        if (whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause.toString();
        }
        sql = sql + " group by family";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Facet.class), params);
    }

    @Override
    public Distribution getDistributionBySpcode(long spcode, String type) {
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid, ST_AsText(the_geom) AS geometry, ST_AsText(bounding_box) as bounding_box FROM " + this.viewName + " WHERE spcode= ? AND type= ?";
        List<Distribution> d = this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), new Object[]{(double)spcode, type}));
        if (d.size() > 0) {
            return d.get(0);
        }
        return null;
    }

    public List<Distribution> queryDistributionsByRadius(float longitude, float latitude, float radiusInMetres, double min_depth, double max_depth, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources) {
        return this.queryDistributionsByRadius(longitude, latitude, radiusInMetres, min_depth, max_depth, null, null, null, null, null, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources);
    }

    @Override
    public List<Distribution> queryDistributionsByRadius(float longitude, float latitude, float radiusInMetres, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources) {
        logger.info((Object)("Getting distributions list with a radius - " + radiusInMetres + "m"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("radius", this.convertMetresToDecimalDegrees(Float.valueOf(radiusInMetres)));
        params.put("type", type);
        String pointGeom = "POINT(" + longitude + " " + latitude + ")";
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid from " + this.viewName + " where ST_DWithin(the_geom, ST_GeomFromText('" + pointGeom + "', 4326), :radius)";
        StringBuilder whereClause = new StringBuilder();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause);
        if (whereClause.length() > 0) {
            sql = sql + " AND " + whereClause.toString();
        }
        return this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
    }

    @Override
    public List<Facet> queryDistributionsByRadiusFamilyCounts(float longitude, float latitude, float radiusInMetres, double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources) {
        logger.info((Object)"Getting distributions list with a radius");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("radius", this.convertMetresToDecimalDegrees(Float.valueOf(radiusInMetres)));
        params.put("type", type);
        String pointGeom = "POINT(" + longitude + " " + latitude + ")";
        String sql = "Select family as name, count(*) as count from " + this.viewName + " where ST_DWithin(the_geom, ST_GeomFromText('" + pointGeom + "', 4326), :radius)";
        StringBuilder whereClause = new StringBuilder();
        this.constructWhereClause(min_depth, max_depth, pelagic, coastal, estuarine, desmersal, groupName, geomIdx, lsids, families, familyLsids, genera, generaLsids, type, dataResources, params, whereClause);
        if (whereClause.length() > 0) {
            sql = sql + " AND " + whereClause.toString();
        }
        sql = sql + " group by family";
        return this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Facet.class), params);
    }

    @Override
    public List<Distribution> getDistributionByLSID(String[] lsids) {
        String sql = "select gid,spcode,scientific,authority_,common_nam,\"family\",genus_name,specific_n,min_depth,max_depth,pelagic_fl,coastal_fl,desmersal_fl,estuarine_fl,family_lsid,genus_lsid,caab_species_number,caab_family_number,group_name,metadata_u,wmsurl,lsid,type,area_name,pid,checklist_name,area_km,notes,geom_idx,image_quality,data_resource_uid, ST_AsText(the_geom) AS geometry, ST_AsText(bounding_box) as bounding_box FROM " + this.viewName + "  WHERE lsid IN (:lsids)";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lsids", Arrays.asList(lsids));
        params.put("type", "e");
        return this.updateWMSUrl(this.jdbcTemplate.query(sql, (ParameterizedRowMapper)ParameterizedBeanPropertyRowMapper.newInstance(Distribution.class), params));
    }

    public Double convertMetresToDecimalDegrees(Float metres) {
        return (double)metres.floatValue() / 1.11 * 1.0E-5;
    }

    private void constructWhereClause(double min_depth, double max_depth, Boolean pelagic, Boolean coastal, Boolean estuarine, Boolean desmersal, String groupName, Integer geomIdx, String lsids, String[] families, String[] familyLsids, String[] genera, String[] generaLsids, String type, String[] dataResources, Map<String, Object> params, StringBuilder where) {
        if (geomIdx != null && geomIdx >= 0) {
            where.append(" geom_idx = :geom_idx ");
            params.put("geom_idx", geomIdx);
        }
        if (lsids != null && lsids.length() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(":lsids LIKE '% '||lsid||' %'  ");
            params.put("lsids", " " + lsids.replace(",", " ") + " ");
        }
        if (dataResources != null && dataResources.length > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("data_resource_uid IN (:dataResources) ");
            params.put("dataResources", Arrays.asList(dataResources));
        }
        if (min_depth != -1.0 && max_depth != -1.0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("min_depth <= :max_depth AND max_depth >= :min_depth ");
            params.put("max_depth", new Double(max_depth));
            params.put("min_depth", new Double(min_depth));
        } else if (min_depth != -1.0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("max_depth >= :min_depth ");
            params.put("min_depth", new Double(min_depth));
        } else if (max_depth != -1.0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("min_depth <= :max_depth ");
            params.put("max_depth", new Double(max_depth));
        }
        if (pelagic != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            if (pelagic.booleanValue()) {
                where.append("pelagic_fl > 0 ");
            } else {
                where.append("pelagic_fl = 0 ");
            }
        }
        if (coastal != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("coastal_fl = :coastal ");
            params.put("coastal", coastal != false ? 1 : 0);
        }
        if (estuarine != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("estuarine_fl = :estuarine ");
            params.put("estuarine", estuarine != false ? 1 : 0);
        }
        if (desmersal != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("desmersal_fl = :desmersal ");
            params.put("desmersal", desmersal != false ? 1 : 0);
        }
        if (type != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("type = :distribution_type ");
            params.put("distribution_type", type);
        }
        if (groupName != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("group_name = :groupName ");
            params.put("groupName", groupName);
        }
        if (families != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("family IN (:families) ");
            params.put("families", Arrays.asList(families));
        }
        if (familyLsids != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("family_lsid IN (:familyLsids) ");
            params.put("familyLsids", Arrays.asList(familyLsids));
        }
        if (genera != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("genus_name IN (:genera) ");
            params.put("genera", Arrays.asList(genera));
        }
        if (generaLsids != null) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("genus_lsid IN (:generaLsids) ");
            params.put("generaLsids", Arrays.asList(generaLsids));
        }
    }

    private List<Distribution> updateWMSUrl(List<Distribution> distributions) {
        if (distributions != null) {
            for (Distribution distribution : distributions) {
                if (distribution.getWmsurl() == null) continue;
                distribution.setWmsurl(distribution.getWmsurl().replace("<COMMON_GEOSERVER_URL>", IntersectConfig.getGeoserverUrl()));
            }
        }
        return distributions;
    }

    @Override
    public int getNumberOfVertices(String lsid) {
        return this.jdbcTemplate.queryForInt("SELECT npoints(ds.the_geom) from distributionshapes ds join distributiondata dd on dd.geom_idx = ds.id where dd.lsid=? ", new Object[]{lsid});
    }

    @Override
    @Transactional(readOnly=false, propagation=Propagation.REQUIRES_NEW)
    public Map<String, Double> identifyOutlierPointsForDistribution(String lsid, Map<String, Map<String, Double>> points) {
        HashMap<String, Double> outlierDistances = new HashMap<String, Double>();
        String firstId = points.keySet().iterator().next();
        logger.debug((Object)("Starting to identifyOutlierPointsForDistribution " + lsid + " " + firstId));
        try {
            int expertDistributionShapeId = this.jdbcTemplate.queryForInt("SELECT geom_idx from distributiondata WHERE lsid = ?", new Object[]{lsid});
            logger.debug((Object)("Finished getting the geomid for " + firstId));
            if (points.isEmpty()) {
                return outlierDistances;
            }
            this.jdbcTemplate.update("CREATE TEMPORARY TABLE temp_exp_dist_outliers (id text PRIMARY KEY, point geography) ON COMMIT DROP", new Object[0]);
            logger.debug((Object)("Finished creating the temporary table  for " + firstId));
            for (String uuid : points.keySet()) {
                Map<String, Double> pointDetails = points.get(uuid);
                if (pointDetails == null) continue;
                Double latitude = pointDetails.get("decimalLatitude");
                Double longitude = pointDetails.get("decimalLongitude");
                if (latitude == null || longitude == null) continue;
                String wkt = "POINT(" + longitude + " " + latitude + ")";
                this.jdbcTemplate.update("INSERT INTO temp_exp_dist_outliers VALUES (?, ST_GeographyFromText(?))", new Object[]{uuid, wkt});
            }
            logger.debug((Object)("Finished inserting the points into the temp table for " + firstId + " " + this.jdbcTemplate.queryForInt("select count(*) from temp_exp_dist_outliers", (Map)null)));
            List outlierDistancesQueryResult = this.jdbcTemplate.queryForList("SELECT id, ST_DISTANCE(point, (SELECT Geography(the_geom) from distributionshapes where id = ?)) as distance from temp_exp_dist_outliers where (SELECT bounding_box FROM distributiondata where geom_idx = ?) IS NULL OR ST_Intersects(point, Geography((SELECT bounding_box FROM distributiondata where geom_idx = ?)))", new Object[]{expertDistributionShapeId, expertDistributionShapeId, expertDistributionShapeId});
            logger.debug((Object)("Finished running query to obtain outliers for " + firstId));
            for (Map queryResultRow : outlierDistancesQueryResult) {
                String uuid = (String)queryResultRow.get("id");
                Double distance = (Double)queryResultRow.get("distance");
                if (!(distance > 0.0)) continue;
                outlierDistances.put(uuid, distance);
            }
            logger.debug((Object)("Finished populating the map for " + firstId));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new IllegalArgumentException("No expert distribution associated with lsid " + lsid, ex);
        }
        return outlierDistances;
    }

    @Resource(name="dataSource")
    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }
}

