/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.networking.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;

public class WSSEUsernameToken {
    String _username;
    String _passwordDigest;
    String _nonce;
    Date _created;
    Boolean _isParsed;

    public boolean parseFrom(String usernameToken) {
        String[] parts = usernameToken.split(",");
        if (parts.length != 4) {
            return false;
        }
        try {
            this._username = parts[0].substring(24, 24 + parts[0].length() - 25);
            this._passwordDigest = parts[1].substring(17, 17 + parts[1].length() - 18);
            this._nonce = parts[2].substring(8, 8 + parts[2].length() - 9);
            String created = parts[3].substring(10, 10 + parts[3].length() - 11);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            this._created = format.parse(created);
        }
        catch (Exception e) {
            return false;
        }
        this._isParsed = true;
        return true;
    }

    public boolean isTimestampValid(int maxTokenAge, int allowedClockVariance) {
        return WSSEUsernameToken.isTimestampValid(this._created, maxTokenAge, allowedClockVariance);
    }

    public static boolean isTimestampValid(Date created, int maxTokenAge, int allowedClockVariance) {
        long diff;
        Date now = new Date();
        if (created.after(now)) {
            long adjustedCreated = created.getTime() - (long)allowedClockVariance;
            return adjustedCreated <= now.getTime();
        }
        return (diff -= (diff = now.getTime() - created.getTime()) > (long)allowedClockVariance ? (long)allowedClockVariance : diff) < (long)maxTokenAge;
    }

    public boolean isSignatureValid(String passwordHash) {
        String usernameTokenHash;
        try {
            usernameTokenHash = WSSEUsernameToken.generateUsernameTokenHash(this._nonce, this._created, passwordHash);
        }
        catch (Exception e) {
            return false;
        }
        return usernameTokenHash.equals(this._passwordDigest);
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public Date getCreated() {
        return this._created;
    }

    public void setCreated(Date created) {
        this._created = created;
    }

    public static String getUsernameFromToken(String usernameToken) {
        String[] parts = usernameToken.split(",");
        if (parts.length != 4) {
            return null;
        }
        String username = parts[0].substring(24, 24 + parts[0].length() - 25);
        assert (WSSEUsernameToken.isValidUsername(username).booleanValue());
        return username;
    }

    public static boolean authenticateUsernameToken(String usernameToken, String passwordHash, int maxTokenAge, int allowedClockVariance) throws Exception {
        String[] parts = usernameToken.split(",");
        if (parts.length != 4) {
            return false;
        }
        String passwordDigest = parts[1].substring(17, 17 + parts[1].length() - 18);
        String nonce = parts[2].substring(8, 8 + parts[2].length() - 9);
        String created = parts[3].substring(10, 10 + parts[3].length() - 11);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date tokenCreated = format.parse(created);
        if (!WSSEUsernameToken.isTimestampValid(tokenCreated, maxTokenAge, allowedClockVariance)) {
            return false;
        }
        String usernameTokenHash = WSSEUsernameToken.generateUsernameTokenHash(nonce, tokenCreated, passwordHash);
        return usernameTokenHash.equals(passwordDigest);
    }

    public static String generateUsernameToken(String username, String nonce, Date created, String passwordHash) throws Exception {
        assert (WSSEUsernameToken.isValidUsername(username).booleanValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return "UsernameToken Username=\"" + username + "\", " + "PasswordDigest=\"" + WSSEUsernameToken.generateUsernameTokenHash(nonce, created, passwordHash) + "\", " + "Nonce=\"" + nonce + "\", " + "Created=\"" + format.format(created) + "\"";
    }

    public static String generateUsernameTokenHash(String nonce, Date created, String passwordHash) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        byte[] n = nonce.getBytes("UTF8");
        byte[] c = format.format(created).getBytes("UTF8");
        byte[] p = passwordHash.getBytes("UTF8");
        byte[] toBeDigested = new byte[n.length + c.length + p.length];
        System.arraycopy(n, 0, toBeDigested, 0, n.length);
        System.arraycopy(c, 0, toBeDigested, n.length, c.length);
        System.arraycopy(p, 0, toBeDigested, n.length + c.length, p.length);
        ByteBuffer.wrap(p).clear();
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(toBeDigested);
        byte[] digest = md.digest();
        ByteBuffer.wrap(toBeDigested).clear();
        return WSSEUsernameToken.base64Encode(digest);
    }

    public static String generateNonce() throws Exception {
        byte[] nonce = new byte[16];
        new Random().nextBytes(nonce);
        return WSSEUsernameToken.base64Encode(nonce);
    }

    public static String generatePasswordHash(String password) throws Exception {
        byte[] ph = password.getBytes("UTF8");
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(ph);
        byte[] digest = md.digest();
        ByteBuffer.wrap(ph).clear();
        return WSSEUsernameToken.base64Encode(digest);
    }

    public static String base64Encode(byte[] bytes) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream b64os = MimeUtility.encode((OutputStream)baos, (String)"base64");
        b64os.write(bytes);
        b64os.close();
        return new String(baos.toByteArray()).trim();
    }

    public static Boolean isValidUsername(String username) {
        Pattern pattern = Pattern.compile("[^a-zA-Z0-9-]");
        Matcher matcher = pattern.matcher(username);
        return !matcher.matches();
    }
}

