/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.scale7.cassandra.pelops.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeType {
    private static final byte COMPONENT_END = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeType.class);

    private CompositeType() {
    }

    public static List<byte[]> parse(Bytes compositeKey) {
        if (compositeKey == null) {
            return null;
        }
        return CompositeType.parse(compositeKey.toByteArray());
    }

    public static List<byte[]> parse(byte[] compositeKey) {
        if (compositeKey == null) {
            return null;
        }
        if (compositeKey.length < 2) {
            throw new IllegalArgumentException("Invalid Composite type structure");
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>(3);
        int ndx = 0;
        int componentStartNdx = 0;
        int componentEndNdx = 0;
        short componentLength = 0;
        while (compositeKey.length > (componentStartNdx = ndx + 2)) {
            componentLength = ByteBuffer.wrap(Arrays.copyOfRange(compositeKey, ndx, componentStartNdx)).getShort();
            componentEndNdx = componentStartNdx + componentLength;
            if (compositeKey.length < componentEndNdx + 1) {
                throw new IllegalStateException("Invalid Composite type structure");
            }
            if (compositeKey[componentEndNdx] != 0) {
                throw new IllegalStateException("Invalid Composite type structure: Not properly terminated, should be 0 byte terminated, found " + compositeKey[componentEndNdx]);
            }
            list.add(Arrays.copyOfRange(compositeKey, componentStartNdx, componentEndNdx));
            ndx = componentEndNdx + 1;
        }
        return list;
    }

    public static class Builder {
        private List<ByteBuffer> parts = null;

        private Builder(int count) {
            this.parts = new ArrayList<ByteBuffer>(count);
        }

        public static Builder newBuilder(int partsCount) {
            if (partsCount < 1) {
                throw new IllegalArgumentException("Invalid parts count. Should be 2 or more.");
            }
            return new Builder(partsCount);
        }

        public static Builder newBuilder() {
            return new Builder(2);
        }

        public Builder addByteBuffer(ByteBuffer value) {
            this.parts.add(value);
            return this;
        }

        public Builder addBytes(Bytes value) {
            return this.addByteBuffer(value.getBytes());
        }

        public Builder addBoolean(boolean value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromBoolean(value));
        }

        public Builder addBoolean(Boolean value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromBoolean(value));
        }

        public Builder addByte(byte value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromByte(value));
        }

        public Builder addByte(Byte value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromByte(value));
        }

        public Builder addByteArray(byte[] value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromByteArray(value));
        }

        public Builder addChar(char value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromChar(value));
        }

        public Builder addChar(Character value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromChar(value.charValue()));
        }

        public Builder addDouble(double value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromDouble(value));
        }

        public Builder addDouble(Double value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromDouble(value));
        }

        public Builder addFloat(float value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromFloat(value));
        }

        public Builder addFloat(Float value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromFloat(value.floatValue()));
        }

        public Builder addInt(int value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromInt(value));
        }

        public Builder addInt(Integer value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromInt(value));
        }

        public Builder addLong(long value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromLong(value));
        }

        public Builder addLong(Long value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromLong(value));
        }

        public Builder addShort(short value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromShort(value));
        }

        public Builder addShort(Short value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromShort(value));
        }

        public Builder addUTF8(String str) {
            return this.addByteBuffer(Bytes.BufferHelper.fromUTF8(str));
        }

        public Builder addUuid(UUID value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromUuid(value));
        }

        public Builder addUuid(String value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromUuid(value));
        }

        public Builder addUuid(long msb, long lsb) {
            return this.addByteBuffer(Bytes.BufferHelper.fromUuid(msb, lsb));
        }

        public Builder addTimeUuid(com.eaio.uuid.UUID value) {
            return this.addByteBuffer(Bytes.BufferHelper.fromUuid(value.getTime(), value.getClockSeqAndNode()));
        }

        public void clear() {
            this.parts.clear();
        }

        public Bytes build() {
            if (this.parts == null || this.parts.isEmpty()) {
                return null;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (ByteBuffer part : this.parts) {
                if (!part.hasArray()) {
                    throw new IllegalStateException("Connot build CompositeType. Invalid composite byte part encountered");
                }
                bos.write((byte)(part.array().length >> 8 & 0xFF));
                bos.write((byte)(part.array().length & 0xFF));
                for (byte partByte : part.array()) {
                    bos.write(partByte & 0xFF);
                }
                bos.write(0);
            }
            Bytes bytes = Bytes.fromByteArray(bos.toByteArray());
            try {
                bos.close();
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close the compostite type output stream", (Throwable)ex);
            }
            return bytes;
        }
    }
}

