/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.Closeable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.TimeZoneUtils;
import org.slf4j.Logger;

public class SolrRequestInfo {
    protected static final ThreadLocal<SolrRequestInfo> threadLocal = new ThreadLocal();
    protected SolrQueryRequest req;
    protected SolrQueryResponse rsp;
    protected Date now;
    protected TimeZone tz;
    protected ResponseBuilder rb;
    protected List<Closeable> closeHooks;

    public static SolrRequestInfo getRequestInfo() {
        return threadLocal.get();
    }

    public static void setRequestInfo(SolrRequestInfo info) {
        SolrRequestInfo prev = threadLocal.get();
        if (prev != null) {
            SolrCore.log.error("Previous SolrRequestInfo was not closed!  req=" + prev.req.getOriginalParams().toString());
        }
        assert (prev == null);
        threadLocal.set(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRequestInfo() {
        try {
            SolrRequestInfo info = threadLocal.get();
            if (info != null && info.closeHooks != null) {
                for (Closeable hook : info.closeHooks) {
                    try {
                        hook.close();
                    }
                    catch (Throwable throwable) {
                        SolrException.log((Logger)SolrCore.log, (String)"Exception during close hook", (Throwable)throwable);
                    }
                }
            }
        }
        finally {
            threadLocal.remove();
        }
    }

    public SolrRequestInfo(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.req = req;
        this.rsp = rsp;
    }

    public Date getNOW() {
        if (this.now != null) {
            return this.now;
        }
        long ms = 0L;
        String nowStr = this.req.getParams().get("NOW");
        ms = nowStr != null ? Long.parseLong(nowStr) : this.req.getStartTime();
        this.now = new Date(ms);
        return this.now;
    }

    public TimeZone getClientTimeZone() {
        String tzStr;
        if (this.tz == null && (tzStr = this.req.getParams().get("TZ")) != null) {
            this.tz = TimeZoneUtils.getTimeZone(tzStr);
            if (null == this.tz) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr JVM does not support TZ: " + tzStr);
            }
        }
        return this.tz;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public SolrQueryResponse getRsp() {
        return this.rsp;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.rb;
    }

    public void setResponseBuilder(ResponseBuilder rb) {
        this.rb = rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseHook(Closeable hook) {
        SolrRequestInfo solrRequestInfo = this;
        synchronized (solrRequestInfo) {
            if (this.closeHooks == null) {
                this.closeHooks = new LinkedList<Closeable>();
            }
            this.closeHooks.add(hook);
        }
    }
}

