/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElectionContext {
    private static Logger log = LoggerFactory.getLogger(ElectionContext.class);
    final String electionPath;
    final ZkNodeProps leaderProps;
    final String id;
    final String leaderPath;
    String leaderSeqPath;
    private SolrZkClient zkClient;

    public ElectionContext(String coreNodeName, String electionPath, String leaderPath, ZkNodeProps leaderProps, SolrZkClient zkClient) {
        this.id = coreNodeName;
        this.electionPath = electionPath;
        this.leaderPath = leaderPath;
        this.leaderProps = leaderProps;
        this.zkClient = zkClient;
    }

    public void close() {
    }

    public void cancelElection() throws InterruptedException, KeeperException {
        try {
            this.zkClient.delete(this.leaderSeqPath, -1, true);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("cancelElection did not find election node to remove");
        }
    }

    abstract void runLeaderProcess(boolean var1) throws KeeperException, InterruptedException, IOException;
}

