/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.terms;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.gbif.dwc.terms.AcTerm;
import org.gbif.dwc.terms.AlternativeNames;
import org.gbif.dwc.terms.DcElement;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.EolReferenceTerm;
import org.gbif.dwc.terms.GbifInternalTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.IucnTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.UnknownTerm;
import org.gbif.dwc.terms.XmpRightsTerm;
import org.gbif.dwc.terms.XmpTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TermFactory.class);
    private static final Pattern NON_ALPHA_NUM_PATTERN = Pattern.compile("[^a-zA-Z0-9#-]+");
    private static final String UNKNOWN_NAMESPACE = "http://unknown.org/";
    private static TermFactory singleton;
    private static boolean initialized;
    private static final Object LOCK;
    private final Map<String, Term> terms = new HashMap<String, Term>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TermFactory instance() {
        if (initialized) {
            return singleton;
        }
        Object object = LOCK;
        synchronized (object) {
            if (singleton == null) {
                LOG.debug("Building new TermFactory instance");
                singleton = new TermFactory();
                singleton.loadKnownTerms();
                initialized = true;
            }
        }
        return singleton;
    }

    private TermFactory() {
    }

    private void loadKnownTerms() {
        this.addTerms(DwcTerm.values(), DwcTerm.PREFIXES);
        this.addTerms(DcTerm.values(), DcTerm.PREFIXES);
        this.addTerms(GbifTerm.values(), GbifTerm.PREFIXES);
        this.addTerms(GbifInternalTerm.values(), new String[0]);
        this.addTerms(IucnTerm.values(), IucnTerm.PREFIXES);
        this.addTerms(DcElement.values(), DcElement.PREFIXES);
        this.addTerms(AcTerm.values(), AcTerm.PREFIXES);
        this.addTerms(XmpTerm.values(), XmpTerm.PREFIXES);
        this.addTerms(XmpRightsTerm.values(), XmpRightsTerm.PREFIXES);
        this.addTerms(EolReferenceTerm.values(), EolReferenceTerm.PREFIXES);
    }

    private <T extends Term & AlternativeNames> void addTerms(T[] terms, String[] prefixes) {
        for (T term : terms) {
            this.addTerm(term.simpleName(), (Term)term, true);
            this.addTerm(term.qualifiedName(), (Term)term);
            for (String pre : prefixes) {
                this.addTerm(pre + term.simpleName(), (Term)term);
            }
            for (String alt : ((AlternativeNames)term).alternativeNames()) {
                this.addTerm(alt, (Term)term);
                for (String pre : prefixes) {
                    this.addTerm(pre + alt, (Term)term);
                }
            }
        }
    }

    public void addTerm(String key, Term term) {
        this.addTerm(key, term, false);
    }

    public void addTerm(String key, Term term, boolean isClassTerm) {
        if (key == null || key.trim().isEmpty()) {
            return;
        }
        if (this.terms.containsKey(key = TermFactory.normaliseTerm(key, isClassTerm))) {
            Term t1 = this.terms.get(key);
            if (!t1.equals(term)) {
                LOG.warn("Terms {} and {} are both known as \"{}\". Keeping only {}", new Object[]{this.terms.get(key), term, key, this.terms.get(key)});
            }
        } else {
            this.terms.put(key, term);
        }
    }

    public static String normaliseTerm(String term) {
        return TermFactory.normaliseTerm(term, false);
    }

    public static String normaliseTerm(String term, boolean keepInitialCase) {
        String x = NON_ALPHA_NUM_PATTERN.matcher(term).replaceAll("");
        if (x.isEmpty()) {
            return "";
        }
        if (x.length() == 1) {
            return keepInitialCase ? String.valueOf(x.charAt(0)) : x.toLowerCase();
        }
        return keepInitialCase ? x.charAt(0) + x.substring(1).toLowerCase() : x.toLowerCase();
    }

    public Term findTerm(String termName) throws IllegalArgumentException {
        if (termName == null || termName.trim().isEmpty()) {
            return null;
        }
        if (this.terms.containsKey(termName)) {
            return this.terms.get(termName);
        }
        if (this.terms.containsKey(TermFactory.normaliseTerm(termName, true))) {
            return this.terms.get(TermFactory.normaliseTerm(termName, true));
        }
        if (this.terms.containsKey(TermFactory.normaliseTerm(termName))) {
            return this.terms.get(TermFactory.normaliseTerm(termName));
        }
        return this.createUnknownTerm(termName);
    }

    private Term createUnknownTerm(String termName) {
        UnknownTerm term;
        try {
            term = UnknownTerm.build(termName);
            this.addTerm(termName, term);
        }
        catch (IllegalArgumentException e) {
            term = UnknownTerm.build(UNKNOWN_NAMESPACE + termName);
            this.addTerm(termName, term);
            this.addTerm(term.qualifiedName(), term);
        }
        return term;
    }

    static {
        initialized = false;
        LOCK = new Object();
    }
}

