/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvelopeTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.EnvelopeType;
    }

    public Class getType() {
        return Envelope.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        if (node.getChild("lowerCorner") != null) {
            DirectPosition l = (DirectPosition)node.getChildValue("lowerCorner");
            DirectPosition u = (DirectPosition)node.getChildValue("upperCorner");
            return new ReferencedEnvelope(l.getOrdinate(0), u.getOrdinate(0), l.getOrdinate(1), u.getOrdinate(1), crs);
        }
        if (node.hasChild(Coordinate.class)) {
            List c = node.getChildValues(Coordinate.class);
            Coordinate c1 = (Coordinate)c.get(0);
            Coordinate c2 = (Coordinate)c.get(1);
            return new ReferencedEnvelope(c1.x, c2.x, c1.y, c2.y, crs);
        }
        if (node.hasChild(DirectPosition.class)) {
            List dp = node.getChildValues(DirectPosition.class);
            DirectPosition dp1 = (DirectPosition)dp.get(0);
            DirectPosition dp2 = (DirectPosition)dp.get(1);
            return new ReferencedEnvelope(dp1.getOrdinate(0), dp2.getOrdinate(0), dp1.getOrdinate(1), dp2.getOrdinate(1), crs);
        }
        if (node.hasChild(CoordinateSequence.class)) {
            CoordinateSequence seq = (CoordinateSequence)node.getChildValue(CoordinateSequence.class);
            return new ReferencedEnvelope(seq.getX(0), seq.getX(1), seq.getY(0), seq.getY(1), crs);
        }
        return null;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        Envelope envelope = (Envelope)object;
        if (envelope.isNull()) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    public Object getProperty(Object object, QName name) {
        Envelope envelope = (Envelope)object;
        if (envelope.isNull()) {
            return null;
        }
        if (name.getLocalPart().equals("lowerCorner")) {
            return new LiteCoordinateSequence(new double[]{envelope.getMinX(), envelope.getMinY()}, 2);
        }
        if (name.getLocalPart().equals("upperCorner")) {
            return new LiteCoordinateSequence(new double[]{envelope.getMaxX(), envelope.getMaxY()}, 2);
        }
        if (envelope instanceof ReferencedEnvelope) {
            CoordinateReferenceSystem crs;
            String localName = name.getLocalPart();
            if (localName.equals("srsName")) {
                return GML3EncodingUtils.toURI(((ReferencedEnvelope)envelope).getCoordinateReferenceSystem());
            }
            if (localName.equals("srsDimension") && (crs = ((ReferencedEnvelope)envelope).getCoordinateReferenceSystem()) != null) {
                return crs.getCoordinateSystem().getDimension();
            }
        }
        return null;
    }
}

