/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.caches.SensitiveAreaDAO$;
import au.org.ala.biocache.caches.TaxonProfileDAO$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Feet$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Location;
import au.org.ala.biocache.model.MeasurementUnit;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.TaxonProfile;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.parser.DistanceRangeParser$;
import au.org.ala.biocache.parser.VerbatimLatLongParser$;
import au.org.ala.biocache.poso.POSO;
import au.org.ala.biocache.processor.LocationProcessor$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.BBox;
import au.org.ala.biocache.vocab.Countries$;
import au.org.ala.biocache.vocab.CountryCentrePoints$;
import au.org.ala.biocache.vocab.HabitatMap$;
import au.org.ala.biocache.vocab.LatLng;
import au.org.ala.biocache.vocab.StateProvinceCentrePoints$;
import au.org.ala.biocache.vocab.StateProvinceToCountry$;
import au.org.ala.biocache.vocab.StateProvinces$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.sds.SensitiveDataService;
import au.org.ala.sds.model.Message;
import au.org.ala.sds.util.GeoLocationHelper;
import au.org.ala.sds.validation.ValidationOutcome;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math3.util.Precision;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tmb\u0001B\u0001\u0003\u00015\u0011\u0011\u0003T8dCRLwN\u001c)s_\u000e,7o]8s\u0015\t\u0019A!A\u0005qe>\u001cWm]:pe*\u0011QAB\u0001\tE&|7-Y2iK*\u0011q\u0001C\u0001\u0004C2\f'BA\u0005\u000b\u0003\ry'o\u001a\u0006\u0002\u0017\u0005\u0011\u0011-^\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0003)s_\u000e,7o]8s\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001b\u0001\n\u0003q\u0012A\u00027pO\u001e,'/F\u0001 !\t\u0001C%D\u0001\"\u0015\t\u00113%A\u0003tY\u001a$$NC\u0001\n\u0013\t)\u0013E\u0001\u0004M_\u001e<WM\u001d\u0005\u0007O\u0001\u0001\u000b\u0011B\u0010\u0002\u000f1|wmZ3sA!9\u0011\u0006\u0001b\u0001\n\u0003Q\u0013aD,H'b\"t,\u0012)T\u000f~\u001bu\u000eZ3\u0016\u0003-\u0002\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t1\fgn\u001a\u0006\u0002a\u0005!!.\u0019<b\u0013\t\u0011TF\u0001\u0004TiJLgn\u001a\u0005\u0007i\u0001\u0001\u000b\u0011B\u0016\u0002!];5\u000b\u000f\u001b`\u000bB\u001bviX\"pI\u0016\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u0004g\u0012\u001cX#\u0001\u001d\u0011\u0005eZT\"\u0001\u001e\u000b\u0005Y2\u0011B\u0001\u001f;\u0005Q\u0019VM\\:ji&4X\rR1uCN+'O^5dK\"1a\b\u0001Q\u0001\na\nAa\u001d3tA!A\u0001\t\u0001EC\u0002\u0013\u0005\u0011)A\bdeN,\u0005o]4D_\u0012,7/T1q+\u0005\u0011\u0005\u0003B\"I\u0015*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001d\u0003\u0012AC2pY2,7\r^5p]&\u0011\u0011\n\u0012\u0002\u0004\u001b\u0006\u0004\bCA&O\u001d\tyA*\u0003\u0002N!\u00051\u0001K]3eK\u001aL!AM(\u000b\u00055\u0003\u0002\u0002C)\u0001\u0011\u0003\u0005\u000b\u0015\u0002\"\u0002!\r\u00148/\u00129tO\u000e{G-Z:NCB\u0004\u0003\u0002C*\u0001\u0011\u000b\u0007I\u0011A!\u0002!i|g.Z#qg\u001e\u001cu\u000eZ3t\u001b\u0006\u0004\b\u0002C+\u0001\u0011\u0003\u0005\u000b\u0015\u0002\"\u0002#i|g.Z#qg\u001e\u001cu\u000eZ3t\u001b\u0006\u0004\b\u0005C\u0003X\u0001\u0011\u0005\u0001,A\u0004qe>\u001cWm]:\u0015\u000be\u0013G-[6\u0011\u0007=QF,\u0003\u0002\\!\t)\u0011I\u001d:bsB\u0011Q\fY\u0007\u0002=*\u0011q\fB\u0001\u0006[>$W\r\\\u0005\u0003Cz\u0013\u0001#U;bY&$\u00180Q:tKJ$\u0018n\u001c8\t\u000b\r4\u0006\u0019\u0001&\u0002\t\u001d,\u0018\u000e\u001a\u0005\u0006KZ\u0003\rAZ\u0001\u0004e\u0006<\bCA/h\u0013\tAgL\u0001\u0006Gk2d'+Z2pe\u0012DQA\u001b,A\u0002\u0019\f\u0011\u0002\u001d:pG\u0016\u001c8/\u001a3\t\u000f14\u0006\u0013!a\u0001[\u0006iA.Y:u!J|7-Z:tK\u0012\u00042a\u00048g\u0013\ty\u0007C\u0001\u0004PaRLwN\u001c\u0005\u0006c\u0002!IA]\u0001\u0011aJ|7-Z:t\u0019>\u001c\u0017\r^5p]N$Ba\u001d<xqB\u0011q\u0002^\u0005\u0003kB\u0011A!\u00168ji\")Q\r\u001da\u0001M\")!\u000e\u001da\u0001M\")\u0011\u0010\u001da\u0001u\u0006Q\u0011m]:feRLwN\\:\u0011\u0007mtH,D\u0001}\u0015\tih)A\u0004nkR\f'\r\\3\n\u0005}d(aC!se\u0006L()\u001e4gKJDq!a\u0001\u0001\t\u0003\t)!A\nwC2LG-\u0019;f\u0007>|'\u000fZ5oCR,7\u000fF\u0004t\u0003\u000f\tI!a\u0003\t\r\u0015\f\t\u00011\u0001g\u0011\u0019Q\u0017\u0011\u0001a\u0001M\"1\u00110!\u0001A\u0002iDq!a\u0004\u0001\t\u0013\t\t\"A\fqe>\u001cWm]:BYRLG/\u001e3f\u0003:$G)\u001a9uQRI1/a\u0005\u0002\u0016\u0005]\u0011\u0011\u0004\u0005\u0007G\u00065\u0001\u0019\u0001&\t\r\u0015\fi\u00011\u0001g\u0011\u0019Q\u0017Q\u0002a\u0001M\"1\u00110!\u0004A\u0002iDq!!\b\u0001\t\u0013\ty\"\u0001\nqe>\u001cWm]:NS:l\u0015\r\u001f#faRDGcB:\u0002\"\u0005\r\u0012Q\u0005\u0005\u0007K\u0006m\u0001\u0019\u00014\t\r)\fY\u00021\u0001g\u0011\u0019I\u00181\u0004a\u0001u\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012\u0001\u00079s_\u000e,7o\u001d,fe\n\fG/[7FY\u00164\u0018\r^5p]R91/!\f\u00020\u0005E\u0002BB3\u0002(\u0001\u0007a\r\u0003\u0004k\u0003O\u0001\rA\u001a\u0005\u0007s\u0006\u001d\u0002\u0019\u0001>\t\u000f\u0005U\u0002\u0001\"\u0003\u00028\u0005!\u0002O]8dKN\u001ch+\u001a:cCRLW\u000eR3qi\"$ra]A\u001d\u0003w\ti\u0004\u0003\u0004f\u0003g\u0001\rA\u001a\u0005\u0007U\u0006M\u0002\u0019\u00014\t\re\f\u0019\u00041\u0001{\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\nqc]3u!J|7-Z:tK\u0012\u001cun\u001c:eS:\fG/Z:\u0015\u000fM\f)%a\u0012\u0002J!1Q-a\u0010A\u0002\u0019DaA[A \u0001\u00041\u0007BB=\u0002@\u0001\u0007!\u0010C\u0004\u0002N\u0001!\t!a\u0014\u0002\u001dA\u0014xnY3tg2\u000bG\u000fT8oOR1\u0012\u0011KA-\u0003;\n\t'!\u001a\u0002j\u00055\u0014\u0011OA;\u0003s\ni\b\u0005\u0003\u0010]\u0006M\u0003CB\b\u0002V)S%*C\u0002\u0002XA\u0011a\u0001V;qY\u0016\u001c\u0004bBA.\u0003\u0017\u0002\rAS\u0001\fe\u0006<H*\u0019;jiV$W\rC\u0004\u0002`\u0005-\u0003\u0019\u0001&\u0002\u0019I\fw\u000fT8oO&$X\u000fZ3\t\u000f\u0005\r\u00141\na\u0001\u0015\u0006\u0001\"/Y<HK>$W\r^5d\t\u0006$X/\u001c\u0005\b\u0003O\nY\u00051\u0001K\u0003A1XM\u001d2bi&lG*\u0019;jiV$W\rC\u0004\u0002l\u0005-\u0003\u0019\u0001&\u0002#Y,'OY1uS6duN\\4jiV$W\rC\u0004\u0002p\u0005-\u0003\u0019\u0001&\u0002\u0017Y,'OY1uS6\u001c&k\u0015\u0005\b\u0003g\nY\u00051\u0001K\u0003\u001d)\u0017m\u001d;j]\u001eDq!a\u001e\u0002L\u0001\u0007!*\u0001\u0005o_J$\b.\u001b8h\u0011\u001d\tY(a\u0013A\u0002)\u000bAA_8oK\"1\u00110a\u0013A\u0002iDq!!!\u0001\t\u0013\t\u0019)A\u000esKB\u0014xN[3di\u000e{wN\u001d3j]\u0006$Xm\u001d+p/\u001e\u001b\u0006\b\u000e\u000b\u000b\u0003\u000b\u000bi)a&\u0002\u001c\u0006}\u0005\u0003B\bo\u0003\u000f\u0003RaDAE\u0015*K1!a#\u0011\u0005\u0019!V\u000f\u001d7fe!A\u0011qRA@\u0001\u0004\t\t*A\u0006d_>\u0014H-\u001b8bi\u0016\f\u0004cA\b\u0002\u0014&\u0019\u0011Q\u0013\t\u0003\r\u0011{WO\u00197f\u0011!\tI*a A\u0002\u0005E\u0015aC2p_J$\u0017N\\1uKJBq!!(\u0002\u0000\u0001\u0007!*A\tt_V\u00148-Z\"sg\u0016\u00038oZ\"pI\u0016D\u0001\"!)\u0002\u0000\u0001\u0007\u00111U\u0001\u0017I\u0016\u001c\u0017.\\1m!2\f7-Z:U_J{WO\u001c3U_B\u0019q\"!*\n\u0007\u0005\u001d\u0006CA\u0002J]RDq!a+\u0001\t\u0003\ti+\u0001\u0011hKRtU/\u001c2fe>3G)Z2j[\u0006d\u0007\u000b\\1dKNLe\u000eR8vE2,G\u0003BAR\u0003_Cq!!-\u0002*\u0002\u0007!*A\beK\u000eLW.\u00197BgN#(/\u001b8h\u0011\u001d\t)\f\u0001C\u0005\u0003o\u000ba\u0002\\8pWV\u0004X\t]:h\u0007>$W\r\u0006\u0003\u0002:\u0006m\u0006cA\bo\u0015\"9\u0011QXAZ\u0001\u0004Q\u0015aA2sg\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0017AG2iK\u000e\\7i\\8sI&t\u0017\r^3V]\u000e,'\u000f^1j]RLHcB:\u0002F\u0006\u001d\u0017\u0011\u001a\u0005\u0007K\u0006}\u0006\u0019\u00014\t\r)\fy\f1\u0001g\u0011\u0019I\u0018q\u0018a\u0001u\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0017aF2iK\u000e\\gi\u001c:IC\nLG/\u0019;NSNl\u0017\r^2i)\u001d\u0019\u0018\u0011[Aj\u0003+Da!ZAf\u0001\u00041\u0007B\u00026\u0002L\u0002\u0007a\r\u0003\u0004z\u0003\u0017\u0004\rA\u001f\u0005\b\u00033\u0004A\u0011AAn\u0003U\tG\rZ\"p]N,'O^1uS>t7\u000b^1ukN$Ra]Ao\u0003?Da!ZAl\u0001\u00041\u0007B\u00026\u0002X\u0002\u0007a\rC\u0004\u0002d\u0002!\t!!:\u0002+\rDWmY6G_J\u001cF/\u0019;f\u001b&\u001cX.\u0019;dQR91/a:\u0002j\u0006-\bBB3\u0002b\u0002\u0007a\r\u0003\u0004k\u0003C\u0004\rA\u001a\u0005\u0007s\u0006\u0005\b\u0019\u0001>\t\u000f\u0005=\b\u0001\"\u0001\u0002r\u0006Qb/\u00197jI\u0006$XmR3pe\u00164WM]3oG\u00164\u0016\r\\;fgR9!0a=\u0002v\u0006]\bBB3\u0002n\u0002\u0007a\r\u0003\u0004k\u0003[\u0004\rA\u001a\u0005\u0007s\u00065\b\u0019\u0001>\t\u000f\u0005m\b\u0001\"\u0001\u0002~\u0006Ib/\u00197jI\u0006$XmQ8pe\u0012Lg.\u0019;fgZ\u000bG.^3t)!\tyP!\u0002\u0003\b\t%\u0001cA\b\u0003\u0002%\u0019!1\u0001\t\u0003\u0007\u0005s\u0017\u0010\u0003\u0004f\u0003s\u0004\rA\u001a\u0005\u0007U\u0006e\b\u0019\u00014\t\re\fI\u00101\u0001{\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001f\t!\u0003\u001d:pG\u0016\u001c8oU3og&$\u0018N^5usR)1O!\u0005\u0003\u0014!1QMa\u0003A\u0002\u0019DaA\u001bB\u0006\u0001\u00041\u0007b\u0002B\f\u0001\u0011\u0005!\u0011D\u0001\u0010O\u0016$X\t_1diN\u001b\u0017NT1nKR\u0019!Ja\u0007\t\r\u0015\u0014)\u00021\u0001g\u0011\u0019\u0011y\u0002\u0001C\u0001U\u00059q-\u001a;OC6,\u0007\"\u0003B\u0012\u0001E\u0005I\u0011\tB\u0013\u0003E\u0001(o\\2fgN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005OQ3!\u001cB\u0015W\t\u0011Y\u0003\u0005\u0003\u0003.\t]RB\u0001B\u0018\u0015\u0011\u0011\tDa\r\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001b!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te\"q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LocationProcessor
implements Processor {
    private final Logger logger;
    private final String WGS84_EPSG_Code;
    private final SensitiveDataService sds;
    private scala.collection.immutable.Map<String, String> crsEpsgCodesMap;
    private scala.collection.immutable.Map<String, String> zoneEpsgCodesMap;
    private volatile byte bitmap$0;

    private scala.collection.immutable.Map crsEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/crsEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$1;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$1.elem = ((scala.collection.immutable.Map)this.valuesMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$1 = valuesMap$1;
                    }
                });
                this.crsEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.crsEpsgCodesMap;
        }
    }

    private scala.collection.immutable.Map zoneEpsgCodesMap$lzycompute() {
        LocationProcessor locationProcessor = this;
        synchronized (locationProcessor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                ObjectRef valuesMap = new ObjectRef((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                Source$.MODULE$.fromURL(this.getClass().getResource("/zoneEpsgCodes.txt"), "utf-8").getLines().toList().foreach((Function1)new Serializable(this, valuesMap){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef valuesMap$2;

                    public final void apply(String line) {
                        String[] values = new StringOps(Predef$.MODULE$.augmentString(line)).split('=');
                        this.valuesMap$2.elem = ((scala.collection.immutable.Map)this.valuesMap$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)values[0]), (Object)values[1]));
                    }
                    {
                        this.valuesMap$2 = valuesMap$2;
                    }
                });
                this.zoneEpsgCodesMap = (scala.collection.immutable.Map)valuesMap.elem;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.zoneEpsgCodesMap;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public String WGS84_EPSG_Code() {
        return this.WGS84_EPSG_Code;
    }

    public SensitiveDataService sds() {
        return this.sds;
    }

    public scala.collection.immutable.Map<String, String> crsEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.crsEpsgCodesMap$lzycompute() : this.crsEpsgCodesMap;
    }

    public scala.collection.immutable.Map<String, String> zoneEpsgCodesMap() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.zoneEpsgCodesMap$lzycompute() : this.zoneEpsgCodesMap;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        Tuple3 tuple3;
        block7: {
            ArrayBuffer assertions;
            block6: {
                Tuple3 tuple32;
                Option<Tuple3<Location, scala.collection.immutable.Map<String, String>, scala.collection.immutable.Map<String, String>>> point;
                this.logger().debug(new StringBuilder().append((Object)"Processing location for guid: ").append((Object)guid).toString());
                assertions = new ArrayBuffer();
                this.setProcessedCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                this.processAltitudeAndDepth(guid, raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                if (processed.location().decimalLatitude() != null && processed.location().decimalLongitude() != null) {
                    this.validateCoordinatesValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    this.checkCoordinateUncertainty(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                }
                if (Config$.MODULE$.sdsEnabled()) {
                    this.processSensitivity(raw, processed);
                }
                if (processed.location().decimalLatitude() != null && processed.location().decimalLongitude() != null) {
                    scala.collection.immutable.Map<String, String> intersectValues = SensitiveAreaDAO$.MODULE$.intersect(processed.location().decimalLongitude(), processed.location().decimalLatitude());
                    processed.location().stateProvince_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.stateProvinceLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().lga_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.localGovLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().country_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.countriesLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }));
                    processed.location().habitat_$eq((String)(intersectValues.getOrElse((Object)Config$.MODULE$.terrestrialLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }) == null ? (intersectValues.getOrElse((Object)Config$.MODULE$.marineLayerID(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }) == null ? null : "Marine") : "Terrestrial"));
                    this.checkForStateMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    this.addConservationStatus(raw, processed);
                    this.checkForHabitatMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
                }
                if ((point = LocationDAO$.MODULE$.getByLatLon(processed.location().decimalLatitude(), processed.location().decimalLongitude())).isEmpty()) break block6;
                tuple3 = (Tuple3)point.get();
                if (tuple3 == null) break block7;
                Location location = (Location)tuple3._1();
                scala.collection.immutable.Map environmentalLayers = (scala.collection.immutable.Map)tuple3._2();
                scala.collection.immutable.Map contextualLayers = (scala.collection.immutable.Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)location, (Object)environmentalLayers, (Object)contextualLayers);
                Location location2 = (Location)tuple33._1();
                scala.collection.immutable.Map environmentalLayers2 = (scala.collection.immutable.Map)tuple33._2();
                scala.collection.immutable.Map contextualLayers2 = (scala.collection.immutable.Map)tuple33._3();
                processed.locationDetermined_$eq(true);
                processed.el_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)environmentalLayers2));
                processed.cl_$eq(JavaConversions$.MODULE$.mapAsJavaMap((Map)contextualLayers2));
            }
            ArrayBuffer arrayBuffer = processed.location().decimalLatitude() == null || processed.location().decimalLongitude() == null ? (raw.location().footprintWKT() == null && raw.location().locality() == null && raw.location().locationID() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), 1))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), 1));
            this.validateCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.processLocations(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.validateGeoreferenceValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
        }
        throw new MatchError((Object)tuple3);
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    private void processLocations(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Option<Term> countryCodeTerm;
        Option<Term> countryTerm;
        Option<Term> stateTerm;
        if (processed.location().stateProvince() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty()) {
            processed.location().stateProvince_$eq(((Term)stateTerm.get()).canonical());
            if (Config$.MODULE$.sdsEnabled()) {
                this.processSensitivity(raw, processed);
            }
            processed.location().country_$eq((String)StateProvinceToCountry$.MODULE$.map().getOrElse((Object)processed.location().stateProvince(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
        }
        if (processed.location().country() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(countryTerm = Countries$.MODULE$.matchTerm(raw.location().country())).isEmpty()) {
            processed.location().country_$eq(((Term)countryTerm.get()).canonical());
        }
        if (processed.location().country() == null && raw.location().countryCode() != null && !(countryCodeTerm = Countries$.MODULE$.matchTerm(raw.location().countryCode())).isEmpty()) {
            processed.location().country_$eq(((Term)countryCodeTerm.get()).canonical());
        }
    }

    public void validateCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().country() == null && processed.location().country() != null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), 0)) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), 1));
        ArrayBuffer arrayBuffer2 = StateProvinceCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().stateProvince(), raw.location().decimalLatitude(), raw.location().decimalLongitude()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().stateProvince()).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), 1));
        if (CountryCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().country(), raw.location().decimalLatitude(), raw.location().decimalLongitude())) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().country()).toString()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), 1));
        }
    }

    private void processAltitudeAndDepth(String guid, FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        this.processVerbatimDepth(raw, processed, assertions);
        this.processVerbatimElevation(raw, processed, assertions);
        this.processMinMaxDepth(raw, processed, assertions);
    }

    private void processMinMaxDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        if (raw.location().minimumDepthInMeters() == null || raw.location().maximumDepthInMeters() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumDepthInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumDepthInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", depths have been transposed.").toString()));
                } else {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), 1));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing minimumDepthInMeters:").append((Object)exception.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (raw.location().minimumElevationInMeters() != null && raw.location().maximumElevationInMeters() != null) {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumElevationInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumElevationInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), new StringBuilder().append((Object)"The minimum, ").append((Object)BoxesRunTime.boxToFloat((float)min)).append((Object)", and maximum, ").append((Object)BoxesRunTime.boxToFloat((float)max)).append((Object)", elevations have been transposed.").toString()));
                } else {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), 1));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing elevation:").append((Object)exception.getMessage()).toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimElevation(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimElevation() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseElevationResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimElevation());
        if (parseElevationResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseElevationResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float velevation = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)velevation), (Object)sourceUnit);
            float velevation2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimElevation_$eq(((Object)BoxesRunTime.boxToFloat((float)velevation2)).toString());
            ArrayBuffer arrayBuffer = velevation2 > (float)10000 || velevation2 < (float)-100 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), new StringBuilder().append((Object)"Elevation ").append((Object)BoxesRunTime.boxToFloat((float)velevation2)).append((Object)" is greater than 10,000 metres or less than -100 metres.").toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), 1));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), 1));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), "The supplied altitude was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), 1));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimElevation ").append((Object)raw.location().verbatimElevation()).toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimDepth() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseDepthResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimDepth());
        if (parseDepthResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseDepthResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float vdepth = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)vdepth), (Object)sourceUnit);
            float vdepth2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimDepth_$eq(((Object)BoxesRunTime.boxToFloat((float)vdepth2)).toString());
            ArrayBuffer arrayBuffer = vdepth2 > (float)10000 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), new StringBuilder().append((Object)"Depth ").append((Object)BoxesRunTime.boxToFloat((float)vdepth2)).append((Object)" is greater than 10,000 metres").toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), 1));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), 1));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), "The supplied depth was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), 1));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimDepth ").append((Object)raw.location().verbatimDepth()).toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProcessedCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().originalDecimalLatitude() == null || raw.location().originalDecimalLongitude() == null) {
            Tuple3 tuple3;
            Tuple3 tuple32 = (Tuple3)this.processLatLong(raw.location().decimalLatitude(), raw.location().decimalLongitude(), raw.location().geodeticDatum(), raw.location().verbatimLatitude(), raw.location().verbatimLongitude(), raw.location().verbatimSRS(), raw.location().easting(), raw.location().northing(), raw.location().zone(), assertions).getOrElse((Function0)new $anonfun$2(this));
            if (tuple32 == null) throw new MatchError((Object)tuple32);
            String y = (String)tuple32._1();
            String x = (String)tuple32._2();
            String geodeticDatum = (String)tuple32._3();
            Tuple3 tuple33 = tuple3 = new Tuple3((Object)y, (Object)x, (Object)geodeticDatum);
            String y2 = (String)tuple33._1();
            String x2 = (String)tuple33._2();
            String geodeticDatum2 = (String)tuple33._3();
            processed.location().decimalLatitude_$eq(y2);
            processed.location().decimalLongitude_$eq(x2);
            processed.location().geodeticDatum_$eq(geodeticDatum2);
            return;
        } else {
            processed.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            processed.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
            processed.location().verbatimLatitude_$eq(raw.location().originalVerbatimLatitude());
            processed.location().verbatimLongitude_$eq(raw.location().originalVerbatimLongitude());
            raw.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            raw.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple3<String, String, String>> processLatLong(String rawLatitude, String rawLongitude, String rawGeodeticDatum, String verbatimLatitude, String verbatimLongitude, String verbatimSRS, String easting, String northing, String zone, ArrayBuffer<QualityAssertion> assertions) {
        None$ none$;
        if (rawLatitude == null || rawLongitude == null || StringHelper$.MODULE$.string2helper(rawLatitude).toFloatWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(rawLongitude).toFloatWithOption().isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED()));
            if (verbatimLatitude == null || verbatimLongitude == null) {
                if (easting == null || northing == null || zone == null) {
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    String epsgCodeKey;
                    String string = epsgCodeKey = verbatimSRS == null ? new StringBuilder().append((Object)"GDA94|").append((Object)zone).toString() : new StringBuilder().append((Object)verbatimSRS.toUpperCase()).append((Object)"|").append((Object)zone).toString();
                    if (this.zoneEpsgCodesMap().contains((Object)epsgCodeKey)) {
                        String crsEpsgCode = (String)this.zoneEpsgCodesMap().apply((Object)epsgCodeKey);
                        Option<Object> eastingAsDouble = StringHelper$.MODULE$.string2helper(easting).toDoubleWithOption();
                        Option<Object> northingAsDouble = StringHelper$.MODULE$.string2helper(northing).toDoubleWithOption();
                        if (eastingAsDouble.isEmpty() || northingAsDouble.isEmpty()) {
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToDouble((Object)eastingAsDouble.get()), BoxesRunTime.unboxToDouble((Object)northingAsDouble.get()), crsEpsgCode, 5);
                            if (reprojectedCoords.isEmpty()) {
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), "Transformation of verbatim easting and northing to WGS84 failed"));
                                none$ = None$.MODULE$;
                                return none$;
                            } else {
                                Tuple2 tuple2;
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), 1));
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_EASTING_NORTHING(), "Decimal latitude and longitude were calculated using easting, northing and zone."));
                                Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                                if (tuple22 == null) throw new MatchError((Object)tuple22);
                                String reprojectedLatitude = (String)tuple22._1();
                                String reprojectedLongitude = (String)tuple22._2();
                                Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                                String reprojectedLatitude2 = (String)tuple23._1();
                                String reprojectedLongitude2 = (String)tuple23._2();
                                none$ = new Some((Object)new Tuple3((Object)reprojectedLatitude2, (Object)reprojectedLongitude2, (Object)this.WGS84_EPSG_Code()));
                            }
                        }
                        return none$;
                    } else {
                        ArrayBuffer arrayBuffer = verbatimSRS == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone GDA94 / MGA zone ").append((Object)zone).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_EASTING_NORTHING_FAILED(), new StringBuilder().append((Object)"Unrecognized zone ").append((Object)verbatimSRS).append((Object)" / zone ").append((Object)zone).toString()));
                        none$ = None$.MODULE$;
                    }
                }
                return none$;
            } else {
                Option<Object> decimalVerbatimLat = StringHelper$.MODULE$.string2helper(verbatimLatitude).toFloatWithOption();
                Option<Object> decimalVerbatimLong = StringHelper$.MODULE$.string2helper(verbatimLongitude).toFloatWithOption();
                if (decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty()) {
                    decimalVerbatimLat = VerbatimLatLongParser$.MODULE$.parse(verbatimLatitude);
                    decimalVerbatimLong = VerbatimLatLongParser$.MODULE$.parse(verbatimLongitude);
                }
                if (decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty()) {
                    none$ = None$.MODULE$;
                    return none$;
                } else if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
                    if (verbatimSRS == null) {
                        if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), 1));
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                            none$ = new Some((Object)new Tuple3((Object)decimalVerbatimLat.get().toString(), (Object)decimalVerbatimLong.get().toString(), (Object)this.WGS84_EPSG_Code()));
                            return none$;
                        } else {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Could not parse verbatim latitude and longitude"));
                            none$ = None$.MODULE$;
                        }
                        return none$;
                    } else {
                        Option<String> sourceEpsgCode = this.lookupEpsgCode(verbatimSRS);
                        if (sourceEpsgCode.isEmpty()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), new StringBuilder().append((Object)"Unrecognized verbatimSRS ").append((Object)verbatimSRS).toString()));
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), 1));
                            Object object = sourceEpsgCode.get();
                            String string = this.WGS84_EPSG_Code();
                            if (!(object != null ? !object.equals(string) : string != null)) {
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                                none$ = new Some((Object)new Tuple3((Object)decimalVerbatimLat.get().toString(), (Object)decimalVerbatimLong.get().toString(), (Object)this.WGS84_EPSG_Code()));
                                return none$;
                            } else {
                                int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLat.get().toString()), this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLong.get().toString()));
                                Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToFloat((Object)decimalVerbatimLat.get()), BoxesRunTime.unboxToFloat((Object)decimalVerbatimLong.get()), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                                if (reprojectedCoords.isEmpty()) {
                                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Transformation of verbatim latiude and longitude to WGS84 failed"));
                                    none$ = None$.MODULE$;
                                    return none$;
                                } else {
                                    Tuple2 tuple2;
                                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), 1));
                                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                                    Tuple2 tuple24 = (Tuple2)reprojectedCoords.get();
                                    if (tuple24 == null) throw new MatchError((Object)tuple24);
                                    String reprojectedLatitude = (String)tuple24._1();
                                    String reprojectedLongitude = (String)tuple24._2();
                                    Tuple2 tuple25 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                                    String reprojectedLatitude3 = (String)tuple25._1();
                                    String reprojectedLongitude3 = (String)tuple25._2();
                                    none$ = new Some((Object)new Tuple3((Object)reprojectedLatitude3, (Object)reprojectedLongitude3, (Object)this.WGS84_EPSG_Code()));
                                }
                            }
                        }
                    }
                    return none$;
                } else {
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED(), 1));
            if (rawGeodeticDatum == null) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), "Geodetic datum assumed to be WGS84 (EPSG:4326)"));
                none$ = new Some((Object)new Tuple3((Object)rawLatitude, (Object)rawLongitude, (Object)this.WGS84_EPSG_Code()));
                return none$;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), 1));
                Option<String> sourceEpsgCode = this.lookupEpsgCode(rawGeodeticDatum);
                if (sourceEpsgCode.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geodetic datum ", " not recognized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rawGeodeticDatum}))));
                    none$ = new Some((Object)new Tuple3((Object)rawLatitude, (Object)rawLongitude, (Object)rawGeodeticDatum));
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), 1));
                    Object object = sourceEpsgCode.get();
                    String string = this.WGS84_EPSG_Code();
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        none$ = new Some((Object)new Tuple3((Object)rawLatitude, (Object)rawLongitude, (Object)this.WGS84_EPSG_Code()));
                        return none$;
                    } else {
                        int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(rawLatitude), this.getNumberOfDecimalPlacesInDouble(rawLongitude));
                        Option<Tuple2<String, String>> reprojectedCoords = this.reprojectCoordinatesToWGS84(new StringOps(Predef$.MODULE$.augmentString(rawLatitude)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(rawLongitude)).toDouble(), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                        if (reprojectedCoords.isEmpty()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), "Transformation of decimal latiude and longitude to WGS84 failed"));
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            Tuple2 tuple2;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), 1));
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERTED(), "Decimal latitude and longitude were converted to WGS84 (EPSG:4326)"));
                            Tuple2 tuple26 = (Tuple2)reprojectedCoords.get();
                            if (tuple26 == null) throw new MatchError((Object)tuple26);
                            String reprojectedLatitude = (String)tuple26._1();
                            String reprojectedLongitude = (String)tuple26._2();
                            Tuple2 tuple27 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                            String reprojectedLatitude4 = (String)tuple27._1();
                            String reprojectedLongitude4 = (String)tuple27._2();
                            none$ = new Some((Object)new Tuple3((Object)reprojectedLatitude4, (Object)reprojectedLongitude4, (Object)this.WGS84_EPSG_Code()));
                        }
                    }
                }
            }
        }
        return none$;
    }

    private Option<Tuple2<String, String>> reprojectCoordinatesToWGS84(double coordinate1, double coordinate2, String sourceCrsEpsgCode, int decimalPlacesToRoundTo) {
        None$ none$;
        try {
            DefaultGeographicCRS wgs84CRS = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceCrsEpsgCode);
            CoordinateOperation transformOp = new DefaultCoordinateOperationFactory().createOperation(sourceCRS, (CoordinateReferenceSystem)wgs84CRS);
            GeneralDirectPosition directPosition = new GeneralDirectPosition(coordinate1, coordinate2);
            DirectPosition wgs84LatLong = transformOp.getMathTransform().transform((DirectPosition)directPosition, null);
            double longitude = wgs84LatLong.getOrdinate(0);
            double latitude = wgs84LatLong.getOrdinate(1);
            double roundedLongitude = Precision.round((double)longitude, (int)decimalPlacesToRoundTo);
            double roundedLatitude = Precision.round((double)latitude, (int)decimalPlacesToRoundTo);
            none$ = new Some((Object)new Tuple2((Object)((Object)BoxesRunTime.boxToDouble((double)roundedLatitude)).toString(), (Object)((Object)BoxesRunTime.boxToDouble((double)roundedLongitude)).toString()));
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getNumberOfDecimalPlacesInDouble(String decimalAsString) {
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString(decimalAsString)).split('.');
        return tokens.length == 2 ? tokens[1].length() : 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<String> lookupEpsgCode(String crs) {
        None$ none$;
        if (StringUtils.startsWithIgnoreCase((String)crs, (String)"EPSG:")) {
            try {
                CRS.decode((String)crs.toUpperCase());
                none$ = new Some((Object)crs.toUpperCase());
                return none$;
            }
            catch (Exception exception) {
                none$ = None$.MODULE$;
                return none$;
            }
        } else {
            if (this.crsEpsgCodesMap().contains((Object)crs.toUpperCase())) {
                none$ = new Some(this.crsEpsgCodesMap().apply((Object)crs.toUpperCase()));
                return none$;
            }
            none$ = None$.MODULE$;
            return none$;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCoordinateUncertainty(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer;
        BoxedUnit boxedUnit;
        boolean checkedPrecision = false;
        if (raw.location().coordinateUncertaintyInMeters() != null && raw.location().coordinateUncertaintyInMeters().length() > 0) {
            Option<Tuple2<Object, MeasurementUnit>> parsedResult = DistanceRangeParser$.MODULE$.parse(raw.location().coordinateUncertaintyInMeters());
            if (parsedResult.isEmpty()) {
                String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
            } else {
                ArrayBuffer arrayBuffer2;
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)parsedResult.get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                float parsedValue = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                MeasurementUnit rawUnit = (MeasurementUnit)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)parsedValue), (Object)rawUnit);
                float parsedValue2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                MeasurementUnit rawUnit2 = (MeasurementUnit)tuple23._2();
                if (parsedValue2 > 0.0f) {
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), 1));
                } else {
                    String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
                }
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)parsedValue2)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Option<Object> value;
            if (raw.location().coordinatePrecision() != null && !(value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption()).isEmpty() && BoxesRunTime.unboxToFloat((Object)value.get()) > 1.0f) {
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat((Object)value.get())))).toString());
                String comment = new StringBuilder().append((Object)"Supplied precision, ").append((Object)raw.location().coordinatePrecision()).append((Object)", is assumed to be uncertainty in metres").toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_IN_PRECISION(), comment));
                checkedPrecision = true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (raw.location().coordinatePrecision() == null) {
            arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), "Missing coordinatePrecision"));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), 1));
            if (checkedPrecision) {
                arrayBuffer = BoxedUnit.UNIT;
            } else {
                Option<Object> value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption();
                if (value.isDefined()) {
                    if (BoxesRunTime.unboxToFloat((Object)value.get()) > 0.0f && BoxesRunTime.unboxToFloat((Object)value.get()) <= 1.0f) {
                        int lonp;
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), 1));
                        int pre = raw.location().coordinatePrecision().contains(".") ? raw.location().coordinatePrecision().split("\\.")[1].length() : 0;
                        String lat2 = processed.location().decimalLatitude();
                        String string = processed.location().decimalLongitude();
                        int latp = lat2.contains(".") ? lat2.split("\\.")[1].length() : 0;
                        int n = lonp = string.contains(".") ? string.split("\\.")[1].length() : 0;
                        arrayBuffer = pre == latp && pre == lonp ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH(), 1)) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH()));
                    } else {
                        arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Coordinate precision is not between 0 and 1"));
                    }
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Unable to parse the coordinate precision"));
                }
            }
        }
        if (processed.location().coordinateUncertaintyInMeters() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), "Uncertainty was not supplied"));
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), 1));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkForHabitatMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        block9: {
            block8: {
                if (processed.location().habitat() == null) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), 2));
                    return;
                }
                taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
                genusProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().genusID());
                if (taxonProfileWithOption.isEmpty()) break block8;
                if (((TaxonProfile)taxonProfileWithOption.get()).habitats() == null || Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)taxonProfileWithOption.get()).habitats()).isEmpty()) break block8;
                v0 = ((TaxonProfile)taxonProfileWithOption.get()).habitats();
                break block9;
            }
            if (genusProfileWithOption.isEmpty()) ** GOTO lbl-1000
            if (((TaxonProfile)genusProfileWithOption.get()).habitats() != null && !Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)genusProfileWithOption.get()).habitats()).isEmpty()) {
                v0 = ((TaxonProfile)genusProfileWithOption.get()).habitats();
            } else lbl-1000:
            // 2 sources

            {
                v0 = habitats = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
        }
        if (Predef$.MODULE$.refArrayOps((Object[])habitats).isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), 2));
        } else {
            habitatsAsString = Predef$.MODULE$.refArrayOps((Object[])habitats).mkString(",");
            habitatFromPoint = processed.location().habitat();
            validHabitat = HabitatMap$.MODULE$.areTermsCompatible(habitatFromPoint, habitatsForSpecies = habitats);
            if (!validHabitat.isEmpty()) {
                if (BoxesRunTime.unboxToBoolean((Object)validHabitat.get())) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), 1));
                } else {
                    this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ******** Habitats incompatible for ROWKEY: ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().habitat()).append((Object)", retrieved:").append((Object)habitatsAsString).append((Object)", http://maps.google.com/?ll=").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString());
                    comment = new StringBuilder().append((Object)"Recognised habitats for species: ").append((Object)habitatsAsString).append((Object)", Value determined from coordinates: ").append((Object)habitatFromPoint).toString();
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), comment));
                }
            }
        }
    }

    public void addConservationStatus(FullRecord raw, FullRecord processed) {
        Option<TaxonProfile> taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
        if (!taxonProfileWithOption.isEmpty()) {
            TaxonProfile taxonProfile = (TaxonProfile)taxonProfileWithOption.get();
            if (taxonProfile.conservation() != null) {
                Option<String> country = taxonProfile.retrieveConservationStatus(processed.location().country());
                processed.occurrence().countryConservation_$eq((String)country.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> state = taxonProfile.retrieveConservationStatus(processed.location().stateProvince());
                processed.occurrence().stateConservation_$eq((String)state.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> global = taxonProfile.retrieveConservationStatus("Global");
                processed.occurrence().globalConservation_$eq((String)global.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
            }
        }
    }

    public void checkForStateMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (processed.location().stateProvince() == null || raw.location().stateProvince() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), 2));
        } else {
            Option<Term> stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince());
            if (stateTerm.isEmpty() || processed.location().stateProvince().equalsIgnoreCase(((Term)stateTerm.get()).canonical())) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), 1));
            } else {
                this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().stateProvince()).append((Object)", raw:").append((Object)raw.location().stateProvince()).toString());
                String comment = new StringBuilder().append((Object)"Supplied: ").append((Object)((Term)stateTerm.get()).canonical()).append((Object)", calculated: ").append((Object)processed.location().stateProvince()).toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), comment));
            }
        }
    }

    public ArrayBuffer<QualityAssertion> validateGeoreferenceValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().geodeticDatum() == null && processed.location().geodeticDatum() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), "Missing geodeticDatum")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), 1));
        ArrayBuffer arrayBuffer2 = raw.location().georeferencedBy() == null && processed.location().georeferencedBy() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), "Missing georeferencedBy")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), 1));
        ArrayBuffer arrayBuffer3 = raw.location().georeferenceProtocol() == null && processed.location().georeferenceProtocol() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), "Missing georeferenceProtocol")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), 1));
        ArrayBuffer arrayBuffer4 = raw.location().georeferenceSources() == null && processed.location().georeferenceSources() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), "Missing georeferenceSources")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), 1));
        ArrayBuffer arrayBuffer5 = raw.location().georeferenceVerificationStatus() == null && processed.location().georeferenceVerificationStatus() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), "Missing georeferenceVerificationStatus")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), 1));
        return StringUtils.isBlank((String)raw.location().georeferencedDate()) && !raw.miscProperties().containsKey("georeferencedDate") ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE(), 1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object validateCoordinatesValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        Some some;
        Tuple2 tuple2;
        float lon2;
        float lat2;
        BoxedUnit boxedUnit2;
        block20: {
            block19: {
                ArrayBuffer arrayBuffer;
                ArrayBuffer arrayBuffer2;
                Option<Object> latWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toFloatWithOption();
                Option<Object> lonWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toFloatWithOption();
                if (latWithOption.isEmpty() || lonWithOption.isEmpty()) {
                    boxedUnit2 = BoxedUnit.UNIT;
                    return boxedUnit2;
                }
                lat2 = BoxesRunTime.unboxToFloat((Object)latWithOption.get());
                lon2 = BoxesRunTime.unboxToFloat((Object)lonWithOption.get());
                if (lat2 < (float)-90 || lat2 > (float)90 || lon2 < (float)-180 || lon2 > (float)180) {
                    if (lon2 >= (float)-90 && lon2 <= (float)90 && lat2 >= (float)-180 && lat2 <= (float)180) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), new StringBuilder().append((Object)"Assume that coordinates have been inverted. Original values: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        String tmp = processed.location().decimalLatitude();
                        processed.location().decimalLatitude_$eq(processed.location().decimalLongitude());
                        processed.location().decimalLongitude_$eq(tmp);
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), 1));
                    } else {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), new StringBuilder().append((Object)"Coordinates are out of range: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), 1));
                    }
                } else {
                    arrayBuffer2 = assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), 1), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), 1)}));
                }
                if (lat2 == 0.0f && lon2 == 0.0f) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), "Coordinates 0,0"));
                    processed.location().decimalLatitude_$eq(null);
                    processed.location().decimalLongitude_$eq(null);
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), 1));
                }
                ArrayBuffer arrayBuffer3 = lat2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), "Latitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), 1));
                ArrayBuffer arrayBuffer4 = lon2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), "Longitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), 1));
                if (raw.location().country() == null) break block19;
                String string = raw.location().country();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block20;
            }
            boxedUnit2 = BoxedUnit.UNIT;
            return boxedUnit2;
        }
        Option<Term> country = Countries$.MODULE$.matchTerm(raw.location().country());
        if (country.isEmpty()) {
            boxedUnit2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), new StringBuilder().append((Object)"Country name '").append((Object)raw.location().country()).append((Object)"' not recognised.").toString()));
            return boxedUnit2;
        }
        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), 1));
        Option<Tuple2<LatLng, BBox>> option = CountryCentrePoints$.MODULE$.matchName(((Term)country.get()).canonical());
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
            BoxedUnit boxedUnit3;
            BBox bbox = (BBox)tuple2._2();
            if (bbox.containsPoint(lat2, lon2)) {
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boolean hasCoordinateMismatch = true;
                if (bbox.containsPoint(lat2 * (float)-1, lon2)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LATITUDE(), new StringBuilder().append((Object)"Latitude seems to be negated. Original value:").append((Object)processed.location().decimalLatitude()).toString()));
                    processed.location().decimalLatitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lat2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                if (bbox.containsPoint(lat2, lon2 * (float)-1)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LONGITUDE(), new StringBuilder().append((Object)"Longitude seems to be negated. Original value: ").append((Object)processed.location().decimalLongitude()).toString()));
                    processed.location().decimalLongitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lon2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                boxedUnit3 = hasCoordinateMismatch ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH(), 1));
            }
            boxedUnit = boxedUnit3;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boxedUnit2 = boxedUnit;
        return boxedUnit2;
    }

    public void processSensitivity(FullRecord raw, FullRecord processed) {
        Object object;
        this.logger().debug("Starting SDS check");
        scala.collection.mutable.Map rawMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])raw.objectArray()).foreach((Function1)new Serializable(this, rawMap){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map rawMap$1;

            public final void apply(POSO poso) {
                scala.collection.immutable.Map<String, String> map = FullRecordMapper$.MODULE$.mapObjectToProperties(poso, Versions$.MODULE$.RAW());
                JavaConversions$.MODULE$.mutableMapAsJavaMap(this.rawMap$1).putAll(JavaConversions$.MODULE$.mapAsJavaMap(map));
            }
            {
                this.rawMap$1 = rawMap$1;
            }
        });
        if (StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toDoubleWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toDoubleWithOption().isEmpty()) {
            object = BoxedUnit.UNIT;
        } else {
            Option<Term> stringMatchState;
            scala.collection.immutable.Map<String, String> layerIntersect = SensitiveAreaDAO$.MODULE$.intersect(new StringOps(Predef$.MODULE$.augmentString(processed.location().decimalLongitude())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(processed.location().decimalLatitude())).toDouble());
            JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, rawMap, layerIntersect){
                public static final long serialVersionUID = 0L;
                private final scala.collection.mutable.Map rawMap$1;
                private final scala.collection.immutable.Map layerIntersect$1;

                public final Option<String> apply(String key) {
                    return this.rawMap$1.put((Object)key, this.layerIntersect$1.getOrElse((Object)key, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "n/a";
                        }
                    }));
                }
                {
                    this.rawMap$1 = rawMap$1;
                    this.layerIntersect$1 = layerIntersect$1;
                }
            });
            String intersectStateProvince = (String)layerIntersect.getOrElse((Object)Config$.MODULE$.stateProvinceLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            object = StringUtils.isBlank((String)intersectStateProvince) ? ((stringMatchState = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty() ? BoxedUnit.UNIT : rawMap.put((Object)"stateProvince", (Object)((Term)stringMatchState.get()).canonical())) : rawMap.put((Object)"stateProvince", (Object)intersectStateProvince);
        }
        if (processed.event().day() != null) {
            rawMap.update((Object)"day", (Object)processed.event().day());
        }
        if (processed.event().month() != null) {
            rawMap.update((Object)"month", (Object)processed.event().month());
        }
        if (processed.event().year() != null) {
            rawMap.update((Object)"year", (Object)processed.event().year());
        }
        String exact = this.getExactSciName(raw);
        ValidationOutcome outcome = this.sds().testMapDetails(Config$.MODULE$.sdsFinder(), JavaConversions$.MODULE$.mutableMapAsJavaMap(rawMap), exact, processed.classification().taxonConceptID());
        this.logger().debug(new StringBuilder().append((Object)"SDS outcome: ").append((Object)outcome).toString());
        if (outcome != null && outcome.isValid() && outcome.isSensitive()) {
            Object object2;
            if (outcome.getResult() == null) {
                if (!outcome.isLoadable() && Config$.MODULE$.obeySDSIsLoadable()) {
                    this.logger().warn(new StringBuilder().append((Object)"SDS isLoadable status is currently not being used. Would apply to: ").append((Object)processed.uuid()).toString());
                }
                object2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                scala.collection.mutable.Map map = JavaConversions$.MODULE$.mapAsScalaMap(outcome.getResult());
                scala.collection.mutable.Map stringMap = (scala.collection.mutable.Map)map.collect((PartialFunction)new Serializable(this, processed){
                    public static final long serialVersionUID = 0L;
                    private final FullRecord processed$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String key = (String)A1._1();
                            Object value = A1._2();
                            if (value != null) {
                                Tuple2 tuple2;
                                String string = key;
                                String string2 = "originalSensitiveValues";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    HashMap osv = (HashMap)value;
                                    Object object2 = this.processed$1.location().coordinateUncertaintyInMeters() == null ? BoxedUnit.UNIT : osv.put("coordinateUncertaintyInMeters.p", this.processed$1.location().coordinateUncertaintyInMeters());
                                    JavaConversions$.MODULE$.asScalaBuffer(GeoLocationHelper.getGeospatialLayers()).foreach((Function1)new Serializable(this, osv){
                                        public static final long serialVersionUID = 0L;
                                        private final HashMap osv$1;

                                        public final String apply(String key) {
                                            return (String)this.osv$1.remove(key);
                                        }
                                        {
                                            this.osv$1 = osv$1;
                                        }
                                    });
                                    String newv = Json$.MODULE$.toJSON(osv);
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)newv);
                                } else {
                                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value.toString());
                                }
                                object = tuple2;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, Object> x1) {
                        Object value;
                        Tuple2<String, Object> tuple2 = x1;
                        boolean bl = tuple2 != null && (value = tuple2._2()) != null;
                        return bl;
                    }
                    {
                        this.processed$1 = processed$1;
                    }
                }, Map$.MODULE$.canBuildFrom());
                Option uncertainty = stringMap.get((Object)"generalisationInMetres");
                if (uncertainty.isEmpty()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (StringUtils.isNotEmpty((String)((String)uncertainty.get()).toString())) {
                        float currentUncertainty = StringUtils.isNotEmpty((String)processed.location().coordinateUncertaintyInMeters()) ? Float.parseFloat(processed.location().coordinateUncertaintyInMeters()) : 0.0f;
                        float newUncertainty = currentUncertainty + (float)Integer.parseInt(((String)uncertainty.get()).toString());
                        processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)newUncertainty)).toString());
                    }
                    processed.location().decimalLatitude_$eq((String)stringMap.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    processed.location().decimalLongitude_$eq((String)stringMap.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }));
                    boxedUnit = stringMap.$minus$eq((Object)"generalisationInMetres");
                }
                processed.occurrence().informationWithheld_$eq((String)stringMap.getOrElse((Object)"informationWithheld", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                processed.occurrence().dataGeneralizations_$eq((String)stringMap.getOrElse((Object)"dataGeneralizations", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }));
                stringMap.$minus$eq((Object)"informationWithheld");
                stringMap.$minus$eq((Object)"dataGeneralizations");
                raw.event().day_$eq("");
                processed.event().day_$eq("");
                processed.event().eventDate_$eq("");
                object2 = StringUtils.isNotBlank((String)raw.rowKey()) ? Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)stringMap.toMap(Predef$.MODULE$.conforms())) : BoxedUnit.UNIT;
            }
            if (outcome.getReport().getMessages() != null) {
                ObjectRef infoMessage = new ObjectRef((Object)"");
                JavaConversions$.MODULE$.asScalaBuffer(outcome.getReport().getMessages()).foreach((Function1)new Serializable(this, infoMessage){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef infoMessage$1;

                    public final void apply(Message message) {
                        this.infoMessage$1.elem = new StringBuilder().append((Object)((String)this.infoMessage$1.elem)).append((Object)new StringBuilder().append((Object)message.getCategory()).append((Object)"\t").append((Object)message.getMessageText()).append((Object)"\n").toString()).toString();
                    }
                    {
                        this.infoMessage$1 = infoMessage$1;
                    }
                });
                processed.occurrence().informationWithheld_$eq((String)infoMessage.elem);
            }
        } else if (StringUtils.isNotBlank((String)raw.rowKey()) && raw.occurrence().originalSensitiveValues() != null && !raw.occurrence().originalSensitiveValues().isEmpty()) {
            Config$.MODULE$.persistenceManager().put(raw.rowKey(), "occ", (scala.collection.immutable.Map<String, String>)raw.occurrence().originalSensitiveValues().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"originalSensitiveValues"), (Object)"")));
        }
    }

    public String getExactSciName(FullRecord raw) {
        return raw.classification().scientificName() == null ? (raw.classification().subspecies() == null ? (raw.classification().species() == null ? (raw.classification().genus() == null ? (raw.classification().vernacularName() == null ? raw.classification().scientificName() : raw.classification().vernacularName()) : (raw.classification().specificEpithet() == null ? raw.classification().genus() : (raw.classification().infraspecificEpithet() == null ? new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).toString() : new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).append((Object)" ").append((Object)raw.classification().infraspecificEpithet()).toString()))) : raw.classification().species()) : raw.classification().subspecies()) : raw.classification().scientificName();
    }

    @Override
    public String getName() {
        return FullRecordMapper$.MODULE$.geospatialQa();
    }

    public LocationProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"LocationProcessor");
        this.WGS84_EPSG_Code = "EPSG:4326";
        this.sds = new SensitiveDataService();
    }
}

