/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.caches.AttributionDAO$;
import au.org.ala.biocache.caches.ClassificationDAO$;
import au.org.ala.biocache.caches.TaxonProfileDAO$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Attribution;
import au.org.ala.biocache.model.Classification;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.TaxonProfile;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.BiocacheConversions$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.DwC$;
import au.org.ala.biocache.vocab.Kingdoms$;
import au.org.ala.biocache.vocab.Term;
import au.org.ala.names.model.ErrorType;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.MetricsResultDTO;
import au.org.ala.names.model.NameSearchResult;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Null$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0001\u0003\u00015\u0011qc\u00117bgNLg-[2bi&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\r!\u0011!\u00039s_\u000e,7o]8s\u0015\t)a!\u0001\u0005cS>\u001c\u0017m\u00195f\u0015\t9\u0001\"A\u0002bY\u0006T!!\u0003\u0006\u0002\u0007=\u0014xMC\u0001\f\u0003\t\tWo\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002CA\u000b\u0001\u0011\u001di\u0002A1A\u0005\u0002y\ta\u0001\\8hO\u0016\u0014X#A\u0010\u0011\u0005\u0001\"S\"A\u0011\u000b\u0005\t\u001a\u0013!B:mMRR'\"A\u0005\n\u0005\u0015\n#A\u0002'pO\u001e,'\u000f\u0003\u0004(\u0001\u0001\u0006IaH\u0001\bY><w-\u001a:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0011#\u00194e\u0003Bt\u0017.\u00133f]RLg-[3s+\u0005Y\u0003C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003!i\u0017\r^2iS:<'B\u0001\u0019\u0011\u0003\u0011)H/\u001b7\n\u0005Ij#!\u0002*fO\u0016D\bB\u0002\u001b\u0001A\u0003%1&\u0001\nbM\u0012\f\u0005O\\5JI\u0016tG/\u001b4jKJ\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\tAK\u0001\u0010cV,7\u000f^5p]B\u000bG\u000f^3s]\"1\u0001\b\u0001Q\u0001\n-\n\u0001#];fgRLwN\u001c)biR,'O\u001c\u0011\t\u000fi\u0002!\u0019!C\u0001U\u0005Q\u0011M\u001a4QCR$XM\u001d8\t\rq\u0002\u0001\u0015!\u0003,\u0003-\tgM\u001a)biR,'O\u001c\u0011\t\u000fy\u0002!\u0019!C\u0001U\u0005I1M\u001a)biR,'O\u001c\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u0016\u0002\u0015\r4\u0007+\u0019;uKJt\u0007\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0006qCJ\u001cX\rS5oiN$\"\u0001R)\u0011\t\u0015C5J\u0014\b\u0003\u001f\u0019K!a\u0012\t\u0002\rA\u0013X\rZ3g\u0013\tI%JA\u0002NCBT!a\u0012\t\u0011\u0005\u0015c\u0015BA'K\u0005\u0019\u0019FO]5oOB\u0019QiT&\n\u0005AS%aA*fi\")!+\u0011a\u0001'\u0006QA/\u0019=p]\"Kg\u000e^:\u0011\u0007Qc6J\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001\fD\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0017\t\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0005\u0019&\u001cHO\u0003\u0002\\!!)\u0001\r\u0001C\u0001C\u0006a\u0011n]'bi\u000eDg+\u00197jIR\u0019!\r\u001b:\u0011\t=\u0019WmS\u0005\u0003IB\u0011a\u0001V;qY\u0016\u0014\u0004CA\bg\u0013\t9\u0007CA\u0004C_>dW-\u00198\t\u000b%|\u0006\u0019\u00016\u0002\u0005\rd\u0007CA6q\u001b\u0005a'BA7o\u0003\u0015iw\u000eZ3m\u0015\tyg!A\u0003oC6,7/\u0003\u0002rY\nQB*\u001b8oC\u0016\fgNU1oW\u000ec\u0017m]:jM&\u001c\u0017\r^5p]\")1o\u0018a\u0001\t\u00069\u0001.\u001b8u\u001b\u0006\u0004\b\"B;\u0001\t\u00031\u0018a\u00035bg\u000e{gN\u001a7jGR$B!Z<zw\")\u0001\u0010\u001ea\u0001\u0017\u0006!!/\u00198l\u0011\u0015QH\u000f1\u0001L\u0003\u0015!\u0018\r_8o\u0011\u0015\u0019H\u000f1\u0001E\u0011\u0015i\b\u0001\"\u0001\u007f\u0003EA\u0017m]'bi\u000eDGk\u001c#fM\u0006,H\u000e\u001e\u000b\u0007K~\f\t!a\u0001\t\u000bad\b\u0019A&\t\u000bid\b\u0019A&\t\u000f\u0005\u0015A\u00101\u0001\u0002\b\u0005q1\r\\1tg&4\u0017nY1uS>t\u0007\u0003BA\u0005\u0003\u001bi!!a\u0003\u000b\u00055$\u0011\u0002BA\b\u0003\u0017\u0011ab\u00117bgNLg-[2bi&|g\u000eC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002\u001bM,G/T1uG\"\u001cF/\u0019;t)!\t9\"!\b\u0002(\u0005E\u0002cA\b\u0002\u001a%\u0019\u00111\u0004\t\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003?\t\t\u00021\u0001\u0002\"\u0005Ya.Y7f\u001b\u0016$(/[2t!\rY\u00171E\u0005\u0004\u0003Ka'\u0001E'fiJL7m\u001d*fgVdG\u000f\u0012+P\u0011!\tI#!\u0005A\u0002\u0005-\u0012!\u00039s_\u000e,7o]3e!\u0011\tI!!\f\n\t\u0005=\u00121\u0002\u0002\u000b\rVdGNU3d_J$\u0007\u0002CA\u001a\u0003#\u0001\r!!\u000e\u0002\u0015\u0005\u001c8/\u001a:uS>t7\u000f\u0005\u0004\u00028\u0005\u0005\u0013QI\u0007\u0003\u0003sQA!a\u000f\u0002>\u00059Q.\u001e;bE2,'bAA !\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0013\u0011\b\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0002\n\u0005\u001d\u0013\u0002BA%\u0003\u0017\u0011\u0001#U;bY&$\u00180Q:tKJ$\u0018n\u001c8\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005\u0011B/Z:u'V\u0004\b\u000f\\5fIZ\u000bG.^3t)!\t9\"!\u0015\u0002V\u0005]\u0003\u0002CA*\u0003\u0017\u0002\r!a\u000b\u0002\u0007I\fw\u000f\u0003\u0005\u0002*\u0005-\u0003\u0019AA\u0016\u0011!\t\u0019$a\u0013A\u0002\u0005U\u0002bBA.\u0001\u0011\u0005\u0011QL\u0001\baJ|7-Z:t))\ty&!\u001a\u0002j\u0005-\u0014Q\u000e\t\u0006\u001f\u0005\u0005\u0014QI\u0005\u0004\u0003G\u0002\"!B!se\u0006L\bbBA4\u00033\u0002\raS\u0001\u0005OVLG\r\u0003\u0005\u0002T\u0005e\u0003\u0019AA\u0016\u0011!\tI#!\u0017A\u0002\u0005-\u0002BCA8\u00033\u0002\n\u00111\u0001\u0002r\u0005iA.Y:u!J|7-Z:tK\u0012\u0004RaDA:\u0003WI1!!\u001e\u0011\u0005\u0019y\u0005\u000f^5p]\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0014aB4fi:\u000bW.Z\u000b\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003mC:<'BAAD\u0003\u0011Q\u0017M^1\n\u00075\u000b\t\tC\u0005\u0002\u000e\u0002\t\n\u0011\"\u0011\u0002\u0010\u0006\t\u0002O]8dKN\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005E%\u0006BA9\u0003'[#!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?\u0003\u0012AC1o]>$\u0018\r^5p]&!\u00111UAM\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ClassificationProcessor
implements Processor {
    private final Logger logger;
    private final Regex afdApniIdentifier;
    private final Regex questionPattern;
    private final Regex affPattern;
    private final Regex cfPattern;

    public Logger logger() {
        return this.logger;
    }

    public Regex afdApniIdentifier() {
        return this.afdApniIdentifier;
    }

    public Regex questionPattern() {
        return this.questionPattern;
    }

    public Regex affPattern() {
        return this.affPattern;
    }

    public Regex cfPattern() {
        return this.cfPattern;
    }

    public Map<String, Set<String>> parseHints(List<String> taxonHints) {
        HashMap rankSciNames = new HashMap();
        List pairs = (List)taxonHints.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x) {
                return x.split(":");
            }
        }, List$.MODULE$.canBuildFrom());
        pairs.foreach((Function1)new Serializable(this, rankSciNames){
            public static final long serialVersionUID = 0L;
            private final HashMap rankSciNames$1;

            public final Option<Set<String>> apply(String[] pair) {
                Set values = (Set)this.rankSciNames$1.getOrElse((Object)pair[0], (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<String> apply() {
                        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                    }
                });
                return this.rankSciNames$1.put((Object)pair[0], (Object)values.$plus((Object)pair[1].trim().toLowerCase()));
            }
            {
                this.rankSciNames$1 = rankSciNames$1;
            }
        });
        return rankSciNames.toMap(Predef$.MODULE$.conforms());
    }

    public Tuple2<Object, String> isMatchValid(LinnaeanRankClassification cl, Map<String, Set<String>> hintMap) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Tuple2 tuple2;
            Object object = new Object();
            try {
                hintMap.keys().foreach((Function1)new Serializable(this, cl, hintMap, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ClassificationProcessor $outer;
                    private final LinnaeanRankClassification cl$1;
                    private final Map hintMap$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String rank) {
                        Tuple2 tuple2;
                        String string;
                        String string2 = string = rank;
                        if (!("kingdom" != null ? !"kingdom".equals(string2) : string2 != null)) {
                            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.hasConflict(rank, this.cl$1.getKingdom(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Kingdom:").append((Object)this.cl$1.getKingdom()).toString());
                        } else {
                            String string3 = string;
                            if (!("phylum" != null ? !"phylum".equals(string3) : string3 != null)) {
                                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.hasConflict(rank, this.cl$1.getPhylum(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Phylum:").append((Object)this.cl$1.getPhylum()).toString());
                            } else {
                                String string4 = string;
                                if (!("class" != null ? !"class".equals(string4) : string4 != null)) {
                                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.hasConflict(rank, this.cl$1.getKlass(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Class:").append((Object)this.cl$1.getKlass()).toString());
                                } else {
                                    String string5 = string;
                                    if (!("order" != null ? !"order".equals(string5) : string5 != null)) {
                                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.hasConflict(rank, this.cl$1.getOrder(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Order:").append((Object)this.cl$1.getOrder()).toString());
                                    } else {
                                        String string6 = string;
                                        tuple2 = !("family" != null ? !"family".equals(string6) : string6 != null) ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.hasConflict(rank, this.cl$1.getFamily(), (Map<String, Set<String>>)this.hintMap$1)), (Object)new StringBuilder().append((Object)"Family:").append((Object)this.cl$1.getFamily()).toString()) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)"");
                                    }
                                }
                            }
                        }
                        Tuple2 tuple22 = tuple2;
                        if (tuple22 != null) {
                            Tuple2 tuple23;
                            boolean conflict = tuple22._1$mcZ$sp();
                            String comment = (String)tuple22._2();
                            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)conflict), (Object)comment);
                            boolean conflict2 = tuple24._1$mcZ$sp();
                            String comment2 = (String)tuple24._2();
                            if (conflict2) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)comment2));
                            }
                            return;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cl$1 = cl$1;
                        this.hintMap$1 = hintMap$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                tuple2 = (Tuple2)nonLocalReturnControl2.value();
            }
            return tuple2;
        }
        throw nonLocalReturnControl2;
    }

    public boolean hasConflict(String rank, String taxon, Map<String, Set<String>> hintMap) {
        return taxon != null && !((SetLike)hintMap.get((Object)rank).get()).contains((Object)taxon.toLowerCase());
    }

    public boolean hasMatchToDefault(String rank, String taxon, Classification classification) {
        return taxon != null && taxon.equalsIgnoreCase((String)classification.getProperty(this.field$1(rank)).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    public void setMatchStats(MetricsResultDTO nameMetrics, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        processed.classification().nameParseType_$eq(nameMetrics.getNameType() == null ? "UNKNOWN" : nameMetrics.getNameType().toString());
        processed.classification().taxonomicIssue_$eq(nameMetrics.getErrors() == null ? (String[])((Object[])new String[]{"noIssue"}) : (String[])((TraversableOnce)JavaConversions$.MODULE$.asScalaSet(nameMetrics.getErrors()).toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ErrorType x$2) {
                return x$2.toString();
            }
        }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
        String string = processed.classification().nameParseType();
        String string2 = "blacklisted";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_SCIENTIFIC_NAME()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVALID_SCIENTIFIC_NAME(), 1));
        }
    }

    public void testSuppliedValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = StringUtils.isBlank((String)raw.classification().taxonRank()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_TAXONRANK(), "Missing taxonRank")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_TAXONRANK(), 1));
        ArrayBuffer arrayBuffer2 = StringUtils.isBlank((String)raw.classification().scientificName()) && StringUtils.isBlank((String)raw.classification().vernacularName()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_SUPPLIED(), "No scientificName or vernacularName has been supplied. Name match will be based on a constructed name.")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_SUPPLIED(), 1));
        if (StringUtils.isNotBlank((String)raw.classification().kingdom())) {
            Option<Term> matchedKingdom = Kingdoms$.MODULE$.matchTerm(raw.classification().kingdom());
            if (matchedKingdom.isDefined()) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_KINGDOM(), 1));
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_KINGDOM(), "The supplied kingdom is not recognised"));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        BoxedUnit boxedUnit;
        ArrayBuffer assertions = new ArrayBuffer();
        this.testSuppliedValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        try {
            MetricsResultDTO nameMetrics;
            if (processed.defaultValuesUsed()) {
                if (raw.classification().kingdom() == null && processed.classification().kingdom() != null) {
                    raw.classification().kingdom_$eq(processed.classification().kingdom());
                }
                if (raw.classification().phylum() == null && processed.classification().phylum() != null) {
                    raw.classification().phylum_$eq(processed.classification().phylum());
                }
                if (raw.classification().classs() == null && processed.classification().classs() != null) {
                    raw.classification().classs_$eq(processed.classification().classs());
                }
                if (raw.classification().order() == null && processed.classification().order() != null) {
                    raw.classification().order_$eq(processed.classification().order());
                }
                if (raw.classification().family() == null && processed.classification().family() != null) {
                    raw.classification().family_$eq(processed.classification().family());
                }
            }
            if ((nameMetrics = (MetricsResultDTO)ClassificationDAO$.MODULE$.getByHashLRU(raw.classification(), ClassificationDAO$.MODULE$.getByHashLRU$default$2()).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            })) == null) {
                this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] No match for record, classification for Kingdom: ").append((Object)raw.classification().kingdom()).append((Object)", Family:").append((Object)raw.classification().family()).append((Object)", Genus:").append((Object)raw.classification().genus()).append((Object)", Species: ").append((Object)raw.classification().species()).append((Object)", Epithet: ").append((Object)raw.classification().specificEpithet()).toString());
                processed.classification().nameMatchMetric_$eq("noMatch");
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOTRECOGNISED(), "Name not recognised"));
                return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
            } else {
                NameSearchResult nsr = nameMetrics.getResult();
                if (nsr == null) {
                    if (nameMetrics.getErrors().contains(ErrorType.HOMONYM)) {
                        this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] A homonym was detected (with  no higher level match), classification for Kingdom: ").append((Object)raw.classification().kingdom()).append((Object)", Family:").append((Object)raw.classification().family()).append((Object)", Genus:").append((Object)raw.classification().genus()).append((Object)", Species: ").append((Object)raw.classification().species()).append((Object)", Epithet: ").append((Object)raw.classification().specificEpithet()).toString());
                        processed.classification().nameMatchMetric_$eq("noMatch");
                        this.setMatchStats(nameMetrics, processed, (ArrayBuffer<QualityAssertion>)assertions);
                        boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.HOMONYM_ISSUE(), "A homonym was detected in supplied classificaiton."));
                        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
                    } else {
                        this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] No match for record, classification for Kingdom: ").append((Object)raw.classification().kingdom()).append((Object)", Family:").append((Object)raw.classification().family()).append((Object)", Genus:").append((Object)raw.classification().genus()).append((Object)", Species: ").append((Object)raw.classification().species()).append((Object)", Epithet: ").append((Object)raw.classification().specificEpithet()).toString());
                        processed.classification().nameMatchMetric_$eq("noMatch");
                        this.setMatchStats(nameMetrics, processed, (ArrayBuffer<QualityAssertion>)assertions);
                        boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOTRECOGNISED(), "Name not recognised"));
                    }
                    return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
                } else {
                    Option<TaxonProfile> taxonProfile;
                    boolean hasDefaultMatch;
                    Object object;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOTRECOGNISED(), 1));
                    LinnaeanRankClassification classification = nsr.getRankClassification();
                    Option<Attribution> attribution = AttributionDAO$.MODULE$.getByCodes(raw.occurrence().institutionCode(), raw.occurrence().collectionCode());
                    if (attribution.isEmpty()) {
                        attribution = AttributionDAO$.MODULE$.getDataResourceByUid(raw.attribution().dataResourceUid());
                    }
                    boolean hintsPassed = true;
                    if (attribution.isEmpty()) {
                        object = BoxedUnit.UNIT;
                    } else {
                        this.logger().debug("Checking taxonomic hints");
                        String[] taxonHints = ((Attribution)attribution.get()).taxonomicHints();
                        if (taxonHints != null && !Predef$.MODULE$.refArrayOps((Object[])taxonHints).isEmpty()) {
                            Tuple2 tuple2;
                            Tuple2<Object, String> tuple22 = this.isMatchValid(classification, ((Attribution)attribution.get()).retrieveParseHints());
                            if (tuple22 == null) throw new MatchError(tuple22);
                            boolean isValid = tuple22._1$mcZ$sp();
                            String comment = (String)tuple22._2();
                            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isValid), (Object)comment);
                            boolean isValid2 = tuple23._1$mcZ$sp();
                            String comment2 = (String)tuple23._2();
                            if (isValid2) {
                                object = ((Attribution)attribution.get()).retrieveParseHints().size() > 0 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RESOURCE_TAXONOMIC_SCOPE_MISMATCH(), 1)) : BoxedUnit.UNIT;
                            } else {
                                this.logger().info(new StringBuilder().append((Object)"Conflict in matched classification. Matched: ").append((Object)guid).append((Object)", Matched: ").append((Object)comment2).append((Object)", Taxonomic hints in use: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])taxonHints).toList()).toString());
                                hintsPassed = false;
                                processed.classification().nameMatchMetric_$eq("matchFailedHint");
                                object = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.RESOURCE_TAXONOMIC_SCOPE_MISMATCH(), comment2));
                            }
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                    boolean bl = hasDefaultMatch = processed.defaultValuesUsed() && nsr.getRank() != null && this.hasMatchToDefault(nsr.getRank().getRank(), nsr.getRankClassification().getScientificName(), processed.classification());
                    if (hintsPassed) {
                        processed.classification_$eq(BiocacheConversions$.MODULE$.asClassification(nsr));
                    }
                    if (hasDefaultMatch) {
                        processed.classification().nameMatchMetric_$eq("defaultHigherMatch");
                    }
                    if (!(taxonProfile = TaxonProfileDAO$.MODULE$.getByGuid(nsr.getLsid())).isEmpty()) {
                        if (((TaxonProfile)taxonProfile.get()).habitats() != null) {
                            processed.classification().speciesHabitats_$eq(((TaxonProfile)taxonProfile.get()).habitats());
                        }
                    }
                    None$ speciesGroups = None$.MODULE$;
                    this.logger().debug(new StringBuilder().append((Object)"Species groups: ").append(speciesGroups.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final List<String> apply() {
                            return Nil$.MODULE$;
                        }
                    })).toString());
                    if (!speciesGroups.isEmpty() && !((SeqLike)speciesGroups.get()).isEmpty()) {
                        processed.classification().speciesGroups_$eq((String[])((TraversableOnce)speciesGroups.get()).toArray(ClassTag$.MODULE$.apply(String.class)));
                    }
                    String scientificName = raw.classification().scientificName() == null ? (raw.classification().species() == null ? (raw.classification().specificEpithet() == null || raw.classification().genus() == null ? null : new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).toString()) : raw.classification().species()) : raw.classification().scientificName();
                    this.setMatchStats(nameMetrics, processed, (ArrayBuffer<QualityAssertion>)assertions);
                    boxedUnit = this.afdApniIdentifier().findFirstMatchIn((CharSequence)nsr.getLsid()).isEmpty() ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_IN_NATIONAL_CHECKLISTS(), "Record not attached to concept in national species lists")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NAME_NOT_IN_NATIONAL_CHECKLISTS(), 1));
                }
            }
            return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Exception during classification match for record ").append((Object)guid).toString(), (Throwable)exception);
            boxedUnit = BoxedUnit.UNIT;
        }
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    @Override
    public String getName() {
        return FullRecordMapper$.MODULE$.taxonomicalQa();
    }

    private final Option term$1(String rank$1) {
        return DwC$.MODULE$.matchTerm(rank$1);
    }

    private final String field$1(String rank$1) {
        return this.term$1(rank$1).isDefined() ? ((Term)this.term$1(rank$1).get()).canonical() : rank$1;
    }

    public ClassificationProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ClassificationProcessor");
        this.afdApniIdentifier = new StringOps(Predef$.MODULE$.augmentString("(:afd.|:apni.)")).r();
        this.questionPattern = new StringOps(Predef$.MODULE$.augmentString("([\\x00-\\x7F\\s]*)\\?([\\x00-\\x7F\\s]*)")).r();
        this.affPattern = new StringOps(Predef$.MODULE$.augmentString("([\\x00-\\x7F\\s]*) aff[#!?\\\\.]?([\\x00-\\x7F\\s]*)")).r();
        this.cfPattern = new StringOps(Predef$.MODULE$.augmentString("([\\x00-\\x7F\\s]*) cf[#!?\\\\.]?([\\x00-\\x7F\\s]*)")).r();
    }
}

